/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output;

import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebuggerCommand;
import org.eclipse.wst.jsdt.chromium.internal.v8native.ScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.ContextlessDebuggerMessage;

public class SetBreakpointMessage
extends ContextlessDebuggerMessage {
    private static final BreakpointImpl.TargetExtendedVisitor<String> GET_TYPE_VISITOR = new BreakpointImpl.TargetExtendedVisitor<String>(){

        @Override
        public String visitFunction(String expression) {
            return "function";
        }

        @Override
        public String visitScriptName(String scriptName) {
            return "script";
        }

        @Override
        public String visitScriptId(Object scriptId) {
            return "scriptId";
        }

        @Override
        public String visitRegExp(String regExp) {
            return "scriptRegExp";
        }

        @Override
        public String visitUnknown(Breakpoint.Target target) {
            throw new IllegalArgumentException();
        }
    };
    private static final BreakpointImpl.TargetExtendedVisitor<Object> GET_TARGET_VISITOR = new BreakpointImpl.TargetExtendedVisitor<Object>(){

        @Override
        public Object visitFunction(String expression) {
            return expression;
        }

        @Override
        public Object visitScriptName(String scriptName) {
            return scriptName;
        }

        @Override
        public Object visitScriptId(Object scriptIdObj) {
            Long scriptId = ScriptManager.convertAlienScriptId(scriptIdObj);
            return scriptId;
        }

        @Override
        public Object visitRegExp(String regExp) {
            return regExp;
        }

        @Override
        public Object visitUnknown(Breakpoint.Target target) {
            throw new IllegalArgumentException();
        }
    };

    public SetBreakpointMessage(Breakpoint.Target target, Integer line, Integer column, Boolean enabled, String condition, Integer ignoreCount) {
        super(DebuggerCommand.SETBREAKPOINT.value);
        this.putArgument("type", target.accept(GET_TYPE_VISITOR));
        this.putArgument("target", target.accept(GET_TARGET_VISITOR));
        this.putArgument("line", line);
        this.putArgument("column", column);
        this.putArgument("enabled", enabled);
        this.putArgument("condition", condition);
        this.putArgument("ignoreCount", ignoreCount);
    }
}

