/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jst.jsf.common.internal.types.NumericTypeLiteral;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;

public class FloatLiteralType
extends NumericTypeLiteral {
    private final double _literalValue;

    public FloatLiteralType(double literalValue) {
        super("D");
        this._literalValue = literalValue;
    }

    @Override
    protected Number getBoxedValue() {
        return new Double(this._literalValue);
    }

    @Override
    public Number coerceToNumber(Class T) throws TypeCoercionException {
        if (T == BigInteger.class) {
            return new BigDecimal(this._literalValue).toBigInteger();
        }
        if (T == BigDecimal.class) {
            return new BigDecimal(this._literalValue);
        }
        Number commonCoercion = super.coerceToNumber(T);
        if (commonCoercion == null) {
            throw new IllegalArgumentException("Not a target numeric type: " + String.valueOf(T));
        }
        return commonCoercion;
    }
}

