/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.cm.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttribute;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.facelet.core.internal.cm.AttributeCMAdapter;
import org.eclipse.jst.jsf.facelet.core.internal.cm.TagInfo;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.AbstractExternalMetadataStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.Messages;
import org.eclipse.jst.jsf.facelet.core.internal.util.ViewUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

public class FaceletExternalMetadataStrategy
extends AbstractExternalMetadataStrategy {
    public static final String STRATEGY_ID = "org.eclipse.jst.jsf.facelet.core.internal.cm.strategy.FaceletExternalMetadataStrategy";
    private final IProject _project;

    public FaceletExternalMetadataStrategy(IProject project) {
        super(STRATEGY_ID, Messages.FaceletExternalMetadataStrategy_0);
        this._project = project;
    }

    @Override
    public TagInfo perform(TagIdentifier input) throws Exception {
        Namespace tagLibrary;
        ITagRegistry tagRegistry = ViewUtil.getTagRegistry(this._project);
        if (tagRegistry != null && (tagLibrary = tagRegistry.getTagLibrary(input.getUri())) != null) {
            return new FaceletInternalInfo(tagLibrary);
        }
        return this.getNoResult();
    }

    private static class FaceletInternalInfo
    extends TagInfo {
        private final Namespace _namespace;

        public FaceletInternalInfo(Namespace namespace) {
            this._namespace = namespace;
        }

        @Override
        public Object getTagProperty(String tagName, String key) {
            "description".equals(key);
            return null;
        }

        @Override
        public CMNamedNodeMap getAttributes(String tagName) {
            ITagElement viewElement = this._namespace.getViewElement(tagName);
            if (viewElement != null) {
                return new MyNodeNameMap(viewElement);
            }
            return null;
        }

        private static class MyNodeNameMap
        implements CMNamedNodeMap {
            private final ITagElement _tagElement;
            private final ArrayList<CMNode> _attrs;

            public MyNodeNameMap(ITagElement tagElement) {
                this._tagElement = tagElement;
                this._attrs = new ArrayList();
                for (Map.Entry entry : this._tagElement.getAttributes().entrySet()) {
                    ITagAttribute attr = (ITagAttribute)entry.getValue();
                    this._attrs.add((CMNode)new AttributeCMAdapter(attr));
                }
            }

            public int getLength() {
                return this._attrs.size();
            }

            public CMNode getNamedItem(String name) {
                if (name == null) {
                    return null;
                }
                for (CMNode cmNode : this._attrs) {
                    if (!name.equals(cmNode.getNodeName())) continue;
                    return cmNode;
                }
                return null;
            }

            public CMNode item(int index) {
                return this._attrs.get(index);
            }

            public Iterator iterator() {
                return Collections.unmodifiableList(this._attrs).iterator();
            }
        }
    }
}

