/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.chromium.JsFunction;
import org.eclipse.wst.jsdt.chromium.JsObject;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.TextStreamPosition;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePosition;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMap;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.VariableBasedAction;

public abstract class OpenFunctionAction
extends VariableBasedAction {
    protected OpenFunctionAction(VariableBasedAction.ElementHandler elementHandler) {
        super(elementHandler);
    }

    @Override
    protected Runnable createRunnable(VariableBasedAction.VariableWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        final ConnectedTargetData connectedTargetData = wrapper.getConnectedTargetData();
        if (connectedTargetData == null) {
            return null;
        }
        final JsFunction jsFunction = this.getJsFunctionFromElement(wrapper);
        if (jsFunction == null) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                IEditorPart editor;
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                ISourceLocator sourceLocator = connectedTargetData.getDebugTarget().getLaunch().getSourceLocator();
                if (!(sourceLocator instanceof ISourceLookupDirector)) {
                    return;
                }
                ISourceLookupDirector director = (ISourceLookupDirector)sourceLocator;
                SourcePositionMap positionMap = connectedTargetData.getSourcePositionMap();
                Script script = jsFunction.getScript();
                if (script == null) {
                    return;
                }
                TextStreamPosition functionOpenParenPosition = jsFunction.getOpenParenPosition();
                if (functionOpenParenPosition == null) {
                    return;
                }
                SourcePosition userPosition = positionMap.translatePosition(VmResourceId.forScript((Script)script), functionOpenParenPosition.getLine(), functionOpenParenPosition.getColumn(), SourcePositionMap.TranslateDirection.VM_TO_USER);
                Object sourceObject = director.getSourceElement((Object)userPosition.getId());
                if (!(sourceObject instanceof IFile)) {
                    return;
                }
                IFile resource = (IFile)sourceObject;
                try {
                    editor = IDE.openEditor((IWorkbenchPage)activeWorkbenchWindow.getActivePage(), (IFile)resource, (boolean)true);
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
                if (!(editor instanceof ITextEditor)) {
                    return;
                }
                ITextEditor textEditor = (ITextEditor)editor;
                int offset = this.calculateOffset(textEditor, userPosition);
                textEditor.selectAndReveal(offset, 0);
            }

            private int calculateOffset(ITextEditor editor, SourcePosition userPosition) {
                int lineStartOffset;
                IDocumentProvider provider = editor.getDocumentProvider();
                IDocument document = provider.getDocument((Object)editor.getEditorInput());
                try {
                    lineStartOffset = document.getLineOffset(userPosition.getLine());
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
                return lineStartOffset + userPosition.getColumn();
            }
        };
    }

    private JsFunction getJsFunctionFromElement(VariableBasedAction.VariableWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        Value uiValue = wrapper.getValue();
        if (uiValue == null) {
            return null;
        }
        JsValue jsValue = uiValue.getJsValue();
        if (jsValue == null) {
            return null;
        }
        JsObject jsObject = jsValue.asObject();
        if (jsObject == null) {
            return null;
        }
        return jsObject.asFunction();
    }

    public static class ForExpression
    extends OpenFunctionAction {
        public ForExpression() {
            super(EXPRESSION_VIEW_ELEMENT_HANDLER);
        }
    }

    public static class ForVariable
    extends OpenFunctionAction {
        public ForVariable() {
            super(VARIABLE_VIEW_ELEMENT_HANDLER);
        }
    }
}

