/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.javascript.jscomp.Tracer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class CompilerExecutor {
    private static final long COMPILER_STACK_SIZE = 0x200000L;
    private static final ExecutorService compilerExecutor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(null, r, "jscompiler", 0x200000L);
            t.setDaemon(true);
            return t;
        }
    });
    private Thread compilerThread = null;
    private boolean useThreads = true;
    private int timeout = 0;

    CompilerExecutor() {
    }

    void disableThreads() {
        this.useThreads = false;
    }

    void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T runInCompilerThread(final Callable<T> callable, final boolean dumpTraceReport) {
        T result = null;
        final Throwable[] exception = new Throwable[1];
        Preconditions.checkState((this.compilerThread == null || this.compilerThread == Thread.currentThread() ? 1 : 0) != 0, (Object)"Please do not share the Compiler across threads");
        if (this.useThreads && this.compilerThread == null) {
            try {
                Callable bootCompilerThread = new Callable<T>(){

                    @Override
                    public T call() {
                        try {
                            CompilerExecutor.this.compilerThread = Thread.currentThread();
                            if (dumpTraceReport) {
                                Tracer.initCurrentThreadTrace();
                            }
                            Object v = callable.call();
                            return v;
                        }
                        catch (Throwable e) {
                            exception[0] = e;
                        }
                        finally {
                            CompilerExecutor.this.compilerThread = null;
                            if (dumpTraceReport) {
                                Tracer.logCurrentThreadTrace();
                            }
                            Tracer.clearCurrentThreadTrace();
                        }
                        return null;
                    }
                };
                Future future = compilerExecutor.submit(bootCompilerThread);
                if (this.timeout > 0) {
                    result = future.get(this.timeout, TimeUnit.SECONDS);
                }
                result = future.get();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            try {
                result = callable.call();
            }
            catch (Exception e) {
                exception[0] = e;
            }
            finally {
                Tracer.clearCurrentThreadTrace();
            }
        }
        if (exception[0] != null) {
            Throwables.propagate((Throwable)exception[0]);
        }
        return result;
    }
}

