/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FromActionType;
import org.eclipse.jst.jsf.facesconfig.emf.FromOutcomeType;
import org.eclipse.jst.jsf.facesconfig.emf.FromViewIdType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;
import org.eclipse.jst.jsf.facesconfig.emf.ToViewIdType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteNavigationRuleTestCase
extends BaseWriteTestCase {
    protected static final String NAVIGATION_RULE = "navigation-rule";
    private static final String FROM_VIEW_ID = "from-view-id";
    private static final String FROM_VIEW_ID_ID = CommonStructuresUtil.createPreficedString("from-view-id", "id");
    private static final String NAVIGATION_RULE_ID = CommonStructuresUtil.createPreficedString("navigation-rule", "id");
    private static final String NAVIGATION_CASE = "navigation-case";
    private static final String FROM_ACTION = "from-action";
    private static final String NAVIGATION_CASE_FROM_ACTION = CommonStructuresUtil.createPreficedString("navigation-case", "from-action");
    private static final String FROM_OUTCOME = "from-outcome";
    private static final String NAVIGATION_CASE_FROM_OUTCOME = CommonStructuresUtil.createPreficedString("navigation-case", "from-outcome");
    private static final String TO_VIEW_ID = "from-view-id";
    private static final String NAVIGATION_CASE_TO_VIEW_ID = CommonStructuresUtil.createPreficedString("navigation-case", "from-view-id");

    public WriteNavigationRuleTestCase(String name) {
        super(name);
    }

    public void testWriteNavigationRule() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteNavigationRuleTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            NavigationRuleType navigationRule = facesConfigFactory.createNavigationRuleType();
            navigationRule.getDescription().add((Object)CommonStructuresUtil.createDescription(NAVIGATION_RULE));
            navigationRule.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(NAVIGATION_RULE));
            navigationRule.getIcon().add((Object)CommonStructuresUtil.createIcon(NAVIGATION_RULE));
            FromViewIdType fromViewIdType = facesConfigFactory.createFromViewIdType();
            fromViewIdType.setTextContent("from-view-id");
            fromViewIdType.setId(FROM_VIEW_ID_ID);
            navigationRule.setFromViewId(fromViewIdType);
            NavigationCaseType navCaseType = facesConfigFactory.createNavigationCaseType();
            navCaseType.getDescription().add((Object)CommonStructuresUtil.createDescription(NAVIGATION_CASE));
            navCaseType.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(NAVIGATION_CASE));
            navCaseType.getIcon().add((Object)CommonStructuresUtil.createIcon(NAVIGATION_CASE));
            FromActionType fromActionType = facesConfigFactory.createFromActionType();
            fromActionType.setTextContent(NAVIGATION_CASE_FROM_ACTION);
            fromActionType.setId(CommonStructuresUtil.createPreficedString(NAVIGATION_CASE_FROM_ACTION, "id"));
            navCaseType.setFromAction(fromActionType);
            FromOutcomeType fromOutcomeType = facesConfigFactory.createFromOutcomeType();
            fromOutcomeType.setTextContent(NAVIGATION_CASE_FROM_OUTCOME);
            fromOutcomeType.setId(CommonStructuresUtil.createPreficedString(NAVIGATION_CASE_FROM_OUTCOME, "id"));
            navCaseType.setFromOutcome(fromOutcomeType);
            ToViewIdType toViewIdType = facesConfigFactory.createToViewIdType();
            toViewIdType.setTextContent(NAVIGATION_CASE_TO_VIEW_ID);
            toViewIdType.setId(CommonStructuresUtil.createPreficedString(NAVIGATION_CASE_TO_VIEW_ID, "id"));
            navCaseType.setToViewId(toViewIdType);
            navigationRule.getNavigationCase().add((Object)navCaseType);
            navigationRule.setId(NAVIGATION_RULE_ID);
            edit.getFacesConfig().getNavigationRule().add((Object)navigationRule);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteNavigationRuleTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteNavigationRuleTestCase.assertNotNull((Object)edit.getFacesConfig());
            NavigationRuleType navigationRule = (NavigationRuleType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getNavigationRule(), NAVIGATION_RULE_ID);
            WriteNavigationRuleTestCase.assertNotNull((Object)navigationRule);
            WriteNavigationRuleTestCase.assertEquals((int)1, (int)navigationRule.getDescription().size());
            CommonStructuresUtil.assertMatchesDescription(NAVIGATION_RULE, (DescriptionType)navigationRule.getDescription().get(0));
            WriteNavigationRuleTestCase.assertEquals((int)1, (int)navigationRule.getDisplayName().size());
            CommonStructuresUtil.assertMatchesDisplayName(NAVIGATION_RULE, (DisplayNameType)navigationRule.getDisplayName().get(0));
            WriteNavigationRuleTestCase.assertEquals((int)1, (int)navigationRule.getIcon().size());
            CommonStructuresUtil.assertMatchesIcon(NAVIGATION_RULE, (IconType)navigationRule.getIcon().get(0));
            FromViewIdType fromViewIdType = navigationRule.getFromViewId();
            WriteNavigationRuleTestCase.assertEquals((String)"from-view-id", (String)fromViewIdType.getTextContent());
            WriteNavigationRuleTestCase.assertEquals((String)FROM_VIEW_ID_ID, (String)fromViewIdType.getId());
            WriteNavigationRuleTestCase.assertEquals((int)1, (int)navigationRule.getNavigationCase().size());
            NavigationCaseType navCaseType = (NavigationCaseType)navigationRule.getNavigationCase().get(0);
            WriteNavigationRuleTestCase.assertEquals((int)1, (int)navCaseType.getDescription().size());
            CommonStructuresUtil.assertMatchesDescription(NAVIGATION_CASE, (DescriptionType)navCaseType.getDescription().get(0));
            WriteNavigationRuleTestCase.assertEquals((int)1, (int)navCaseType.getDisplayName().size());
            CommonStructuresUtil.assertMatchesDisplayName(NAVIGATION_CASE, (DisplayNameType)navCaseType.getDisplayName().get(0));
            WriteNavigationRuleTestCase.assertEquals((int)1, (int)navCaseType.getIcon().size());
            CommonStructuresUtil.assertMatchesIcon(NAVIGATION_CASE, (IconType)navCaseType.getIcon().get(0));
            navCaseType.getIcon().add((Object)CommonStructuresUtil.createIcon(NAVIGATION_CASE));
            FromActionType fromActionType = navCaseType.getFromAction();
            WriteNavigationRuleTestCase.assertEquals((String)NAVIGATION_CASE_FROM_ACTION, (String)fromActionType.getTextContent());
            WriteNavigationRuleTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(NAVIGATION_CASE_FROM_ACTION, "id"), (String)fromActionType.getId());
            FromOutcomeType fromOutcomeType = navCaseType.getFromOutcome();
            WriteNavigationRuleTestCase.assertEquals((String)NAVIGATION_CASE_FROM_OUTCOME, (String)fromOutcomeType.getTextContent());
            WriteNavigationRuleTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(NAVIGATION_CASE_FROM_OUTCOME, "id"), (String)fromOutcomeType.getId());
            ToViewIdType toViewIdType = navCaseType.getToViewId();
            WriteNavigationRuleTestCase.assertEquals((String)NAVIGATION_CASE_TO_VIEW_ID, (String)toViewIdType.getTextContent());
            WriteNavigationRuleTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(NAVIGATION_CASE_TO_VIEW_ID, "id"), (String)toViewIdType.getId());
            WriteNavigationRuleTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(NAVIGATION_RULE, "id"), (String)navigationRule.getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

