/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Iterator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaTokenComparator;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;

public class CUCorrectionProposal
extends ChangeCorrectionProposal {
    private IJavaScriptUnit fCompilationUnit;
    private LinkedProposalModel fLinkedProposalModel;
    private final int surroundLines = 1;

    public CUCorrectionProposal(String name, IJavaScriptUnit cu, TextChange change, int relevance, Image image) {
        super(name, (Change)change, relevance, image);
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        this.fCompilationUnit = cu;
        this.fLinkedProposalModel = null;
    }

    protected CUCorrectionProposal(String name, IJavaScriptUnit cu, int relevance, Image image) {
        this(name, cu, null, relevance, image);
    }

    protected void addEdits(IDocument document, TextEdit editRoot) throws CoreException {
    }

    protected LinkedProposalModel getLinkedProposalModel() {
        if (this.fLinkedProposalModel == null) {
            this.fLinkedProposalModel = new LinkedProposalModel();
        }
        return this.fLinkedProposalModel;
    }

    protected void setLinkedProposalModel(LinkedProposalModel model) {
        this.fLinkedProposalModel = model;
    }

    @Override
    public String getAdditionalProposalInfo() {
        StringBuffer buf = new StringBuffer();
        try {
            TextChange change = this.getTextChange();
            IDocument previewContent = change.getPreviewDocument((IProgressMonitor)new NullProgressMonitor());
            String currentConentString = change.getCurrentContent((IProgressMonitor)new NullProgressMonitor());
            JavaTokenComparator leftSide = new JavaTokenComparator(previewContent.get());
            JavaTokenComparator rightSide = new JavaTokenComparator(currentConentString);
            RangeDifference[] differences = RangeDifferencer.findRanges((IRangeComparator)((IRangeComparator)leftSide), (IRangeComparator)((IRangeComparator)rightSide));
            int i = 0;
            while (i < differences.length) {
                RangeDifference curr = differences[i];
                int start = leftSide.getTokenStart(curr.leftStart());
                int end = leftSide.getTokenStart(curr.leftEnd());
                if (curr.kind() == 2 && curr.leftLength() > 0) {
                    buf.append("<b>");
                    this.appendContent(previewContent, start, end, buf, false);
                    buf.append("</b>");
                } else if (curr.kind() == 0) {
                    this.appendContent(previewContent, start, end, buf, true);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
        return buf.toString();
    }

    private void appendContent(IDocument text, int startOffset, int endOffset, StringBuffer buf, boolean surroundLinesOnly) throws BadLocationException {
        int startLine = text.getLineOfOffset(startOffset);
        int endLine = text.getLineOfOffset(endOffset);
        boolean dotsAdded = false;
        if (surroundLinesOnly && startOffset == 0) {
            startLine = Math.max(endLine - 1, 0);
            buf.append("...<br>");
            dotsAdded = true;
        }
        int i = startLine;
        while (i <= endLine) {
            if (surroundLinesOnly && i - startLine > 1 && endLine - i > 1) {
                if (!dotsAdded) {
                    buf.append("...<br>");
                    dotsAdded = true;
                } else if (endOffset == text.getLength()) {
                    return;
                }
            } else {
                IRegion lineInfo = text.getLineInformation(i);
                int start = lineInfo.getOffset();
                int end = start + lineInfo.getLength();
                int from = Math.max(start, startOffset);
                int to = Math.min(end, endOffset);
                String content = text.get(from, to - from);
                if (!surroundLinesOnly || from != start || !Strings.containsOnlyWhitespaces(content)) {
                    int k = 0;
                    while (k < content.length()) {
                        char ch = content.charAt(k);
                        if (ch == '<') {
                            buf.append("&lt;");
                        } else if (ch == '>') {
                            buf.append("&gt;");
                        } else {
                            buf.append(ch);
                        }
                        ++k;
                    }
                    if (to == end && to != endOffset) {
                        buf.append("<br>");
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void apply(IDocument document) {
        try {
            IJavaScriptUnit unit = this.getCompilationUnit();
            IEditorPart part = null;
            if (unit.getResource().exists()) {
                IWorkbenchPage page;
                boolean canEdit = this.performValidateEdit(unit);
                if (!canEdit) {
                    return;
                }
                part = EditorUtility.isOpenInEditor(unit);
                if (part == null && (part = JavaScriptUI.openInEditor((IJavaScriptElement)unit)) != null) {
                    document = JavaScriptUI.getDocumentProvider().getDocument((Object)part.getEditorInput());
                }
                if ((page = JavaScriptPlugin.getActivePage()) != null && part != null) {
                    page.bringToTop((IWorkbenchPart)part);
                }
                if (part != null) {
                    part.setFocus();
                }
            }
            this.performChange(part, document);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, CorrectionMessages.CUCorrectionProposal_error_title, CorrectionMessages.CUCorrectionProposal_error_message);
        }
    }

    private boolean performValidateEdit(IJavaScriptUnit unit) {
        IStatus status = Resources.makeCommittable(unit.getResource(), (Object)JavaScriptPlugin.getActiveWorkbenchShell());
        if (!status.isOK()) {
            String label = CorrectionMessages.CUCorrectionProposal_error_title;
            String message = CorrectionMessages.CUCorrectionProposal_error_message;
            ErrorDialog.openError((Shell)JavaScriptPlugin.getActiveWorkbenchShell(), (String)label, (String)message, (IStatus)status);
            return false;
        }
        return true;
    }

    @Override
    protected void performChange(IEditorPart part, IDocument document) throws CoreException {
        try {
            super.performChange(part, document);
            if (part == null) {
                return;
            }
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroup.PositionInformation endPosition;
                if (this.fLinkedProposalModel.hasLinkedPositions() && part instanceof JavaEditor) {
                    ISourceViewer viewer = ((JavaEditor)part).getViewer();
                    this.enterLinkedMode((ITextViewer)viewer, part);
                } else if (part instanceof ITextEditor && (endPosition = this.fLinkedProposalModel.getEndPosition()) != null) {
                    int pos = endPosition.getOffset() + endPosition.getLength();
                    ((ITextEditor)part).selectAndReveal(pos, 0);
                }
            }
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }

    private void enterLinkedMode(ITextViewer viewer, IEditorPart editor) throws BadLocationException {
        IDocument document = viewer.getDocument();
        LinkedModeModel model = new LinkedModeModel();
        boolean added = false;
        Iterator iterator = this.fLinkedProposalModel.getPositionGroupIterator();
        while (iterator.hasNext()) {
            LinkedProposalPositionGroup curr = (LinkedProposalPositionGroup)iterator.next();
            LinkedPositionGroup group = new LinkedPositionGroup();
            LinkedProposalPositionGroup.PositionInformation[] positions = curr.getPositions();
            if (positions.length <= 0) continue;
            LinkedProposalPositionGroup.Proposal[] linkedModeProposals = curr.getProposals();
            if (linkedModeProposals.length <= 1) {
                int i = 0;
                while (i < positions.length) {
                    LinkedProposalPositionGroup.PositionInformation pos = positions[i];
                    if (pos.getOffset() != -1) {
                        group.addPosition(new LinkedPosition(document, pos.getOffset(), pos.getLength(), pos.getSequenceRank()));
                    }
                    ++i;
                }
            } else {
                ICompletionProposal[] proposalImpls = new LinkedPositionProposalImpl[linkedModeProposals.length];
                int i = 0;
                while (i < linkedModeProposals.length) {
                    proposalImpls[i] = new LinkedPositionProposalImpl(linkedModeProposals[i], model);
                    ++i;
                }
                i = 0;
                while (i < positions.length) {
                    LinkedProposalPositionGroup.PositionInformation pos = positions[i];
                    if (pos.getOffset() != -1) {
                        group.addPosition((LinkedPosition)new ProposalPosition(document, pos.getOffset(), pos.getLength(), pos.getSequenceRank(), proposalImpls));
                    }
                    ++i;
                }
            }
            model.addGroup(group);
            added = true;
        }
        model.forceInstall();
        if (editor instanceof JavaEditor) {
            model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer((JavaEditor)editor));
        }
        if (added) {
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            LinkedProposalPositionGroup.PositionInformation endPosition = this.fLinkedProposalModel.getEndPosition();
            if (endPosition != null && endPosition.getOffset() != -1) {
                ui.setExitPosition(viewer, endPosition.getOffset() + endPosition.getLength(), 0, Integer.MAX_VALUE);
            } else {
                int cursorPosition = viewer.getSelectedRange().x;
                if (cursorPosition != 0) {
                    ui.setExitPosition(viewer, cursorPosition, 0, Integer.MAX_VALUE);
                }
            }
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new LinkedModeExitPolicy());
            ui.enter();
            IRegion region = ui.getSelectedRegion();
            viewer.setSelectedRange(region.getOffset(), region.getLength());
            viewer.revealRange(region.getOffset(), region.getLength());
        }
    }

    protected TextChange createTextChange() throws CoreException {
        CompilationUnitChange change;
        Document document;
        IJavaScriptUnit cu = this.getCompilationUnit();
        String name = this.getName();
        if (!cu.getResource().exists()) {
            String source;
            try {
                source = cu.getSource();
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
                source = new String();
            }
            document = new Document(source);
            document.setInitialLineDelimiter(StubUtility.getLineDelimiterUsed((IJavaScriptElement)cu));
            change = new DocumentChange(name, (IDocument)document);
        } else {
            CompilationUnitChange cuChange = new CompilationUnitChange(name, cu);
            cuChange.setSaveMode(4);
            change = cuChange;
        }
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        document = change.getCurrentDocument((IProgressMonitor)new NullProgressMonitor());
        this.addEdits((IDocument)document, (TextEdit)rootEdit);
        return change;
    }

    @Override
    protected final Change createChange() throws CoreException {
        return this.createTextChange();
    }

    public final TextChange getTextChange() throws CoreException {
        return (TextChange)this.getChange();
    }

    public final IJavaScriptUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getPreviewContent() throws CoreException {
        return this.getTextChange().getPreviewContent((IProgressMonitor)new NullProgressMonitor());
    }

    public String toString() {
        try {
            return this.getPreviewContent();
        }
        catch (CoreException coreException) {
            return super.toString();
        }
    }

    private static class LinkedModeExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private LinkedModeExitPolicy() {
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == '=') {
                return new LinkedModeUI.ExitFlags(1, true);
            }
            return null;
        }
    }

    private static class LinkedPositionProposalImpl
    implements ICompletionProposalExtension2,
    IJavaCompletionProposal {
        private final LinkedProposalPositionGroup.Proposal fProposal;
        private final LinkedModeModel fLinkedPositionModel;

        public LinkedPositionProposalImpl(LinkedProposalPositionGroup.Proposal proposal, LinkedModeModel model) {
            this.fProposal = proposal;
            this.fLinkedPositionModel = model;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            IDocument doc = viewer.getDocument();
            LinkedPosition position = this.fLinkedPositionModel.findPosition(new LinkedPosition(doc, offset, 0));
            if (position != null) {
                try {
                    try {
                        TextEdit edit = this.fProposal.computeEdits(offset, position, trigger, stateMask, this.fLinkedPositionModel);
                        if (edit != null) {
                            edit.apply(position.getDocument(), 0);
                        }
                    }
                    catch (MalformedTreeException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, "Unexpected exception applying edit", (Throwable)e));
                    }
                    catch (BadLocationException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, "Unexpected exception applying edit", (Throwable)e));
                    }
                }
                catch (CoreException e) {
                    JavaScriptPlugin.log(e);
                }
            }
        }

        public String getDisplayString() {
            return this.fProposal.getDisplayString();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }

        @Override
        public int getRelevance() {
            return this.fProposal.getRelevance();
        }

        public void apply(IDocument document) {
        }

        public String getAdditionalProposalInfo() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            String insert = this.getDisplayString();
            LinkedPosition pos = this.fLinkedPositionModel.findPosition(new LinkedPosition(document, offset, 0));
            int off = pos != null ? pos.getOffset() : Math.max(0, offset - insert.length());
            int length = offset - off;
            if (offset <= document.getLength()) {
                try {
                    String content = document.get(off, length);
                    if (insert.startsWith(content)) {
                        return true;
                    }
                }
                catch (BadLocationException e) {
                    JavaScriptPlugin.log(e);
                }
            }
            return false;
        }
    }
}

