/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.emf.workbench;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.util.emf.workbench.EMFWorkbenchContextFactory;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;

public class ResourceSetWorkbenchSynchronizer
implements IResourceChangeListener {
    protected IProject project;
    protected ResourceSet resourceSet;
    protected QueuingHashSet<ISynchronizerExtender> extenders;
    protected IResourceDelta currentProjectDelta;
    private int currentEventType = -1;

    public ResourceSetWorkbenchSynchronizer(ResourceSet aResourceSet, IProject aProject) {
        this.resourceSet = aResourceSet;
        this.project = aProject;
        if (aResourceSet != null && aResourceSet instanceof ProjectResourceSet) {
            ((ProjectResourceSet)aResourceSet).setSynchronizer(this);
        }
        this.initialize();
    }

    public IProject getProject() {
        return this.project;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.currentEventType = event.getType();
        this.currentProjectDelta = null;
        if ((this.currentEventType == 2 || this.currentEventType == 4) && event.getResource().equals((Object)this.getProject())) {
            this.notifyExtendersOfClose();
            this.release();
        }
    }

    protected void notifyExtendersIfNecessary() {
        if (this.currentEventType != 1 || this.currentProjectDelta == null) {
            return;
        }
        if (this.extenders != null) {
            Set<ISynchronizerExtender> extendersToNotify = this.extenders;
            while (!extendersToNotify.isEmpty()) {
                try {
                    this.extenders.startQueuing();
                    for (ISynchronizerExtender extender : extendersToNotify) {
                        extender.projectChanged(this.currentProjectDelta);
                    }
                }
                finally {
                    extendersToNotify = this.extenders.stopQueuing();
                }
            }
        }
    }

    protected void notifyExtendersOfClose() {
        if (this.extenders != null) {
            Set<ISynchronizerExtender> extendersToNotify = this.extenders;
            while (!extendersToNotify.isEmpty()) {
                try {
                    this.extenders.startQueuing();
                    for (ISynchronizerExtender extender : extendersToNotify) {
                        extender.projectClosed();
                    }
                }
                finally {
                    extendersToNotify = this.extenders.stopQueuing();
                }
            }
        }
    }

    protected IWorkspace getWorkspace() {
        if (this.getProject() == null) {
            return ResourcesPlugin.getWorkspace();
        }
        return this.getProject().getWorkspace();
    }

    protected void initialize() {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 15);
    }

    public void dispose() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected void release() {
        if (JEMUtilPlugin.isActivated()) {
            try {
                if (this.resourceSet instanceof ProjectResourceSet) {
                    ((ProjectResourceSet)this.resourceSet).release();
                }
            }
            finally {
                EMFWorkbenchContextFactory.INSTANCE.removeCachedProject(this.getProject());
                this.dispose();
            }
        }
    }

    public void addExtender(ISynchronizerExtender extender) {
        if (this.extenders == null) {
            this.extenders = new QueuingHashSet(3);
        }
        this.extenders.add(extender);
    }

    public void removeExtender(ISynchronizerExtender extender) {
        if (this.extenders == null) {
            return;
        }
        this.extenders.remove(extender);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '(' + (this.getProject() != null ? this.getProject().getName() : "null") + ')';
    }

    public void preSave(IFile aFile) {
    }

    protected class QueuingHashSet<E>
    extends HashSet<E> {
        private static final long serialVersionUID = 6959354060950816784L;
        private Object lock;
        private boolean queuing;
        private Set<E> addQueue;
        private Set removeQueue;
        private int initialCapacity;

        public QueuingHashSet(int capacity) {
            super(capacity);
            this.lock = new Object();
            this.queuing = false;
            this.addQueue = null;
            this.removeQueue = null;
            this.initialCapacity = 3;
            this.addQueue = new HashSet(capacity);
            this.removeQueue = new HashSet(capacity);
            this.initialCapacity = capacity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startQueuing() {
            Object object = this.lock;
            synchronized (object) {
                if (this.queuing) {
                    throw new UnsupportedOperationException("startQueuing may only be called while not already queuing");
                }
                this.queuing = true;
                this.addQueue.clear();
                this.removeQueue.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<E> stopQueuing() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.queuing) {
                    throw new UnsupportedOperationException("stopQueuing may only be called while queuing");
                }
                this.queuing = false;
                this.removeAll(this.removeQueue);
                this.addAll(this.addQueue);
                if (!this.addQueue.isEmpty()) {
                    Set<E> queue = this.addQueue;
                    this.addQueue = new HashSet(this.initialCapacity);
                    return queue;
                }
                return Collections.emptySet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean add(E object) {
            Object object2 = this.lock;
            synchronized (object2) {
                if (!this.queuing) {
                    return super.add(object);
                }
                if (this.contains(object)) {
                    return false;
                }
                return this.addQueue.add(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                block5: {
                    if (!this.queuing) break block5;
                    if (this.contains(object)) {
                        return this.removeQueue.add(object);
                    }
                    return false;
                }
                return super.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.lock;
            synchronized (object) {
                return super.isEmpty();
            }
        }
    }
}

