/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.meta.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ISupportTextValue;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.StringDialogField;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.meta.ITagAttributeCellEditorFactory;
import org.eclipse.jst.pagedesigner.meta.internal.CellEditorFacRegistryReader;
import org.eclipse.jst.pagedesigner.properties.celleditors.CellEditorFactory;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Element;

public class CellEditorFactoryRegistry {
    private static CellEditorFactoryRegistry _instance;
    private Map _factoryMap = new HashMap();
    private List _defaultFactories = new ArrayList();

    public static CellEditorFactoryRegistry getInstance() {
        if (_instance == null) {
            _instance = new CellEditorFactoryRegistry();
        }
        return _instance;
    }

    private CellEditorFactoryRegistry() {
        ITagAttributeCellEditorFactory[] facs = CellEditorFacRegistryReader.getAllFactories();
        if (facs != null) {
            int i = 0;
            while (i < facs.length) {
                this.addCellEditorFactory(facs[i]);
                ++i;
            }
        }
        this.addCellEditorFactory(new CellEditorFactory());
    }

    public void addCellEditorFactory(ITagAttributeCellEditorFactory fac) {
        String[] types = fac.getSupportedValueTypes();
        if (types == null || types.length == 0) {
            this._defaultFactories.add(fac);
        } else {
            int i = 0;
            while (i < types.length) {
                this._factoryMap.put(types[i], fac);
                ++i;
            }
        }
    }

    public CellEditor createCellEditor(Composite parent, IPropertyPageDescriptor attr, Element element) {
        String type = attr.getValueType();
        if (type == null || type.length() == 0) {
            return null;
        }
        CellEditor result = null;
        ITagAttributeCellEditorFactory fac = (ITagAttributeCellEditorFactory)this._factoryMap.get(type);
        if (fac != null) {
            result = fac.createCellEditor(parent, attr, element);
        }
        if (result == null) {
            int i = 0;
            int size = this._defaultFactories.size();
            while (i < size) {
                result = ((ITagAttributeCellEditorFactory)this._defaultFactories.get(i)).createCellEditor(parent, attr, element);
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public DialogField createDialogField(IPropertyPageDescriptor attr) {
        String type = attr.getValueType();
        if (type == null || type.length() == 0) {
            DialogField result = this.createTextDialogField(attr);
            result.setLabelText(attr.getLabel());
            return result;
        }
        DialogField result = null;
        ITagAttributeCellEditorFactory fac = (ITagAttributeCellEditorFactory)this._factoryMap.get(type);
        if (fac != null) {
            result = fac.createDialogField(attr);
        }
        if (result == null) {
            int i = 0;
            int size = this._defaultFactories.size();
            while (i < size) {
                result = ((ITagAttributeCellEditorFactory)this._defaultFactories.get(i)).createDialogField(attr);
                if (result != null) break;
                ++i;
            }
        }
        if (result == null) {
            result = this.createTextDialogField(attr);
        }
        if (!(result instanceof ISupportTextValue)) {
            result = this.createTextDialogField(attr);
        }
        return result;
    }

    public DialogField createTextDialogField(IPropertyPageDescriptor attr) {
        StringDialogField field = new StringDialogField();
        field.setLabelText(attr.getLabel());
        field.setRequired(attr.isRequired());
        field.setToolTip(attr.getDescription());
        return field;
    }
}

