/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.pagedesigner.parts.ElementEditPart;
import org.eclipse.jst.pagedesigner.parts.NonVisualComponentEditPart;

public class ElementMenuBar
extends Figure
implements ISelectionProvider,
ISelectionChangedListener {
    private ElementEditPart _hostPart;
    private Set _childParts;
    private List _selectionListeners;
    private IStructuredSelection _selection;

    public ElementMenuBar(ElementEditPart hostPart) {
        hostPart.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this._hostPart = hostPart;
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setSpacing(4);
        this.setLayoutManager((LayoutManager)layout);
    }

    public boolean hasChildParts() {
        return this._childParts != null && this._childParts.size() > 0;
    }

    public void dispose() {
        this._hostPart.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        if (this._childParts != null) {
            this._childParts.clear();
            this._childParts = null;
        }
        if (this._selectionListeners != null) {
            this._selectionListeners.clear();
            this._selectionListeners = null;
        }
        this._selection = null;
    }

    public void addNonVisualChild(NonVisualComponentEditPart editpart) {
        this.add(editpart.getFigure());
        this.getChildParts().add(editpart);
    }

    public void removeNonVisualChild(NonVisualComponentEditPart editpart) {
        this.getChildParts().remove((Object)editpart);
        if (editpart.getFigure().getParent() == this) {
            this.remove(editpart.getFigure());
        }
    }

    public boolean hasEditPartFocus() {
        for (EditPart editPart : this.getChildParts()) {
            if (editPart.getSelected() != 2) continue;
            return true;
        }
        return false;
    }

    private Set getChildParts() {
        if (this._childParts == null) {
            this._childParts = new HashSet();
        }
        return this._childParts;
    }

    protected void paintChildren(Graphics graphics) {
        graphics.setAlpha(this.getAlpha());
        graphics.pushState();
        super.paintChildren(graphics);
        graphics.popState();
    }

    private int getAlpha() {
        return this.isEnabled() ? 255 : 75;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        List listeners = this.getSelectionListeners();
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this._selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getSelectionListeners().remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    private List getSelectionListeners() {
        if (this._selectionListeners == null) {
            this._selectionListeners = new ArrayList(1);
        }
        return this._selectionListeners;
    }

    private void fireSelectionChanged() {
        for (ISelectionChangedListener listener : this._selectionListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this._selection));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            ArrayList mySelections = new ArrayList(((IStructuredSelection)selection).size());
            if (this._childParts != null) {
                for (Object selectedObj : (IStructuredSelection)selection) {
                    if (!this._childParts.contains(selectedObj)) continue;
                    mySelections.add(selectedObj);
                }
            }
            this._selection = new StructuredSelection(mySelections);
            this.fireSelectionChanged();
        }
    }
}

