/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jst.pagedesigner.css2.layout.BlockBox;
import org.eclipse.jst.pagedesigner.css2.layout.BlockFlow;
import org.eclipse.jst.pagedesigner.css2.layout.FlowContainerLayout;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;

public class BlockFlowLayout
extends FlowContainerLayout {
    private LineBox _previousLine = null;
    BlockBox _blockBox;

    public BlockFlowLayout(BlockFlow blockFlow) {
        super(blockFlow);
    }

    @Override
    protected void cleanup() {
        this._previousLine = null;
        this._currentLine = null;
    }

    @Override
    protected void createNewLine() {
        this._currentLine = new LineBox();
        this.setupLine(this._currentLine, Integer.MIN_VALUE);
    }

    @Override
    protected void createNewLine(int topmargin) {
        this._currentLine = new LineBox();
        this.setupLine(this._currentLine, topmargin);
    }

    protected void setupLine(LineBox line, int topMargin) {
        line.clear();
        line._x = 0;
        line.setRecommendedWidth(this._blockBox.getRecommendedContentWidth());
        if (this._previousLine == null) {
            line._y = 0;
            if (topMargin != Integer.MIN_VALUE) {
                line._y += topMargin;
            }
        } else {
            line._y = topMargin == Integer.MIN_VALUE ? this._previousLine._y + this._previousLine.getHeight() + this.getLinePadding() + this._previousLine.getMarginInsets().bottom : this._previousLine._y + this._previousLine.getHeight() + Math.max(topMargin, this._previousLine.getMarginInsets().bottom);
        }
    }

    protected void endBlock() {
        this.getFlowContext().addToCurrentLine(this._blockBox);
        this.getFlowContext().endLine();
    }

    @Override
    public void endLine() {
        LineBox box;
        if (this._currentLine == null) {
            return;
        }
        if (!this._currentLine.isOccupied()) {
            this._currentLine = null;
            return;
        }
        this.layoutLine();
        this._previousLine = box = this._currentLine;
        this._currentLine = null;
    }

    @Override
    public int getCurrentY() {
        return this.getCurrentLine()._y;
    }

    protected final BlockFlow getBlockFlow() {
        return (BlockFlow)this.getFlowFigure();
    }

    protected void layoutLine() {
        switch (this.getBlockFlow().getHorizontalAligment()) {
            case 4: {
                this._currentLine._x = this._blockBox.getContentWidth() - this.getBorderPaddingInsets().right - this._currentLine.getWidth();
                break;
            }
            case 2: {
                this._currentLine._x = (this._blockBox.getContentWidth() + this.getBorderPaddingInsets().left - this.getBorderPaddingInsets().right - this._currentLine.getWidth()) / 2;
            }
        }
        this._currentLine.commit();
        this._blockBox.add(this._currentLine);
    }

    @Override
    protected void flush() {
        if (this._currentLine != null) {
            this.layoutLine();
        }
        this.endBlock();
    }

    @Override
    protected void preLayout() {
        this._blockBox = this.getBlockFlow().getBlockBox();
        this.setupBlock();
    }

    protected void setupBlock() {
        this.getFlowContext().endLine();
        LineBox line = this.getFlowContext().getCurrentLine();
        this._blockBox.clear();
        this._blockBox.setRecommendedWidth(line.getAvailableWidth());
        this._blockBox._y = this.getFlowContext().getCurrentY();
        this._blockBox._x = 0;
    }

    Insets getBorderPaddingInsets() {
        return new Insets();
    }

    int getLinePadding() {
        return 0;
    }

    @Override
    public void dispose() {
    }

    @Override
    public int getContainerWidth() {
        int width = Math.max(0, Math.max(this._blockBox.getWidth(), this._blockBox.getRecommendedWidth()));
        return width;
    }
}

