/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;

public class RelaySyncCallback {
    private final SyncCallback syncCallback;
    private static final RelayOk FINISH_RELAY_OK = new RelayOk(){};

    public RelaySyncCallback(SyncCallback syncCallback) {
        this.syncCallback = syncCallback;
    }

    public Guard newGuard() {
        return new Guard();
    }

    public SyncCallback getUserSyncCallback() {
        return this.syncCallback;
    }

    public RelayOk finish() {
        return RelaySyncCallback.finish(this.syncCallback);
    }

    public static RelayOk finish(SyncCallback syncCallback) {
        if (syncCallback != null) {
            syncCallback.callbackDone(null);
        }
        return FINISH_RELAY_OK;
    }

    public class Guard {
        private final AtomicBoolean discharged = new AtomicBoolean(false);
        private final SyncCallback innerSyncCallback = new SyncCallback(){

            @Override
            public void callbackDone(RuntimeException e) {
                boolean updated = Guard.this.discharged.compareAndSet(false, true);
                if (updated && RelaySyncCallback.this.syncCallback != null) {
                    RelaySyncCallback.this.syncCallback.callbackDone(e);
                }
            }
        };

        public void discharge(RelayOk relayed) {
            this.discharged.set(true);
        }

        public SyncCallback asSyncCallback() {
            return this.innerSyncCallback;
        }

        public RelaySyncCallback getRelay() {
            return RelaySyncCallback.this;
        }
    }
}

