/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.FieldLoadStrategy;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonField;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonNullable;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonObjectBased;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonOptionalField;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonOverrideField;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolModelParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtype;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtypeCasting;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.BaseHandlersLibrary;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.EnumParser;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.FieldCondition;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.FieldConditionLogic;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.FieldLoadedFinisher;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.FieldLoader;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.FieldTypeInfo;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.GeneratedCodeMap;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JavaCodeGenerator;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JsonTypeParser;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.MethodHandler;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.ObjectData;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.ParserRootImpl;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.QuickParser;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.RefToType;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.SlowParser;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.SubtypeCaster;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.TypeHandler;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.implutil.CommonImpl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class DynamicParserImpl<ROOT> {
    private final Map<Class<?>, TypeHandler<?>> type2TypeHandler;
    private final ParserRootImpl<ROOT> rootImpl;
    static SlowParser<Void> VOID_PARSER = new QuickParser<Void>(){

        @Override
        public Void parseValueQuick(Object value) {
            return null;
        }

        @Override
        public void appendFinishedValueTypeNameJava(JavaCodeGenerator.FileScope scope) {
            scope.append("Void");
        }

        @Override
        void writeParseQuickCode(JavaCodeGenerator.MethodScope scope, String valueRef, String resultRef) {
            scope.startLine("Void " + resultRef + " = null;\n");
        }

        @Override
        boolean javaCodeThrowsException() {
            return false;
        }
    };
    private static final SimpleParserPair<Long> LONG_PARSER = SimpleParserPair.create(Long.class);
    private static final SimpleParserPair<Boolean> BOOLEAN_PARSER = SimpleParserPair.create(Boolean.class);
    private static final SimpleParserPair<Float> FLOAT_PARSER = SimpleParserPair.create(Float.class);
    private static final SimpleParserPair<Number> NUMBER_PARSER = SimpleParserPair.create(Number.class);
    private static final SimpleParserPair<String> STRING_PARSER = SimpleParserPair.create(String.class);
    private static final SimpleParserPair<Object> OBJECT_PARSER = SimpleParserPair.create(Object.class);
    private static final SimpleParserPair<JSONObject> JSON_PARSER = SimpleParserPair.create(JSONObject.class);
    static MethodHandler RETURN_NULL_METHOD_HANDLER = new MethodHandler(){

        @Override
        Object handle(ObjectData objectData, Object[] args) throws Throwable {
            return null;
        }

        @Override
        void writeMethodImplementationJava(JavaCodeGenerator.ClassScope scope, Method m) {
            2.writeMethodDeclarationJava(scope, m, Collections.emptyList());
            scope.append(" {\n");
            scope.startLine("}\n");
        }
    };

    public DynamicParserImpl(Class<ROOT> parserRootClass, List<Class<?>> protocolInterfaces) throws JsonProtocolModelParseException {
        this(parserRootClass, protocolInterfaces, Collections.emptyList());
    }

    public DynamicParserImpl(Class<ROOT> parserRootClass, List<? extends Class<?>> protocolInterfaces, List<? extends DynamicParserImpl<?>> basePackages) throws JsonProtocolModelParseException {
        this(parserRootClass, protocolInterfaces, basePackages, false);
    }

    public DynamicParserImpl(Class<ROOT> parserRootClass, List<? extends Class<?>> protocolInterfaces, List<? extends DynamicParserImpl<?>> basePackages, boolean strictMode) throws JsonProtocolModelParseException {
        this.type2TypeHandler = DynamicParserImpl.readTypes(protocolInterfaces, basePackages, strictMode);
        this.rootImpl = new ParserRootImpl<ROOT>(parserRootClass, this.type2TypeHandler);
    }

    public ROOT getParserRoot() {
        return this.rootImpl.getInstance();
    }

    private static Map<Class<?>, TypeHandler<?>> readTypes(List<? extends Class<?>> protocolInterfaces, List<? extends DynamicParserImpl<?>> basePackages, boolean strictMode) throws JsonProtocolModelParseException {
        ReadInterfacesSession session = new ReadInterfacesSession(protocolInterfaces, basePackages, strictMode);
        session.go();
        return session.getResult();
    }

    public GeneratedCodeMap generateStaticParser(StringBuilder stringBuilder, String packageName, String className) {
        return this.generateStaticParser(stringBuilder, packageName, className, Collections.emptyList());
    }

    public GeneratedCodeMap generateStaticParser(StringBuilder stringBuilder, String packageName, String className, Collection<GeneratedCodeMap> basePackages) {
        JavaCodeGenerator.Impl generator = new JavaCodeGenerator.Impl();
        JavaCodeGenerator.GlobalScope globalScope = generator.newGlobalScope(this.type2TypeHandler.values(), basePackages);
        JavaCodeGenerator.FileScope fileScope = globalScope.newFileScope(stringBuilder);
        fileScope.startLine("// This is a generated source.\n");
        fileScope.startLine("// See " + this.getClass().getName() + " for details\n");
        fileScope.append("\n");
        fileScope.startLine("package " + packageName + ";\n");
        fileScope.append("\n");
        fileScope.startLine("public class " + className + " implements " + this.rootImpl.getType().getCanonicalName() + " {\n");
        JavaCodeGenerator.ClassScope rootClassScope = fileScope.newClassScope();
        rootClassScope.indentRight();
        this.rootImpl.writeStaticMethodJava(rootClassScope);
        for (TypeHandler<?> typeHandler : this.type2TypeHandler.values()) {
            typeHandler.writeStaticClassJava(rootClassScope);
        }
        rootClassScope.writeClassMembers();
        rootClassScope.indentLeft();
        rootClassScope.startLine("}\n");
        HashMap type2ImplClassName = new HashMap();
        for (TypeHandler<?> typeHandler : this.type2TypeHandler.values()) {
            String shortName = fileScope.getTypeImplShortName(typeHandler);
            String fullReference = String.valueOf(packageName) + "." + className + "." + shortName;
            type2ImplClassName.put(typeHandler.getTypeClass(), fullReference);
        }
        return new GeneratedCodeMap(type2ImplClassName);
    }

    static class ArrayParser<T>
    extends SlowParser<List<? extends T>> {
        static final ListFactory EAGER = new ListFactory(){

            @Override
            <T> List<T> create(JSONArray array, SlowParser<T> componentParser) throws JsonProtocolParseException {
                int size = array.size();
                ArrayList<T> list = new ArrayList<T>(size);
                FieldLoadedFinisher valueFinisher = componentParser.getValueFinisher();
                int i = 0;
                while (i < size) {
                    Object val = componentParser.parseValue(array.get(i), null);
                    if (valueFinisher != null) {
                        val = valueFinisher.getValueForUser(val);
                    }
                    list.add(val);
                    ++i;
                }
                return Collections.unmodifiableList(list);
            }

            @Override
            void writeCreateListCode(SlowParser<?> componentParser, JavaCodeGenerator.MethodScope scope, String inputRef, String resultRef) {
                String sizeRef = scope.newMethodScopedName("size");
                String listRef = scope.newMethodScopedName("list");
                String indexRef = scope.newMethodScopedName("index");
                String componentRef = scope.newMethodScopedName("arrayComponent");
                scope.startLine("int " + sizeRef + " = " + inputRef + ".size();\n");
                scope.startLine("java.util.List<");
                componentParser.appendFinishedValueTypeNameJava(scope);
                scope.append("> " + listRef + " = new java.util.ArrayList<");
                componentParser.appendFinishedValueTypeNameJava(scope);
                scope.append(">(" + sizeRef + ");\n");
                scope.startLine("for (int " + indexRef + " = 0; " + indexRef + " < " + sizeRef + "; " + indexRef + "++) {\n");
                scope.indentRight();
                componentParser.writeParseCode(scope, String.valueOf(inputRef) + ".get(" + indexRef + ")", "null", componentRef);
                scope.startLine(String.valueOf(listRef) + ".add(" + componentRef + ");\n");
                scope.indentLeft();
                scope.startLine("}\n");
                scope.startLine("java.util.List<");
                componentParser.appendFinishedValueTypeNameJava(scope);
                scope.append("> " + resultRef + " = java.util.Collections.unmodifiableList(" + listRef + ");\n");
            }
        };
        static final ListFactory LAZY = new ListFactory(){

            @Override
            <T> List<T> create(final JSONArray array, final SlowParser<T> componentParser) {
                final int size = array.size();
                AbstractList list = new AbstractList<T>(){
                    private final AtomicReferenceArray<T> values;
                    {
                        this.values = new AtomicReferenceArray(n);
                    }

                    @Override
                    public synchronized T get(int index) {
                        Object rawObject;
                        Object parsedValue = this.values.get(index);
                        if (parsedValue == null && (rawObject = array.get(index)) != null) {
                            Object parsedObject;
                            try {
                                parsedObject = componentParser.parseValue(array.get(index), null);
                            }
                            catch (JsonProtocolParseException e) {
                                throw new CommonImpl.ParseRuntimeException(e);
                            }
                            FieldLoadedFinisher valueFinisher = componentParser.getValueFinisher();
                            if (valueFinisher != null) {
                                parsedObject = valueFinisher.getValueForUser(parsedObject);
                            }
                            parsedValue = parsedObject;
                            this.values.compareAndSet(index, null, parsedValue);
                            parsedValue = this.values.get(index);
                        }
                        return parsedValue;
                    }

                    @Override
                    public int size() {
                        return size;
                    }
                };
                return list;
            }

            @Override
            void writeCreateListCode(SlowParser<?> componentParser, JavaCodeGenerator.MethodScope scope, String inputRef, String resultRef) {
                String sizeRef = scope.newMethodScopedName("size");
                scope.startLine("final int " + sizeRef + " = " + inputRef + ".size();\n");
                scope.startLine("java.util.List<");
                componentParser.appendFinishedValueTypeNameJava(scope);
                scope.append("> " + resultRef + " = new java.util.AbstractList<");
                componentParser.appendFinishedValueTypeNameJava(scope);
                scope.append(">() {\n");
                scope.indentRight();
                scope.startLine("private final java.util.concurrent.atomic.AtomicReferenceArray<");
                componentParser.appendFinishedValueTypeNameJava(scope);
                scope.append("> cachedValues = new java.util.concurrent.atomic.AtomicReferenceArray<");
                componentParser.appendFinishedValueTypeNameJava(scope);
                scope.append(">(" + sizeRef + ");\n");
                scope.append("\n");
                scope.startLine("@Override public int size() { return " + sizeRef + "; }\n");
                scope.append("\n");
                this.writeGetMethodCode(componentParser, scope, inputRef);
                scope.indentLeft();
                scope.startLine("};\n");
            }

            private void writeGetMethodCode(SlowParser<?> componentParser, JavaCodeGenerator.MethodScope outerMethodScope, String arrayRef) {
                outerMethodScope.startLine("@Override public ");
                componentParser.appendFinishedValueTypeNameJava(outerMethodScope);
                outerMethodScope.append(" get(int index) {\n");
                JavaCodeGenerator.MethodScope scope = outerMethodScope.newMethodScope();
                scope.indentRight();
                String resultRef = scope.newMethodScopedName("result");
                scope.startLine("");
                componentParser.appendFinishedValueTypeNameJava(scope);
                scope.append(" " + resultRef + " = cachedValues.get(index);\n");
                scope.startLine("if (" + resultRef + " == null) {\n");
                scope.indentRight();
                boolean wrap = componentParser.javaCodeThrowsException();
                if (wrap) {
                    scope.startLine("try {\n");
                    scope.indentRight();
                }
                scope.startLine("Object unparsed = " + arrayRef + ".get(index);\n");
                componentParser.writeParseCode(scope, "unparsed", "null", "parsed");
                scope.startLine(String.valueOf(resultRef) + " = parsed;\n");
                if (wrap) {
                    scope.indentLeft();
                    scope.startLine("} catch (org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException e) {\n");
                    scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.implutil.CommonImpl.ParseRuntimeException(e);\n");
                    scope.startLine("}\n");
                }
                scope.startLine("cachedValues.compareAndSet(index, null, " + resultRef + ");\n");
                scope.startLine(String.valueOf(resultRef) + " = cachedValues.get(index);\n");
                scope.indentLeft();
                scope.startLine("}\n");
                scope.startLine("return " + resultRef + ";\n");
                scope.indentLeft();
                outerMethodScope.startLine("}\n");
            }
        };
        private final SlowParser<T> componentParser;
        private final boolean isNullable;
        private final ListFactory listFactory;

        ArrayParser(SlowParser<T> componentParser, boolean isNullable, ListFactory listFactory) {
            this.componentParser = componentParser;
            this.isNullable = isNullable;
            this.listFactory = listFactory;
        }

        @Override
        public List<? extends T> parseValue(Object value, ObjectData thisData) throws JsonProtocolParseException {
            if (this.isNullable && value == null) {
                return null;
            }
            if (!(value instanceof JSONArray)) {
                throw new JsonProtocolParseException("Array value expected");
            }
            JSONArray arrayValue = (JSONArray)value;
            return this.listFactory.create(arrayValue, this.componentParser);
        }

        @Override
        public FieldLoadedFinisher getValueFinisher() {
            return null;
        }

        @Override
        public JsonTypeParser<?> asJsonTypeParser() {
            return null;
        }

        @Override
        public void appendFinishedValueTypeNameJava(JavaCodeGenerator.FileScope scope) {
            scope.append("java.util.List<");
            this.componentParser.appendFinishedValueTypeNameJava(scope);
            scope.append(">");
        }

        @Override
        public void appendInternalValueTypeNameJava(JavaCodeGenerator.FileScope scope) {
            this.appendFinishedValueTypeNameJava(scope);
        }

        @Override
        void writeParseCode(JavaCodeGenerator.MethodScope scope, String valueRef, String superValueRef, String resultRef) {
            if (this.isNullable) {
                scope.startLine("if (" + valueRef + " == null) {\n");
                scope.startLine("  return null;\n");
                scope.startLine("}\n");
            }
            scope.startLine("if (" + valueRef + " instanceof org.json.simple.JSONArray == false) {\n");
            scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"Array value expected\");\n");
            scope.startLine("}\n");
            String arrayValueRef = scope.newMethodScopedName("arrayValue");
            scope.startLine("final org.json.simple.JSONArray " + arrayValueRef + " = (org.json.simple.JSONArray) " + valueRef + ";\n");
            this.listFactory.writeCreateListCode(this.componentParser, scope, arrayValueRef, resultRef);
        }

        @Override
        boolean javaCodeThrowsException() {
            return true;
        }

        static abstract class ListFactory {
            ListFactory() {
            }

            abstract <T> List<T> create(JSONArray var1, SlowParser<T> var2) throws JsonProtocolParseException;

            abstract void writeCreateListCode(SlowParser<?> var1, JavaCodeGenerator.MethodScope var2, String var3, String var4);
        }
    }

    static class AutoAlgebraicCasesDataImpl
    extends TypeHandler.AlgebraicCasesData {
        private int variantCodeFieldPos = -1;
        private int variantValueFieldPos = -1;
        private boolean hasDefaultCase = false;
        private final List<RefToType<?>> subtypes = new ArrayList();

        AutoAlgebraicCasesDataImpl() {
        }

        @Override
        List<RefToType<?>> getSubtypes() {
            return this.subtypes;
        }

        @Override
        void parseObjectSubtype(ObjectData objectData, Map<?, ?> jsonProperties, Object input) throws JsonProtocolParseException {
            if (jsonProperties == null) {
                throw new JsonProtocolParseException("JSON object input expected for non-manual subtyping");
            }
            int code = -1;
            int i = 0;
            while (i < this.getSubtypes().size()) {
                TypeHandler<?> nextSubtype = this.getSubtypes().get(i).get();
                boolean ok = nextSubtype.getSubtypeSupport().checkConditions(jsonProperties);
                if (ok) {
                    if (code == -1) {
                        code = i;
                    } else {
                        throw new JsonProtocolParseException("More than one case match");
                    }
                }
                ++i;
            }
            if (code == -1) {
                if (!this.hasDefaultCase) {
                    throw new JsonProtocolParseException("Not a singe case matches");
                }
            } else {
                ObjectData fieldData = this.getSubtypes().get(code).get().parse(input, objectData);
                objectData.getFieldArray()[this.variantValueFieldPos] = fieldData;
            }
            objectData.getFieldArray()[this.variantCodeFieldPos] = code;
        }

        @Override
        void writeConstructorCodeJava(JavaCodeGenerator.MethodScope methodScope) {
            TypeHandler<?> nextSubtype;
            methodScope.startLine("int code = -1;\n");
            int i = 0;
            while (i < this.getSubtypes().size()) {
                nextSubtype = this.getSubtypes().get(i).get();
                methodScope.startLine("if (" + methodScope.getTypeImplReference(nextSubtype) + ".checkSubtypeConditions(underlying)) {\n");
                methodScope.startLine("  if (code == -1) {\n");
                methodScope.startLine("    code = " + i + ";\n");
                methodScope.startLine("  } else {\n");
                methodScope.startLine("    throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"More than one case match\");\n");
                methodScope.startLine("  }\n");
                methodScope.startLine("}\n");
                ++i;
            }
            if (!this.hasDefaultCase) {
                methodScope.startLine("if (code == -1) {\n");
                methodScope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"Not a singe case matches\");\n");
                methodScope.startLine("}\n");
            }
            i = 0;
            while (i < this.getSubtypes().size()) {
                nextSubtype = this.getSubtypes().get(i).get();
                methodScope.startLine(String.valueOf(AutoAlgebraicCasesDataImpl.getAutoAlgFieldNameJava(i)) + " = (code == " + i + ") ? new " + methodScope.getTypeImplReference(nextSubtype) + "(underlying, this) : null;\n");
                ++i;
            }
        }

        @Override
        void writeFiledsJava(JavaCodeGenerator.ClassScope classScope) {
            int i = 0;
            while (i < this.getSubtypes().size()) {
                TypeHandler<?> nextSubtype = this.getSubtypes().get(i).get();
                classScope.startLine("private final " + classScope.getTypeImplReference(nextSubtype) + " " + AutoAlgebraicCasesDataImpl.getAutoAlgFieldNameJava(i) + ";\n");
                ++i;
            }
        }

        private static String getAutoAlgFieldNameJava(int code) {
            return "auto_alg_field_" + code;
        }
    }

    static class AutoSubtypeMethodHandler
    extends MethodHandler {
        private final int variantCodeField;
        private final int variantValueField;
        private final int code;

        AutoSubtypeMethodHandler(int variantCodeField, int variantValueField, int code) {
            this.variantCodeField = variantCodeField;
            this.variantValueField = variantValueField;
            this.code = code;
        }

        ObjectData getFieldObjectData(ObjectData objectData) {
            Object[] array = objectData.getFieldArray();
            Integer actualCode = (Integer)array[this.variantCodeField];
            if (this.code == actualCode) {
                ObjectData data = (ObjectData)array[this.variantValueField];
                return data;
            }
            return null;
        }

        @Override
        Object handle(ObjectData objectData, Object[] args) {
            ObjectData resData = this.getFieldObjectData(objectData);
            if (resData == null) {
                return null;
            }
            return resData.getProxy();
        }

        @Override
        void writeMethodImplementationJava(JavaCodeGenerator.ClassScope scope, Method m) {
            AutoSubtypeMethodHandler.writeMethodDeclarationJava(scope, m, Collections.emptyList());
            scope.append(" {\n");
            scope.startLine("  return " + AutoAlgebraicCasesDataImpl.getAutoAlgFieldNameJava(this.code) + ";\n");
            scope.startLine("}\n");
        }
    }

    private static class EagerFieldParserImpl
    extends TypeHandler.EagerFieldParser {
        private final List<LazyHandler> onDemandHandlers;

        private EagerFieldParserImpl(List<LazyHandler> onDemandHandlers) {
            this.onDemandHandlers = onDemandHandlers;
        }

        @Override
        void parseAllFields(ObjectData objectData) throws JsonProtocolParseException {
            for (LazyHandler handler : this.onDemandHandlers) {
                handler.parseEager(objectData);
            }
        }

        @Override
        void addAllFieldNames(Set<? super String> output) {
            for (LazyHandler handler : this.onDemandHandlers) {
                output.add(handler.getFieldName());
            }
        }
    }

    private static class FieldMap {
        final List<String> localNames = new ArrayList<String>(5);
        final List<String> overridenNames = new ArrayList<String>(1);

        private FieldMap() {
        }
    }

    private static class LazyCachedFieldMethodHandler
    extends LazyCachedMethodHandlerBase
    implements LazyHandler {
        private final SlowParser<?> slowParser;
        private final boolean isOptional;
        private final String fieldName;
        private final Class<?> typeClass;

        LazyCachedFieldMethodHandler(VolatileFieldBinding fieldBinding, SlowParser<?> slowParser, boolean isOptional, String fieldName, Class<?> typeClass) {
            super(fieldBinding);
            this.slowParser = slowParser;
            this.isOptional = isOptional;
            this.fieldName = fieldName;
            this.typeClass = typeClass;
        }

        @Override
        public void parseEager(ObjectData objectData) throws JsonProtocolParseException {
            this.parse(objectData);
        }

        @Override
        protected Object parse(ObjectData objectData) throws JsonProtocolParseException {
            JSONObject properties = (JSONObject)objectData.getUnderlyingObject();
            Object value = properties.get(this.fieldName);
            boolean hasValue = value == null ? properties.containsKey(this.fieldName) : true;
            Object parsedValue = this.parse(hasValue, value, objectData);
            FieldLoadedFinisher valueFinisher = this.slowParser.getValueFinisher();
            if (valueFinisher != null) {
                parsedValue = valueFinisher.getValueForUser(parsedValue);
            }
            return parsedValue;
        }

        @Override
        protected Object finishRawValue(Object raw) {
            return raw;
        }

        private Object parse(boolean hasValue, Object value, ObjectData objectData) throws JsonProtocolParseException {
            if (hasValue) {
                try {
                    return this.slowParser.parseValue(value, objectData);
                }
                catch (JsonProtocolParseException e) {
                    throw new JsonProtocolParseException("Failed to parse field " + this.fieldName + " in type " + this.typeClass.getName(), e);
                }
            }
            if (!this.isOptional) {
                throw new JsonProtocolParseException("Field is not optional: " + this.fieldName + " (in type " + this.typeClass.getName() + ")");
            }
            return null;
        }

        @Override
        protected void writeReturnTypeJava(JavaCodeGenerator.ClassScope scope, Method m) {
            this.getFieldBinding().getTypeInfo().appendValueTypeNameJava(scope);
        }

        @Override
        protected void writeParseJava(JavaCodeGenerator.MethodScope scope, String parseResultRef) {
            boolean wrap;
            scope.startLine("");
            this.getFieldBinding().getTypeInfo().appendValueTypeNameJava(scope);
            scope.append(" " + parseResultRef + ";\n");
            boolean bl = wrap = this.slowParser.javaCodeThrowsException() || !this.isOptional;
            if (wrap) {
                scope.startLine("try {\n");
                scope.indentRight();
            }
            String valueRef = scope.newMethodScopedName("value");
            String hasValueRef = scope.newMethodScopedName("hasValue");
            JavaCodeGenerator.Util.writeReadValueAndHasValue(scope, this.fieldName, "underlying", valueRef, hasValueRef);
            scope.startLine("if (" + hasValueRef + ") {\n");
            scope.indentRight();
            if (this.slowParser.javaCodeThrowsException()) {
                scope.startLine("try {\n");
                scope.indentRight();
                this.slowParser.writeParseCode(scope, valueRef, "null", "r1");
                scope.startLine(String.valueOf(parseResultRef) + " = r1;\n");
                scope.indentLeft();
                scope.startLine("} catch (org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException e) {\n");
                scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"Failed to parse field " + this.fieldName + " in type ");
                scope.append(String.valueOf(this.typeClass.getName()) + "\", e);\n");
                scope.startLine("}\n");
            } else {
                this.slowParser.writeParseCode(scope, valueRef, "null", "r1");
                scope.startLine(String.valueOf(parseResultRef) + " = r1;\n");
            }
            scope.indentLeft();
            scope.startLine("} else {\n");
            scope.indentRight();
            if (this.isOptional) {
                scope.startLine(String.valueOf(parseResultRef) + " = null;\n");
            } else {
                scope.startLine("throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"Field is not optional: " + this.fieldName + "\");\n");
            }
            scope.indentLeft();
            scope.startLine("}\n");
            if (wrap) {
                scope.indentLeft();
                scope.startLine("} catch (org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException e) {\n");
                scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.implutil.CommonImpl.ParseRuntimeException(\"On demand parsing failed for \" + underlying, e);\n");
                scope.startLine("}\n");
            }
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }
    }

    private static abstract class LazyCachedMethodHandlerBase
    extends MethodHandler {
        private final VolatileFieldBinding fieldBinding;

        LazyCachedMethodHandlerBase(VolatileFieldBinding fieldBinding) {
            this.fieldBinding = fieldBinding;
        }

        @Override
        Object handle(ObjectData objectData, Object[] args) {
            try {
                return this.handle(objectData);
            }
            catch (JsonProtocolParseException e) {
                throw new CommonImpl.ParseRuntimeException("On demand parsing failed for " + objectData.getUnderlyingObject(), e);
            }
        }

        Object handle(ObjectData objectData) throws JsonProtocolParseException {
            Object raw = this.handleRaw(objectData);
            return this.finishRawValue(raw);
        }

        protected abstract Object finishRawValue(Object var1);

        Object handleRaw(ObjectData objectData) throws JsonProtocolParseException {
            AtomicReferenceArray<Object> atomicReferenceArray = objectData.getAtomicReferenceArray();
            Object cachedValue = this.fieldBinding.get(atomicReferenceArray);
            if (cachedValue != null) {
                return cachedValue;
            }
            Object parsedValue = this.parse(objectData);
            if (parsedValue != null) {
                parsedValue = this.fieldBinding.setAndGet(atomicReferenceArray, parsedValue);
            }
            return parsedValue;
        }

        protected abstract Object parse(ObjectData var1) throws JsonProtocolParseException;

        protected VolatileFieldBinding getFieldBinding() {
            return this.fieldBinding;
        }

        protected abstract void writeReturnTypeJava(JavaCodeGenerator.ClassScope var1, Method var2);

        @Override
        void writeMethodImplementationJava(JavaCodeGenerator.ClassScope classScope, Method m) {
            classScope.startLine("@Override public ");
            this.writeReturnTypeJava(classScope, m);
            classScope.append(" ");
            LazyCachedMethodHandlerBase.appendMethodSignatureJava(classScope, m, Collections.emptyList());
            Type[] exceptions = m.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                classScope.append(" throws ");
                int i = 0;
                while (i < exceptions.length) {
                    if (i != 0) {
                        classScope.append(", ");
                    }
                    JavaCodeGenerator.Util.writeJavaTypeName(exceptions[i], classScope.getStringBuilder());
                    ++i;
                }
            }
            JavaCodeGenerator.MethodScope scope = classScope.newMethodScope();
            scope.append(" {\n");
            scope.indentRight();
            classScope.startLine("");
            this.writeReturnTypeJava(classScope, m);
            scope.append(" result = ");
            this.getFieldBinding().writeGetExpressionJava(scope.getStringBuilder());
            scope.append(";\n");
            scope.startLine("if (result != null) {\n");
            scope.startLine("  return result;\n");
            scope.startLine("}\n");
            String parseResultRef = scope.newMethodScopedName("parseResult");
            this.writeParseJava(scope, parseResultRef);
            scope.startLine("if (" + parseResultRef + " != null) {\n");
            scope.indentRight();
            this.getFieldBinding().writeSetAndGetJava(scope, parseResultRef, "cachedResult");
            scope.startLine(String.valueOf(parseResultRef) + " = cachedResult;\n");
            scope.indentLeft();
            scope.startLine("}\n");
            scope.startLine("return " + parseResultRef + ";\n");
            scope.indentLeft();
            scope.startLine("}\n");
        }

        protected abstract void writeParseJava(JavaCodeGenerator.MethodScope var1, String var2);
    }

    private static interface LazyHandler {
        public void parseEager(ObjectData var1) throws JsonProtocolParseException;

        public String getFieldName();
    }

    private static class LazyParseFieldMethodHandler
    extends MethodHandler
    implements LazyHandler {
        private final QuickParser<?> quickParser;
        private final boolean isOptional;
        private final String fieldName;
        private final Class<?> typeClass;

        LazyParseFieldMethodHandler(QuickParser<?> quickParser, boolean isOptional, String fieldName, Class<?> typeClass) {
            this.quickParser = quickParser;
            this.isOptional = isOptional;
            this.fieldName = fieldName;
            this.typeClass = typeClass;
        }

        @Override
        Object handle(ObjectData objectData, Object[] args) {
            try {
                return this.parse(objectData);
            }
            catch (JsonProtocolParseException e) {
                throw new CommonImpl.ParseRuntimeException("On demand parsing failed for " + objectData.getUnderlyingObject(), e);
            }
        }

        @Override
        public void parseEager(ObjectData objectData) throws JsonProtocolParseException {
            this.parse(objectData);
        }

        public Object parse(ObjectData objectData) throws JsonProtocolParseException {
            JSONObject properties = (JSONObject)objectData.getUnderlyingObject();
            Object value = properties.get(this.fieldName);
            boolean hasValue = value == null ? properties.containsKey(this.fieldName) : true;
            return this.parse(hasValue, value, objectData);
        }

        public Object parse(boolean hasValue, Object value, ObjectData objectData) throws JsonProtocolParseException {
            if (hasValue) {
                try {
                    return this.quickParser.parseValueQuick(value);
                }
                catch (JsonProtocolParseException e) {
                    throw new JsonProtocolParseException("Failed to parse field '" + this.fieldName + "' in type " + this.typeClass.getName(), e);
                }
            }
            if (!this.isOptional) {
                throw new JsonProtocolParseException("Field is not optional: " + this.fieldName + " (in type " + this.typeClass.getName() + ")");
            }
            return null;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        void writeMethodImplementationJava(JavaCodeGenerator.ClassScope classScope, Method m) {
            boolean wrap;
            LazyParseFieldMethodHandler.writeMethodDeclarationJava(classScope, m, Collections.emptyList());
            classScope.startLine("{\n");
            JavaCodeGenerator.MethodScope scope = classScope.newMethodScope();
            scope.indentRight();
            scope.startLine("");
            this.quickParser.appendFinishedValueTypeNameJava(scope);
            scope.append(" result;\n");
            boolean bl = wrap = this.quickParser.javaCodeThrowsException() || !this.isOptional;
            if (wrap) {
                scope.startLine("try {\n");
                scope.indentRight();
            }
            String valueRef = scope.newMethodScopedName("value");
            String hasValueRef = scope.newMethodScopedName("hasValue");
            JavaCodeGenerator.Util.writeReadValueAndHasValue(scope, this.fieldName, "underlying", valueRef, hasValueRef);
            scope.startLine("if (" + hasValueRef + ") {\n");
            scope.indentRight();
            if (this.quickParser.javaCodeThrowsException()) {
                scope.startLine("try {\n");
                scope.indentRight();
                this.quickParser.writeParseQuickCode(scope, valueRef, "r1");
                scope.startLine("result = r1;\n");
                scope.indentLeft();
                scope.startLine("} catch (org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException e) {\n");
                scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"Failed to parse field " + this.fieldName + " in type ");
                scope.append(String.valueOf(this.typeClass.getName()) + "\", e);\n");
                scope.startLine("}\n");
            } else {
                this.quickParser.writeParseQuickCode(scope, valueRef, "r1");
                scope.startLine("result = r1;\n");
            }
            scope.indentLeft();
            scope.startLine("} else {\n");
            scope.indentRight();
            if (this.isOptional) {
                scope.startLine("result = null;\n");
            } else {
                scope.startLine("throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException(\"Field is not optional: " + this.fieldName + "\");\n");
            }
            scope.indentLeft();
            scope.startLine("}\n");
            if (wrap) {
                scope.indentLeft();
                scope.startLine("} catch (org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException e) {\n");
                scope.startLine("  throw new org.eclipse.wst.jsdt.chromium.internal.protocolparser.implutil.CommonImpl.ParseRuntimeException(\"On demand parsing failed for \" + underlying, e);\n");
                scope.startLine("}\n");
            }
            scope.startLine("return result;\n");
            scope.indentLeft();
            scope.startLine("}\n");
        }
    }

    static class ManualAlgebraicCasesDataImpl
    extends TypeHandler.AlgebraicCasesData {
        private final List<RefToType<?>> subtypes = new ArrayList();

        ManualAlgebraicCasesDataImpl() {
        }

        @Override
        List<RefToType<?>> getSubtypes() {
            return this.subtypes;
        }

        @Override
        void parseObjectSubtype(ObjectData objectData, Map<?, ?> jsonProperties, Object input) {
        }

        @Override
        void writeConstructorCodeJava(JavaCodeGenerator.MethodScope methodScope) {
        }

        @Override
        void writeFiledsJava(JavaCodeGenerator.ClassScope classScope) {
        }
    }

    static class ManualSubtypeMethodHandler
    extends LazyCachedMethodHandlerBase {
        private final SlowParser<?> parser;

        ManualSubtypeMethodHandler(VolatileFieldBinding fieldInf, SlowParser<?> parser) {
            super(fieldInf);
            this.parser = parser;
        }

        @Override
        protected Object parse(ObjectData objectData) throws JsonProtocolParseException {
            return this.parser.parseValue(objectData.getUnderlyingObject(), objectData);
        }

        @Override
        protected Object finishRawValue(Object raw) {
            FieldLoadedFinisher valueFinisher = this.parser.getValueFinisher();
            Object res = raw;
            if (valueFinisher != null) {
                res = valueFinisher.getValueForUser(res);
            }
            return res;
        }

        ObjectData getSubtypeData(ObjectData objectData) throws JsonProtocolParseException {
            return (ObjectData)this.handleRaw(objectData);
        }

        @Override
        protected void writeReturnTypeJava(JavaCodeGenerator.ClassScope scope, Method m) {
            JsonTypeParser<?> jsonTypeParser = this.parser.asJsonTypeParser();
            if (jsonTypeParser == null) {
                JavaCodeGenerator.Util.writeJavaTypeName(m.getGenericReturnType(), scope.getStringBuilder());
            } else {
                String valueTypeName = scope.getTypeImplReference(jsonTypeParser.getType().get());
                scope.append(valueTypeName);
            }
        }

        @Override
        protected void writeParseJava(JavaCodeGenerator.MethodScope scope, String parseResultRef) {
            this.parser.writeParseCode(scope, "underlying", "this", parseResultRef);
        }
    }

    private static class PreparsedFieldMethodHandler
    extends MethodHandler {
        private final int pos;
        private final FieldLoadedFinisher valueFinisher;
        private final String fieldName;

        PreparsedFieldMethodHandler(int pos, FieldLoadedFinisher valueFinisher, String fieldName) {
            this.pos = pos;
            this.valueFinisher = valueFinisher;
            this.fieldName = fieldName;
        }

        @Override
        Object handle(ObjectData objectData, Object[] args) throws Throwable {
            Object val = objectData.getFieldArray()[this.pos];
            if (this.valueFinisher != null) {
                val = this.valueFinisher.getValueForUser(val);
            }
            return val;
        }

        @Override
        void writeMethodImplementationJava(JavaCodeGenerator.ClassScope scope, Method m) {
            PreparsedFieldMethodHandler.writeMethodDeclarationJava(scope, m, Collections.emptyList());
            scope.append(" {\n");
            scope.startLine("  return field_" + this.fieldName + ";\n");
            scope.startLine("}\n");
        }
    }

    private static class ReadInterfacesSession {
        private final Map<Class<?>, TypeHandler<?>> type2typeHandler;
        private final List<? extends DynamicParserImpl<?>> basePackages;
        private final boolean strictMode;
        final List<RefImpl<?>> refs = new ArrayList();
        final List<SubtypeCaster> subtypeCasters = new ArrayList<SubtypeCaster>();

        ReadInterfacesSession(List<? extends Class<?>> protocolInterfaces, List<? extends DynamicParserImpl<?>> basePackages, boolean strictMode) {
            this.type2typeHandler = new LinkedHashMap();
            this.basePackages = basePackages;
            this.strictMode = strictMode;
            for (Class<?> typeClass : protocolInterfaces) {
                if (this.type2typeHandler.containsKey(typeClass)) {
                    throw new IllegalArgumentException("Protocol interface duplicated " + typeClass.getName());
                }
                this.type2typeHandler.put(typeClass, null);
            }
        }

        void go() throws JsonProtocolModelParseException {
            for (Class<?> clazz : this.type2typeHandler.keySet()) {
                TypeHandler<?> typeHandler = this.createTypeHandler(clazz);
                this.type2typeHandler.put(clazz, typeHandler);
            }
            for (RefImpl refImpl : this.refs) {
                TypeHandler<?> type = this.type2typeHandler.get(refImpl.typeClass);
                if (type == null) {
                    throw new RuntimeException();
                }
                refImpl.set(type);
            }
            for (SubtypeCaster subtypeCaster : this.subtypeCasters) {
                TypeHandler<?> subtypeHandler = subtypeCaster.getSubtypeHandler();
                subtypeHandler.getSubtypeSupport().setSubtypeCaster(subtypeCaster);
            }
            for (TypeHandler typeHandler : this.type2typeHandler.values()) {
                typeHandler.getSubtypeSupport().checkHasSubtypeCaster();
            }
            if (this.strictMode) {
                for (TypeHandler typeHandler : this.type2typeHandler.values()) {
                    typeHandler.buildClosedNameSet();
                }
            }
        }

        Map<Class<?>, TypeHandler<?>> getResult() {
            return this.type2typeHandler;
        }

        private <T> TypeHandler<T> createTypeHandler(Class<T> typeClass) throws JsonProtocolModelParseException {
            if (!typeClass.isInterface()) {
                throw new JsonProtocolModelParseException("Json model type should be interface: " + typeClass.getName());
            }
            FieldProcessor<T> fields = new FieldProcessor<T>(typeClass);
            fields.go();
            Map<Method, MethodHandler> methodHandlerMap = fields.getMethodHandlerMap();
            methodHandlerMap.putAll(BaseHandlersLibrary.INSTANCE.getAllHandlers());
            EagerFieldParserImpl eagerFieldParser = new EagerFieldParserImpl(fields.getOnDemandHanlers());
            RefToType<?> superclassRef = this.getSuperclassRef(typeClass);
            boolean requiresJsonObject = fields.requiresJsonObject() || JsonObjectBased.class.isAssignableFrom(typeClass);
            return new TypeHandler<T>(typeClass, superclassRef, fields.getFieldArraySize(), fields.getVolatileFields(), methodHandlerMap, fields.getFieldLoaders(), fields.getFieldConditions(), eagerFieldParser, fields.getAlgCasesData(), requiresJsonObject, this.strictMode);
        }

        private SlowParser<?> getFieldTypeParser(Type type, boolean declaredNullable, boolean isSubtyping, FieldLoadStrategy loadStrategy) throws JsonProtocolModelParseException {
            if (type instanceof Class) {
                Class typeClass = (Class)type;
                if (type == Long.class) {
                    this.nullableIsNotSupported(declaredNullable);
                    return LONG_PARSER.getNullable();
                }
                if (type == Long.TYPE) {
                    this.nullableIsNotSupported(declaredNullable);
                    return LONG_PARSER.getNotNullable();
                }
                if (type == Boolean.class) {
                    this.nullableIsNotSupported(declaredNullable);
                    return BOOLEAN_PARSER.getNullable();
                }
                if (type == Boolean.TYPE) {
                    this.nullableIsNotSupported(declaredNullable);
                    return BOOLEAN_PARSER.getNotNullable();
                }
                if (type == Float.class) {
                    this.nullableIsNotSupported(declaredNullable);
                    return FLOAT_PARSER.getNullable();
                }
                if (type == Float.TYPE) {
                    this.nullableIsNotSupported(declaredNullable);
                    return FLOAT_PARSER.getNotNullable();
                }
                if (type == Number.class) {
                    return NUMBER_PARSER.get(declaredNullable);
                }
                if (type == Void.class) {
                    this.nullableIsNotSupported(declaredNullable);
                    return VOID_PARSER;
                }
                if (type == String.class) {
                    return STRING_PARSER.get(declaredNullable);
                }
                if (type == Object.class) {
                    return OBJECT_PARSER.get(declaredNullable);
                }
                if (type == JSONObject.class) {
                    return JSON_PARSER.get(declaredNullable);
                }
                if (typeClass.isEnum()) {
                    Class enumTypeClass = typeClass;
                    return EnumParser.create(enumTypeClass, declaredNullable);
                }
                this.type2typeHandler.containsKey(typeClass);
                RefToType ref = this.getTypeRef(typeClass);
                if (ref != null) {
                    return this.createJsonParser(ref, declaredNullable, isSubtyping);
                }
                throw new JsonProtocolModelParseException("Method return type " + type + " (simple class) not supported");
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                if (parameterizedType.getRawType() == List.class) {
                    WildcardType wildcard;
                    Type argumentType = parameterizedType.getActualTypeArguments()[0];
                    if (argumentType instanceof WildcardType && (wildcard = (WildcardType)argumentType).getLowerBounds().length == 0 && wildcard.getUpperBounds().length == 1) {
                        argumentType = wildcard.getUpperBounds()[0];
                    }
                    SlowParser<?> componentParser = this.getFieldTypeParser(argumentType, false, false, loadStrategy);
                    return this.createArrayParser(componentParser, declaredNullable, loadStrategy);
                }
                throw new JsonProtocolModelParseException("Method return type " + type + " (generic) not supported");
            }
            throw new JsonProtocolModelParseException("Method return type " + type + " not supported");
        }

        private void nullableIsNotSupported(boolean declaredNullable) throws JsonProtocolModelParseException {
            if (declaredNullable) {
                throw new JsonProtocolModelParseException("The type cannot be declared nullable");
            }
        }

        private <T> JsonTypeParser<T> createJsonParser(RefToType<T> type, boolean isNullable, boolean isSubtyping) {
            return new JsonTypeParser<T>(type, isNullable, isSubtyping);
        }

        private <T> ArrayParser<T> createArrayParser(SlowParser<T> componentParser, boolean isNullable, FieldLoadStrategy loadStrategy) {
            if (loadStrategy == FieldLoadStrategy.LAZY) {
                return new ArrayParser<T>(componentParser, isNullable, ArrayParser.LAZY);
            }
            return new ArrayParser<T>(componentParser, isNullable, ArrayParser.EAGER);
        }

        private <T> RefToType<T> getTypeRef(final Class<T> typeClass) {
            if (this.type2typeHandler.containsKey(typeClass)) {
                RefImpl<T> result = new RefImpl<T>(typeClass);
                this.refs.add(result);
                return result;
            }
            for (DynamicParserImpl<?> baseParser : this.basePackages) {
                TypeHandler typeHandler = (TypeHandler)((DynamicParserImpl)baseParser).type2TypeHandler.get(typeClass);
                if (typeHandler == null) continue;
                final TypeHandler typeHandlerT = typeHandler;
                return new RefToType<T>(){

                    @Override
                    TypeHandler<T> get() {
                        return typeHandlerT;
                    }

                    @Override
                    Class<?> getTypeClass() {
                        return typeClass;
                    }
                };
            }
            return null;
        }

        private RefToType<?> getSuperclassRef(Class<?> typeClass) throws JsonProtocolModelParseException {
            RefToType result = null;
            Type[] typeArray = typeClass.getGenericInterfaces();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterizedType parameterizedType;
                Type interfc = typeArray[n2];
                if (interfc instanceof ParameterizedType && (parameterizedType = (ParameterizedType)interfc).getRawType() == JsonSubtype.class) {
                    Type param = parameterizedType.getActualTypeArguments()[0];
                    if (!(param instanceof Class)) {
                        throw new JsonProtocolModelParseException("Unexpected type of superclass " + param);
                    }
                    Class paramClass = (Class)param;
                    if (result != null) {
                        throw new JsonProtocolModelParseException("Already has superclass " + result.getTypeClass().getName());
                    }
                    result = this.getTypeRef(paramClass);
                    if (result == null) {
                        throw new JsonProtocolModelParseException("Unknown base class " + paramClass.getName());
                    }
                }
                ++n2;
            }
            return result;
        }

        class FieldProcessor<T> {
            private final Class<T> typeClass;
            private final JsonType jsonTypeAnn;
            private final List<FieldLoader> fieldLoaders = new ArrayList<FieldLoader>(2);
            private final List<LazyHandler> onDemandHanlers = new ArrayList<LazyHandler>();
            private final Map<Method, MethodHandler> methodHandlerMap = new HashMap<Method, MethodHandler>();
            private final FieldMap fieldMap = new FieldMap();
            private final List<FieldCondition> fieldConditions = new ArrayList<FieldCondition>(2);
            private ManualAlgebraicCasesDataImpl manualAlgCasesData = null;
            private AutoAlgebraicCasesDataImpl autoAlgCasesData = null;
            private int fieldArraySize = 0;
            private List<VolatileFieldBinding> volatileFields = new ArrayList<VolatileFieldBinding>(2);
            private boolean requiresJsonObject = false;

            FieldProcessor(Class<T> typeClass) throws JsonProtocolModelParseException {
                this.typeClass = typeClass;
                this.jsonTypeAnn = typeClass.getAnnotation(JsonType.class);
                if (this.jsonTypeAnn == null) {
                    throw new JsonProtocolModelParseException("Not a json model type: " + typeClass);
                }
            }

            void go() throws JsonProtocolModelParseException {
                Method[] methodArray = this.typeClass.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method m = methodArray[n2];
                    try {
                        this.processMethod(m);
                    }
                    catch (JsonProtocolModelParseException e) {
                        throw new JsonProtocolModelParseException("Problem with method " + m, e);
                    }
                    ++n2;
                }
            }

            private void processMethod(Method m) throws JsonProtocolModelParseException {
                MethodHandler methodHandler;
                if (m.getParameterTypes().length != 0) {
                    throw new JsonProtocolModelParseException("No parameters expected in " + m);
                }
                JsonOverrideField overrideFieldAnn = m.getAnnotation(JsonOverrideField.class);
                FieldConditionLogic fieldConditionLogic = FieldConditionLogic.readLogic(m);
                String fieldName = this.checkAndGetJsonFieldName(m);
                JsonSubtypeCasting jsonSubtypeCaseAnn = m.getAnnotation(JsonSubtypeCasting.class);
                if (jsonSubtypeCaseAnn != null) {
                    if (fieldConditionLogic != null) {
                        throw new JsonProtocolModelParseException("Subtype condition annotation only works with field getter methods");
                    }
                    if (overrideFieldAnn != null) {
                        throw new JsonProtocolModelParseException("Override annotation only works with field getter methods");
                    }
                    if (this.jsonTypeAnn.subtypesChosenManually()) {
                        if (this.manualAlgCasesData == null) {
                            this.manualAlgCasesData = new ManualAlgebraicCasesDataImpl();
                        }
                        methodHandler = this.processManualSubtypeMethod(m, jsonSubtypeCaseAnn);
                    } else {
                        if (this.autoAlgCasesData == null) {
                            this.autoAlgCasesData = new AutoAlgebraicCasesDataImpl();
                        }
                        if (jsonSubtypeCaseAnn.reinterpret()) {
                            throw new JsonProtocolModelParseException("Option 'reinterpret' is only available with 'subtypes chosen manually'");
                        }
                        this.requiresJsonObject = true;
                        methodHandler = this.processAutomaticSubtypeMethod(m);
                    }
                } else {
                    this.requiresJsonObject = true;
                    methodHandler = this.processFieldGetterMethod(m, fieldConditionLogic, overrideFieldAnn, fieldName);
                }
                this.methodHandlerMap.put(m, methodHandler);
            }

            private MethodHandler processFieldGetterMethod(Method m, FieldConditionLogic fieldConditionLogic, JsonOverrideField overrideFieldAnn, String fieldName) throws JsonProtocolModelParseException {
                MethodHandler methodHandler;
                FieldLoadStrategy loadStrategy = m.getAnnotation(JsonField.class) == null ? FieldLoadStrategy.AUTO : m.getAnnotation(JsonField.class).loadStrategy();
                JsonNullable nullableAnn = m.getAnnotation(JsonNullable.class);
                SlowParser fieldTypeParser = ReadInterfacesSession.this.getFieldTypeParser(m.getGenericReturnType(), nullableAnn != null, false, loadStrategy);
                if (fieldConditionLogic != null) {
                    this.fieldConditions.add(new FieldCondition(fieldName, fieldTypeParser.asQuickParser(), fieldConditionLogic));
                }
                if (overrideFieldAnn == null) {
                    this.fieldMap.localNames.add(fieldName);
                } else {
                    this.fieldMap.overridenNames.add(fieldName);
                }
                boolean isOptional = this.isOptionalField(m);
                if (fieldTypeParser.asQuickParser() != null) {
                    QuickParser quickParser = fieldTypeParser.asQuickParser();
                    methodHandler = loadStrategy == FieldLoadStrategy.EAGER ? this.createEagerLoadGetterHandler(fieldName, fieldTypeParser, isOptional) : this.createLazyQuickGetterHandler(quickParser, isOptional, fieldName);
                } else {
                    methodHandler = loadStrategy == FieldLoadStrategy.LAZY ? this.createLazyCachedGetterHandler(fieldName, fieldTypeParser, isOptional) : this.createEagerLoadGetterHandler(fieldName, fieldTypeParser, isOptional);
                }
                return methodHandler;
            }

            private MethodHandler createLazyQuickGetterHandler(QuickParser<?> quickParser, boolean isOptional, String fieldName) {
                LazyParseFieldMethodHandler onDemandHandler = new LazyParseFieldMethodHandler(quickParser, isOptional, fieldName, this.typeClass);
                this.onDemandHanlers.add(onDemandHandler);
                return onDemandHandler;
            }

            private MethodHandler createEagerLoadGetterHandler(String fieldName, SlowParser<?> fieldTypeParser, boolean isOptional) {
                int fieldCode = this.allocateFieldInArray();
                FieldLoader fieldLoader = new FieldLoader(fieldCode, fieldName, fieldTypeParser, isOptional);
                this.fieldLoaders.add(fieldLoader);
                return new PreparsedFieldMethodHandler(fieldCode, fieldTypeParser.getValueFinisher(), fieldName);
            }

            private MethodHandler createLazyCachedGetterHandler(String fieldName, SlowParser<?> fieldTypeParser, boolean isOptional) {
                VolatileFieldBinding fieldBinding = this.allocateVolatileField(fieldTypeParser, false);
                LazyCachedFieldMethodHandler lazyCachedHandler = new LazyCachedFieldMethodHandler(fieldBinding, fieldTypeParser, isOptional, fieldName, this.typeClass);
                this.onDemandHanlers.add(lazyCachedHandler);
                return lazyCachedHandler;
            }

            private MethodHandler processAutomaticSubtypeMethod(Method m) throws JsonProtocolModelParseException {
                MethodHandler methodHandler;
                if (m.getReturnType() == Void.TYPE) {
                    if (this.autoAlgCasesData.hasDefaultCase) {
                        throw new JsonProtocolModelParseException("Duplicate default case method: " + m);
                    }
                    this.autoAlgCasesData.hasDefaultCase = true;
                    methodHandler = RETURN_NULL_METHOD_HANDLER;
                } else {
                    Class<?> methodType = m.getReturnType();
                    RefToType ref = ReadInterfacesSession.this.getTypeRef(methodType);
                    if (ref == null) {
                        throw new JsonProtocolModelParseException("Unknown return type in " + m);
                    }
                    if (this.autoAlgCasesData.variantCodeFieldPos == -1) {
                        this.autoAlgCasesData.variantCodeFieldPos = this.allocateFieldInArray();
                        this.autoAlgCasesData.variantValueFieldPos = this.allocateFieldInArray();
                    }
                    final int algCode = this.autoAlgCasesData.subtypes.size();
                    this.autoAlgCasesData.subtypes.add(ref);
                    final AutoSubtypeMethodHandler algMethodHandler = new AutoSubtypeMethodHandler(this.autoAlgCasesData.variantCodeFieldPos, this.autoAlgCasesData.variantValueFieldPos, algCode);
                    methodHandler = algMethodHandler;
                    SubtypeCaster subtypeCaster = new SubtypeCaster(this.typeClass, ref){

                        @Override
                        ObjectData getSubtypeObjectData(ObjectData objectData) {
                            return algMethodHandler.getFieldObjectData(objectData);
                        }

                        @Override
                        void writeJava(JavaCodeGenerator.ClassScope scope, String expectedTypeName, String superTypeValueRef, String resultRef) {
                            scope.startLine(String.valueOf(expectedTypeName) + " " + resultRef + " = " + superTypeValueRef + "." + AutoAlgebraicCasesDataImpl.getAutoAlgFieldNameJava(algCode) + ";\n");
                        }
                    };
                    ReadInterfacesSession.this.subtypeCasters.add(subtypeCaster);
                }
                return methodHandler;
            }

            private MethodHandler processManualSubtypeMethod(final Method m, JsonSubtypeCasting jsonSubtypeCaseAnn) throws JsonProtocolModelParseException {
                SlowParser fieldTypeParser = ReadInterfacesSession.this.getFieldTypeParser(m.getGenericReturnType(), false, !jsonSubtypeCaseAnn.reinterpret(), FieldLoadStrategy.AUTO);
                VolatileFieldBinding fieldInfo = this.allocateVolatileField(fieldTypeParser, true);
                if (!Arrays.asList(m.getExceptionTypes()).contains(JsonProtocolParseException.class)) {
                    throw new JsonProtocolModelParseException("Method should declare JsonProtocolParseException exception: " + m);
                }
                final ManualSubtypeMethodHandler handler = new ManualSubtypeMethodHandler(fieldInfo, fieldTypeParser);
                JsonTypeParser<?> parserAsJsonTypeParser = fieldTypeParser.asJsonTypeParser();
                if (parserAsJsonTypeParser != null && parserAsJsonTypeParser.isSubtyping()) {
                    SubtypeCaster subtypeCaster = new SubtypeCaster(this.typeClass, parserAsJsonTypeParser.getType()){

                        @Override
                        ObjectData getSubtypeObjectData(ObjectData baseObjectData) throws JsonProtocolParseException {
                            ObjectData objectData = baseObjectData;
                            return handler.getSubtypeData(objectData);
                        }

                        @Override
                        void writeJava(JavaCodeGenerator.ClassScope scope, String expectedTypeName, String superTypeValueRef, String resultRef) {
                            scope.startLine(String.valueOf(expectedTypeName) + " " + resultRef + " = " + superTypeValueRef + "." + m.getName() + "();\n");
                        }
                    };
                    this.manualAlgCasesData.subtypes.add(parserAsJsonTypeParser.getType());
                    ReadInterfacesSession.this.subtypeCasters.add(subtypeCaster);
                }
                return handler;
            }

            int getFieldArraySize() {
                return this.fieldArraySize;
            }

            List<VolatileFieldBinding> getVolatileFields() {
                return this.volatileFields;
            }

            TypeHandler.AlgebraicCasesData getAlgCasesData() {
                if (this.jsonTypeAnn.subtypesChosenManually()) {
                    return this.manualAlgCasesData;
                }
                return this.autoAlgCasesData;
            }

            List<FieldLoader> getFieldLoaders() {
                return this.fieldLoaders;
            }

            List<LazyHandler> getOnDemandHanlers() {
                return this.onDemandHanlers;
            }

            Map<Method, MethodHandler> getMethodHandlerMap() {
                return this.methodHandlerMap;
            }

            List<FieldCondition> getFieldConditions() {
                return this.fieldConditions;
            }

            boolean requiresJsonObject() {
                return this.requiresJsonObject;
            }

            private int allocateFieldInArray() {
                return this.fieldArraySize++;
            }

            private VolatileFieldBinding allocateVolatileField(final SlowParser<?> fieldTypeParser, boolean internalType) {
                int position = this.volatileFields.size();
                FieldTypeInfo fieldTypeInfo = internalType ? new FieldTypeInfo(){

                    @Override
                    public void appendValueTypeNameJava(JavaCodeGenerator.FileScope scope) {
                        fieldTypeParser.appendInternalValueTypeNameJava(scope);
                    }
                } : new FieldTypeInfo(){

                    @Override
                    public void appendValueTypeNameJava(JavaCodeGenerator.FileScope scope) {
                        fieldTypeParser.appendFinishedValueTypeNameJava(scope);
                    }
                };
                VolatileFieldBinding binding = new VolatileFieldBinding(position, fieldTypeInfo);
                this.volatileFields.add(binding);
                return binding;
            }

            private boolean isOptionalField(Method m) {
                JsonOptionalField jsonOptionalFieldAnn = m.getAnnotation(JsonOptionalField.class);
                return jsonOptionalFieldAnn != null;
            }

            private String checkAndGetJsonFieldName(Method m) throws JsonProtocolModelParseException {
                String jsonLiteralName;
                if (m.getParameterTypes().length != 0) {
                    throw new JsonProtocolModelParseException("Must have 0 parameters");
                }
                JsonField fieldAnn = m.getAnnotation(JsonField.class);
                if (fieldAnn != null && !(jsonLiteralName = fieldAnn.jsonLiteralName()).isEmpty()) {
                    return jsonLiteralName;
                }
                return m.getName();
            }
        }
    }

    private static class RefImpl<T>
    extends RefToType<T> {
        private final Class<T> typeClass;
        private TypeHandler<T> type = null;

        RefImpl(Class<T> typeClass) {
            this.typeClass = typeClass;
        }

        @Override
        Class<?> getTypeClass() {
            return this.typeClass;
        }

        @Override
        TypeHandler<T> get() {
            return this.type;
        }

        void set(TypeHandler<?> type) {
            this.type = type;
        }
    }

    static class SimpleCastParser<T>
    extends QuickParser<T> {
        private final boolean nullable;
        private final Class<T> fieldType;

        SimpleCastParser(Class<T> fieldType, boolean nullable) {
            this.fieldType = fieldType;
            this.nullable = nullable;
        }

        @Override
        public T parseValueQuick(Object value) throws JsonProtocolParseException {
            if (value == null) {
                if (this.nullable) {
                    return null;
                }
                throw new JsonProtocolParseException("Field must have type " + this.fieldType.getName());
            }
            try {
                return this.fieldType.cast(value);
            }
            catch (ClassCastException e) {
                throw new JsonProtocolParseException("Field must have type " + this.fieldType.getName(), e);
            }
        }

        @Override
        public FieldLoadedFinisher getValueFinisher() {
            return null;
        }

        @Override
        public void appendFinishedValueTypeNameJava(JavaCodeGenerator.FileScope scope) {
            scope.append(this.fieldType.getCanonicalName());
        }

        @Override
        public void writeParseQuickCode(JavaCodeGenerator.MethodScope scope, String valueRef, String resultRef) {
            scope.startLine(String.valueOf(this.fieldType.getCanonicalName()) + " " + resultRef + " = (" + this.fieldType.getCanonicalName() + ") " + valueRef + ";\n");
        }

        @Override
        boolean javaCodeThrowsException() {
            return false;
        }
    }

    static class SimpleParserPair<T> {
        private final SimpleCastParser<T> nullable;
        private final SimpleCastParser<T> notNullable;

        static <T> SimpleParserPair<T> create(Class<T> fieldType) {
            return new SimpleParserPair<T>(fieldType);
        }

        private SimpleParserPair(Class<T> fieldType) {
            this.nullable = new SimpleCastParser<T>(fieldType, true);
            this.notNullable = new SimpleCastParser<T>(fieldType, false);
        }

        SimpleCastParser<T> getNullable() {
            return this.nullable;
        }

        SimpleCastParser<T> getNotNullable() {
            return this.notNullable;
        }

        SlowParser<?> get(boolean declaredNullable) {
            return declaredNullable ? this.nullable : this.notNullable;
        }
    }

    static class VolatileFieldBinding {
        private final int position;
        private final FieldTypeInfo fieldTypeInfo;
        private static final String FIELD_NAME_PREFIX = "lazyCachedField_";

        public VolatileFieldBinding(int position, FieldTypeInfo fieldTypeInfo) {
            this.position = position;
            this.fieldTypeInfo = fieldTypeInfo;
        }

        public Object setAndGet(AtomicReferenceArray<Object> atomicReferenceArray, Object value) {
            atomicReferenceArray.compareAndSet(this.position, null, value);
            return atomicReferenceArray.get(this.position);
        }

        public Object get(AtomicReferenceArray<Object> atomicReferenceArray) {
            return atomicReferenceArray.get(this.position);
        }

        void writeGetExpressionJava(StringBuilder output) {
            output.append(String.valueOf(this.getCodeFieldName()) + ".get()");
        }

        void writeSetAndGetJava(JavaCodeGenerator.MethodScope scope, String valueRef, String resultRef) {
            scope.startLine(String.valueOf(this.getCodeFieldName()) + ".compareAndSet(null, " + valueRef + ");\n");
            scope.startLine("");
            this.fieldTypeInfo.appendValueTypeNameJava(scope);
            scope.append(" " + resultRef + " = ");
            this.writeGetExpressionJava(scope.getStringBuilder());
            scope.append(";\n");
        }

        void writeFieldDeclarationJava(JavaCodeGenerator.ClassScope scope) {
            scope.startLine("private final java.util.concurrent.atomic.AtomicReference<");
            this.fieldTypeInfo.appendValueTypeNameJava(scope);
            scope.append("  > " + this.getCodeFieldName() + " = new java.util.concurrent.atomic.AtomicReference<");
            this.fieldTypeInfo.appendValueTypeNameJava(scope);
            scope.append(">(null);\n");
        }

        FieldTypeInfo getTypeInfo() {
            return this.fieldTypeInfo;
        }

        private String getCodeFieldName() {
            return FIELD_NAME_PREFIX + this.position;
        }
    }
}

