/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourcePackageInfoCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaResourceModelProvider;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;

public class JavaPackageInfoResourceModelProvider
implements JpaResourceModelProvider {
    private static final JpaResourceModelProvider INSTANCE = new JavaPackageInfoResourceModelProvider();

    public static JpaResourceModelProvider instance() {
        return INSTANCE;
    }

    private JavaPackageInfoResourceModelProvider() {
    }

    public IContentType getContentType() {
        return JavaResourceCompilationUnit.PACKAGE_INFO_CONTENT_TYPE;
    }

    public JavaResourceCompilationUnit buildResourceModel(JpaProject jpaProject, IFile file) {
        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
        try {
            if (compilationUnit.getPackageDeclarations().length == 0) {
                return null;
            }
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.instance().logError(ex);
            return null;
        }
        return new SourcePackageInfoCompilationUnit(compilationUnit, jpaProject.getJpaPlatform().getAnnotationProvider(), jpaProject.getJpaPlatform().getAnnotationEditFormatter(), (CommandContext)jpaProject.getManager().getModifySharedDocumentCommandContext());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

