/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.validation;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.json.IValidationReporter;
import org.eclipse.json.ValidatorHelper;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.json.core.internal.validation.JSONSyntaxValidator;
import org.eclipse.wst.json.core.internal.validation.JSONValidationConfiguration;
import org.eclipse.wst.json.core.internal.validation.JSONValidationInfo;
import org.eclipse.wst.json.core.internal.validation.JSONValidationReport;
import org.eclipse.wst.json.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.json.core.validation.AnnotationMsg;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class JSONValidator {
    protected URIResolver uriResolver = null;
    private JSONSyntaxValidator val = new JSONSyntaxValidator();

    public JSONValidationReport validate(String uri, InputStream inputStream) {
        return this.validate(uri, inputStream, new JSONValidationConfiguration());
    }

    public JSONValidationReport validate(String uri, InputStream inputStream, JSONValidationConfiguration configuration) {
        return this.validate(uri, inputStream, configuration, null);
    }

    public JSONValidationReport validate(String uri, InputStream inputStream, JSONValidationConfiguration configuration, ValidationResult result) {
        return this.validate(uri, inputStream, configuration, null, null);
    }

    public JSONValidationReport validate(String uri, InputStream inputStream, JSONValidationConfiguration configuration, ValidationResult result, NestedValidatorContext context) {
        JSONValidationInfo valinfo = new JSONValidationInfo(uri);
        if (inputStream != null) {
            ValidatorHelper.validate((Reader)new InputStreamReader(inputStream), (IValidationReporter)valinfo);
        }
        return valinfo;
    }

    private Object[] getMsgArguments(LocalizedMessage msg) {
        Object obj = msg.getAttribute(AnnotationMsg.ID);
        return new Object[]{obj};
    }

    private IReporter executeMarkupValidator(String uri) {
        Path path = new Path(uri);
        String fileProtocol = "file://";
        int index = uri.indexOf(fileProtocol);
        IFile resource = null;
        if (index == 0) {
            String transformedUri = uri.substring(fileProtocol.length());
            Path transformedPath = new Path(transformedUri);
            resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)transformedPath);
        } else {
            resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        IReporter reporter = null;
        if (resource != null) {
            reporter = this.val.validate((IResource)resource, 0, new ValOperation().getState());
        }
        return reporter;
    }

    protected IResource getWorkspaceFileFromLocation(String location) {
        if (location == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path canonicalForm = new Path(location);
        Path pathLocation = new Path(URIHelper.removeProtocol((String)canonicalForm.toString()));
        IFile resourceFile = workspace.getRoot().getFileForLocation((IPath)pathLocation);
        return resourceFile;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }
}

