/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import org.eclipse.jst.jsf.apache.trinidad.tagsupport.ITrinidadConstants;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommandNavigationItemOperation
extends AbstractTrinidadTransformOperation {
    public Element transform(Element srcElement, Element curElement) {
        Element topElement = null;
        if (this.isDescendentOf(ITrinidadConstants.TAG_IDENTIFIER_BREADCRUMBS, srcElement)) {
            topElement = this.transformForBreadCrumbs(srcElement);
        } else if (this.isDescendentOf(ITrinidadConstants.TAG_IDENTIFIER_NAVIGATIONPANE, srcElement)) {
            Element navPane = this.getAncestor(ITrinidadConstants.TAG_IDENTIFIER_NAVIGATIONPANE, srcElement);
            if (navPane != null) {
                String navPaneHint = navPane.getAttribute("hint");
                topElement = "choice".equalsIgnoreCase(navPaneHint) ? this.transformForNavigationPane_Choice(srcElement) : this.doDefaultTransform(srcElement);
            }
        } else {
            topElement = this.doDefaultTransform(srcElement);
        }
        return topElement;
    }

    private Element transformForBreadCrumbs(Element srcElement) {
        Element anchor = this.createElement("a");
        if (!this.isDisabledOrLastCmdNavItem(srcElement)) {
            this.appendAttribute(anchor, "href", "#");
            this.appendAttribute(anchor, "class", "af_breadCrumbs_step");
        } else {
            this.appendAttribute(anchor, "class", "af_breadCrumbs_selected-step");
        }
        this.appendChildText(CommandNavigationItemOperation.getText(srcElement), anchor);
        return anchor;
    }

    private Element transformForNavigationPane_Choice(Element srcElement) {
        Element option = this.createElement("option");
        if (CommandNavigationItemOperation.isSelected(srcElement)) {
            this.appendAttribute(option, "selected", "selected");
        }
        this.appendChildText(CommandNavigationItemOperation.getText(srcElement), option);
        return option;
    }

    private Element doDefaultTransform(Element srcElement) {
        Element anchor = this.createElement("a");
        if (!CommandNavigationItemOperation.isDisabled(srcElement)) {
            this.appendAttribute(anchor, "href", "#");
        }
        this.appendChildText(CommandNavigationItemOperation.getText(srcElement), anchor);
        return anchor;
    }

    private boolean isDescendentOf(TagIdentifier tagIdentifier, Element srcElement) {
        Node parentNode;
        boolean isDescendent = false;
        if (tagIdentifier != null && srcElement != null && (parentNode = srcElement.getParentNode()) instanceof Element) {
            if (tagIdentifier.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)((Element)parentNode)))) {
                isDescendent = true;
            } else if (IJSFConstants.TAG_IDENTIFIER_FACET.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)((Element)parentNode))) && (parentNode = parentNode.getParentNode()) instanceof Element && tagIdentifier.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)((Element)parentNode)))) {
                isDescendent = true;
            }
        }
        return isDescendent;
    }

    private Element getAncestor(TagIdentifier tagIdentifier, Element srcElement) {
        Node parentNode;
        Element ancestor = null;
        if (tagIdentifier != null && srcElement != null && (parentNode = srcElement.getParentNode()) instanceof Element) {
            if (tagIdentifier.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)((Element)parentNode)))) {
                ancestor = (Element)parentNode;
            } else if (IJSFConstants.TAG_IDENTIFIER_FACET.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)((Element)parentNode))) && (parentNode = parentNode.getParentNode()) instanceof Element && tagIdentifier.isSameTagType(TagIdentifierFactory.createDocumentTagWrapper((Element)((Element)parentNode)))) {
                ancestor = (Element)parentNode;
            }
        }
        return ancestor;
    }

    public static String getText(Element srcElement) {
        String text = "commandNavigationItem";
        if (srcElement != null) {
            String newText = srcElement.getAttribute("textAndAccessKey");
            if (newText != null && newText.length() > 0) {
                text = newText;
            } else {
                newText = srcElement.getAttribute("text");
                if (newText != null && newText.length() > 0) {
                    text = newText;
                } else {
                    newText = srcElement.getAttribute("action");
                    if (newText != null && newText.length() > 0) {
                        text = newText;
                    } else {
                        newText = srcElement.getAttribute("destination");
                        if (newText != null && newText.length() > 0) {
                            text = newText;
                        }
                    }
                }
            }
        }
        return text;
    }

    public static boolean isDisabled(Element srcElement) {
        String disabledAttr = srcElement.getAttribute("disabled");
        return Boolean.TRUE.toString().equalsIgnoreCase(disabledAttr);
    }

    private boolean isDisabledOrLastCmdNavItem(Element srcElement) {
        boolean ret = false;
        String disabledAttr = srcElement.getAttribute("disabled");
        if (Boolean.TRUE.toString().equalsIgnoreCase(disabledAttr)) {
            ret = true;
        } else {
            Node nextSibling = srcElement;
            while (nextSibling != null) {
                if ((nextSibling = nextSibling.getNextSibling()) == null) {
                    ret = true;
                    continue;
                }
                if (nextSibling instanceof Element && TagIdentifierFactory.createDocumentTagWrapper((Element)nextSibling).isSameTagType(ITrinidadConstants.TAG_IDENTIFIER_COMMANDNAVIGATIONITEM)) break;
            }
        }
        return ret;
    }

    public static boolean isSelected(Element srcElement) {
        String selectedAttr = srcElement.getAttribute("selected");
        return Boolean.TRUE.toString().equalsIgnoreCase(selectedAttr);
    }
}

