/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.ui.actions.ActionFactory;

public class PageflowEditorContextMenuProvider
extends ContextMenuProvider {
    private final ActionRegistry actionRegistry;
    private static List<String> DISALLOWED_CONTRIBUTION_IDS = new ArrayList<String>();

    static {
        DISALLOWED_CONTRIBUTION_IDS.add("org.eclipse.debug.ui.contextualLaunch.profile.submenu");
        DISALLOWED_CONTRIBUTION_IDS.add("org.eclipse.debug.ui.contextualLaunch.debug.submenu");
        DISALLOWED_CONTRIBUTION_IDS.add("org.eclipse.debug.ui.contextualLaunch.run.submenu");
    }

    public PageflowEditorContextMenuProvider(EditPartViewer viewer, ActionRegistry actionRegistry) {
        super(viewer);
        this.actionRegistry = actionRegistry;
    }

    public void buildContextMenu(IMenuManager menuManager) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)menuManager);
        this.appendActionToUndoGroup(menuManager, ActionFactory.UNDO.getId());
        this.appendActionToUndoGroup(menuManager, ActionFactory.REDO.getId());
        this.appendActionToEditGroup(menuManager, ActionFactory.COPY.getId());
        this.appendActionToEditGroup(menuManager, ActionFactory.PASTE.getId());
        this.appendActionToEditGroup(menuManager, ActionFactory.DELETE.getId());
        this.appendActionToEditGroup(menuManager, "org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor");
        this.appendActionToSaveGroup(menuManager, ActionFactory.SAVE.getId());
        this.appendAlignmentSubmenu(menuManager);
        this.appendShowViewSubmenu(menuManager);
    }

    private void appendShowViewSubmenu(IMenuManager menuManager) {
        MenuManager submenu = new MenuManager(PageflowMessages.Pageflow_Contextmenu_ShowView_Label);
        IAction action = this.getActionRegistry().getAction((Object)"org.eclipse.jst.jsf.facesconfig.ui.pageflow.action.ShowPropertyViewAction");
        if (action != null && action.isEnabled()) {
            submenu.add(action);
        }
        if (!submenu.isEmpty()) {
            menuManager.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)submenu);
        }
    }

    private void appendAlignmentSubmenu(IMenuManager menuManager) {
        MenuManager submenu = new MenuManager(PageflowMessages.Pageflow_Contextmenu_Align_Label);
        IAction action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_left");
        if (action != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_center")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_right")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_top")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_middle")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if ((action = this.getActionRegistry().getAction((Object)"org.eclipse.gef.align_bottom")) != null && action.isEnabled()) {
            submenu.add(action);
        }
        if (!submenu.isEmpty()) {
            menuManager.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)submenu);
        }
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    private void appendActionToUndoGroup(IMenuManager menu, String actionId) {
        IAction action = this.getActionRegistry().getAction((Object)actionId);
        if (action != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.undo", action);
        }
    }

    private void appendActionToEditGroup(IMenuManager menu, String actionId) {
        IAction action = this.getActionRegistry().getAction((Object)actionId);
        if (action != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.edit", action);
        }
    }

    private void appendActionToSaveGroup(IMenuManager menu, String actionId) {
        IAction action = this.getActionRegistry().getAction((Object)actionId);
        if (action != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.save", action);
        }
    }

    protected boolean allowItem(IContributionItem itemToAdd) {
        String itemToAddId;
        boolean allow = true;
        if (itemToAdd != null && (itemToAddId = itemToAdd.getId()) != null) {
            allow = !DISALLOWED_CONTRIBUTION_IDS.contains(itemToAddId);
        }
        return allow;
    }
}

