/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.interpret;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.core.interpret.Contants;
import org.eclipse.wst.jsdt.internal.core.interpret.InterpretException;
import org.eclipse.wst.jsdt.internal.core.interpret.InterpreterContext;
import org.eclipse.wst.jsdt.internal.core.interpret.InterpreterEngine;
import org.eclipse.wst.jsdt.internal.core.interpret.ObjectValue;
import org.eclipse.wst.jsdt.internal.core.interpret.Value;

public class FunctionValue
extends ObjectValue {
    MethodDeclaration method;
    public ObjectValue prototype = new ObjectValue();

    protected FunctionValue(MethodDeclaration method) {
        this.type = 7;
        this.method = method;
    }

    @Override
    public Value getValue(char[] name) {
        if (CharOperation.equals(Contants.PROTOTYPE_ARR, name)) {
            return this.prototype;
        }
        return super.getValue(name);
    }

    @Override
    public void setValue(char[] name, Value value) {
        if (CharOperation.equals(Contants.PROTOTYPE_ARR, name)) {
            if (value.type != 4) {
                throw new InterpretException("invalid prototype");
            }
            this.prototype = (ObjectValue)value;
        }
        super.setValue(name, value);
    }

    public Value execute(InterpreterEngine interpreter, ObjectValue receiver, Value[] arguments) {
        MethodDeclaration method = this.method;
        InterpreterContext context = interpreter.context = interpreter.newContext(interpreter.context, receiver, method);
        if (method.arguments != null) {
            int i = 0;
            while (i < method.arguments.length) {
                Value value;
                Value value2 = value = i < arguments.length ? arguments[i] : Value.NullObjectValue;
                if (i < arguments.length) {
                    context.setValue(method.arguments[i].name, value);
                }
                ++i;
            }
        }
        interpreter.execBlock(method.statements);
        Value returnValue = context.returnValue;
        if (returnValue == null) {
            returnValue = Value.UndefinedObjectValue;
        }
        interpreter.restorePreviousContext();
        return returnValue;
    }
}

