/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor2;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.GlobalBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LibraryAPIsBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LibraryAPIsScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MetatdataTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MissingBinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSetOfCharArray;
import org.eclipse.wst.jsdt.internal.oaametadata.ClassData;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;

public class LookupEnvironment
implements ProblemReasons,
TypeConstants {
    static final int BUILD_FIELDS_AND_METHODS = 4;
    static final int BUILD_TYPE_HIERARCHY = 1;
    static final int CHECK_AND_SET_IMPORTS = 2;
    static final int CONNECT_TYPE_HIERARCHY = 3;
    static final ProblemReferenceBinding TheNotFoundType = new ProblemReferenceBinding(CharOperation.NO_CHAR, null, 1);
    private Map accessRestrictions;
    ImportBinding[] defaultImports;
    public PackageBinding defaultPackage;
    HashtableOfPackage knownPackages;
    private int lastCompletedUnitIndex = -1;
    private int lastUnitIndex = -1;
    public INameEnvironment nameEnvironment;
    public CompilerOptions globalOptions;
    public ProblemReporter problemReporter;
    private int stepCompleted;
    public ITypeRequestor typeRequestor;
    private ArrayBinding[][] uniqueArrayBindings;
    public CompilationUnitDeclaration unitBeingCompleted = null;
    public Object missingClassFileLocation = null;
    private CompilationUnitDeclaration[] units = new CompilationUnitDeclaration[4];
    private MethodVerifier verifier;
    SimpleSetOfCharArray acceptedCompilationUnits = new SimpleSetOfCharArray();
    private boolean fAddingUnits;
    Stack fAskingForTypeBinding = new CharArrayStack();
    public boolean shouldBuildFieldsAndMethods = true;

    public LookupEnvironment(ITypeRequestor typeRequestor, CompilerOptions globalOptions, ProblemReporter problemReporter, INameEnvironment nameEnvironment) {
        this.typeRequestor = typeRequestor;
        this.globalOptions = globalOptions;
        this.problemReporter = problemReporter;
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.nameEnvironment = nameEnvironment;
        this.knownPackages = new HashtableOfPackage();
        this.uniqueArrayBindings = new ArrayBinding[5][];
        this.uniqueArrayBindings[0] = new ArrayBinding[50];
        this.accessRestrictions = new HashMap(3);
    }

    public ReferenceBinding askForType(char[][] compoundName) {
        NameEnvironmentAnswer answer = this.nameEnvironment.findType(compoundName, this.typeRequestor);
        if (answer == null) {
            return null;
        }
        if (answer.isBinaryType()) {
            this.typeRequestor.accept(answer.getBinaryType(), this.computePackageFrom(compoundName), answer.getAccessRestriction());
        } else if (answer.isCompilationUnit()) {
            ICompilationUnit compilationUnit = answer.getCompilationUnit();
            this.acceptedCompilationUnits.add(compilationUnit.getFileName());
            this.typeRequestor.accept(compilationUnit, answer.getAccessRestriction());
        } else if (answer.isSourceType()) {
            this.typeRequestor.accept(answer.getSourceTypes(), this.computePackageFrom(compoundName), answer.getAccessRestriction());
        } else if (answer.isMetaData()) {
            LibraryAPIs metadata = answer.getLibraryMetadata();
            this.acceptedCompilationUnits.add(metadata.fileName);
            this.typeRequestor.accept(metadata);
        }
        return this.getCachedType(compoundName);
    }

    ReferenceBinding askForType(PackageBinding packageBinding, char[] name) {
        return (ReferenceBinding)this.askForBinding(packageBinding, name, 16388);
    }

    void addUnitsContainingBindings(char[][] types, int kind, String excludePath) {
        if (this.fAddingUnits) {
            return;
        }
        this.fAddingUnits = true;
        try {
            SimpleSetOfCharArray currentAcceptedCompilationUnits = new SimpleSetOfCharArray();
            int i = 0;
            while (i < types.length) {
                NameEnvironmentAnswer answer;
                if (!((kind & 4) > 1 && this.alreadyAskedForBinding(types[i]) || (answer = this.nameEnvironment.findBinding(types[i], this.defaultPackage.compoundName, kind, this.typeRequestor, true, excludePath)) == null)) {
                    if (answer.isBinaryType()) {
                        this.typeRequestor.accept(answer.getBinaryType(), this.defaultPackage, answer.getAccessRestriction());
                    } else if (answer.isSourceType()) {
                        this.typeRequestor.accept(answer.getSourceTypes(), this.defaultPackage, answer.getAccessRestriction());
                    } else if (answer.isCompilationUnit()) {
                        ICompilationUnit compilationUnit = answer.getCompilationUnit();
                        this.acceptedCompilationUnits.add(compilationUnit.getFileName());
                        if (this.typeRequestor instanceof ITypeRequestor2) {
                            ((ITypeRequestor2)this.typeRequestor).accept(compilationUnit, types, answer.getAccessRestriction());
                        } else {
                            this.typeRequestor.accept(compilationUnit, answer.getAccessRestriction());
                        }
                    } else if (answer.isCompilationUnits()) {
                        ICompilationUnit[] compilationUnits = answer.getCompilationUnits();
                        int j = 0;
                        while (j < compilationUnits.length) {
                            this.acceptedCompilationUnits.add(compilationUnits[j].getFileName());
                            if (!currentAcceptedCompilationUnits.includes(compilationUnits[j].getFileName())) {
                                currentAcceptedCompilationUnits.add(compilationUnits[j].getFileName());
                                if (this.typeRequestor instanceof ITypeRequestor2) {
                                    ((ITypeRequestor2)this.typeRequestor).accept(compilationUnits[j], types, answer.getAccessRestriction());
                                } else {
                                    this.typeRequestor.accept(compilationUnits[j], answer.getAccessRestriction());
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            this.fAddingUnits = false;
        }
    }

    void addUnitsContainingBinding(PackageBinding packageBinding, char[] type, int mask, String excludePath) {
        NameEnvironmentAnswer answer;
        if (packageBinding == null) {
            if (this.defaultPackage == null) {
                return;
            }
            packageBinding = this.defaultPackage;
        }
        if ((answer = this.nameEnvironment.findBinding(type, packageBinding.compoundName, mask, this.typeRequestor, true, excludePath)) == null) {
            return;
        }
        if (answer.isBinaryType()) {
            this.typeRequestor.accept(answer.getBinaryType(), packageBinding, answer.getAccessRestriction());
        } else if (answer.isCompilationUnit()) {
            ICompilationUnit compilationUnit = answer.getCompilationUnit();
            if (!this.acceptedCompilationUnits.includes(compilationUnit.getFileName())) {
                this.acceptedCompilationUnits.add(compilationUnit.getFileName());
                this.typeRequestor.accept(compilationUnit, answer.getAccessRestriction());
            }
        } else if (answer.isCompilationUnits()) {
            ICompilationUnit[] compilationUnits = answer.getCompilationUnits();
            int i = 0;
            while (i < compilationUnits.length) {
                if (!this.acceptedCompilationUnits.includes(compilationUnits[i].getFileName())) {
                    this.acceptedCompilationUnits.add(compilationUnits[i].getFileName());
                    this.typeRequestor.accept(compilationUnits[i], answer.getAccessRestriction());
                }
                ++i;
            }
        } else if (answer.isSourceType()) {
            this.typeRequestor.accept(answer.getSourceTypes(), packageBinding, answer.getAccessRestriction());
        }
    }

    Binding askForBinding(GlobalBinding globalBinding, char[] name, int mask) {
        return null;
    }

    Binding askForBinding(PackageBinding packageBinding, char[] name, int mask) {
        if (packageBinding == null) {
            if (this.defaultPackage == null) {
                return null;
            }
            packageBinding = this.defaultPackage;
        }
        if (mask == 16384 && (name == null || name.length == 0) && this.defaultPackage.compoundName.length == 0) {
            return this.defaultPackage;
        }
        NameEnvironmentAnswer answer = this.nameEnvironment.findBinding(name, packageBinding.compoundName, mask, this.typeRequestor, true, null);
        if (answer == null) {
            return null;
        }
        if ((mask & 4) > 1) {
            if (this.alreadyAskedForBinding(name)) {
                return null;
            }
            this.fAskingForTypeBinding.push(name);
        }
        try {
            if (answer.isBinaryType()) {
                this.typeRequestor.accept(answer.getBinaryType(), packageBinding, answer.getAccessRestriction());
            } else if (answer.isCompilationUnit()) {
                ICompilationUnit compilationUnit = answer.getCompilationUnit();
                this.acceptedCompilationUnits.add(compilationUnit.getFileName());
                if (!compilationUnit.equals(this.unitBeingCompleted)) {
                    if (this.typeRequestor instanceof ITypeRequestor2) {
                        ((ITypeRequestor2)this.typeRequestor).accept(compilationUnit, new char[][]{name}, answer.getAccessRestriction());
                    } else {
                        this.typeRequestor.accept(compilationUnit, answer.getAccessRestriction());
                    }
                }
            } else if (answer.isCompilationUnits()) {
                ICompilationUnit[] compilationUnits = answer.getCompilationUnits();
                int i = 0;
                while (i < compilationUnits.length) {
                    this.acceptedCompilationUnits.add(compilationUnits[i].getFileName());
                    if (!compilationUnits[i].equals(this.unitBeingCompleted)) {
                        if (this.typeRequestor instanceof ITypeRequestor2) {
                            ((ITypeRequestor2)this.typeRequestor).accept(compilationUnits[i], new char[][]{name}, answer.getAccessRestriction());
                        } else {
                            this.typeRequestor.accept(compilationUnits[i], answer.getAccessRestriction());
                        }
                    }
                    ++i;
                }
            } else if (answer.isSourceType()) {
                this.typeRequestor.accept(answer.getSourceTypes(), packageBinding, answer.getAccessRestriction());
            } else if (answer.isMetaData()) {
                LibraryAPIs metadata = answer.getLibraryMetadata();
                this.acceptedCompilationUnits.add(metadata.fileName);
                this.typeRequestor.accept(metadata);
            }
        }
        finally {
            if (mask == 4) {
                this.fAskingForTypeBinding.pop();
            }
        }
        return packageBinding.getBinding0(name, mask);
    }

    public void buildTypeBindings(CompilationUnitDeclaration unit, AccessRestriction accessRestriction) {
    }

    public void buildTypeBindings(CompilationUnitDeclaration unit, AccessRestriction accessRestriction, boolean shouldBuildGlobalSuperType) {
    }

    public void buildTypeBindings(CompilationUnitDeclaration unit, char[][] typeNames, AccessRestriction accessRestriction) {
    }

    public void buildTypeBindings(CompilationUnitDeclaration unit, char[][] typeNames, AccessRestriction accessRestriction, boolean shouldBuildGlobalSuperType) {
        CompilationUnitScope scope = unit.scope;
        boolean addUnit = false;
        if (scope == null) {
            scope = new CompilationUnitScope(unit, this);
            addUnit = true;
        }
        scope.setShouldBuildGlobalSuperType(shouldBuildGlobalSuperType);
        if (addUnit) {
            int unitsLength = this.units.length;
            if (++this.lastUnitIndex >= unitsLength) {
                this.units = new CompilationUnitDeclaration[2 * unitsLength];
                System.arraycopy(this.units, 0, this.units, 0, unitsLength);
            }
            this.units[this.lastUnitIndex] = unit;
        }
    }

    public BinaryTypeBinding cacheBinaryType(ISourceType binaryType, AccessRestriction accessRestriction) {
        return this.cacheBinaryType(binaryType, true, accessRestriction);
    }

    public BinaryTypeBinding cacheBinaryType(ISourceType binaryType, boolean needFieldsAndMethods, AccessRestriction accessRestriction) {
        char[][] compoundName = CharOperation.splitOn('/', binaryType.getName());
        ReferenceBinding existingType = this.getCachedType(compoundName);
        if (existingType == null || existingType instanceof UnresolvedReferenceBinding) {
            return this.createBinaryTypeFrom(binaryType, this.computePackageFrom(compoundName), needFieldsAndMethods, accessRestriction);
        }
        return null;
    }

    public MissingBinaryTypeBinding cacheMissingBinaryType(char[][] compoundName, CompilationUnitDeclaration unit) {
        PackageBinding packageBinding = this.computePackageFrom(compoundName);
        if (unit == null) {
            return null;
        }
        MissingBinaryTypeBinding type = new MissingBinaryTypeBinding(packageBinding, compoundName, this, unit.scope);
        if (type.id != 1) {
            ReferenceBinding objectType = this.getType(TypeConstants.JAVA_LANG_OBJECT);
            if (objectType == null) {
                objectType = this.cacheMissingBinaryType(TypeConstants.JAVA_LANG_OBJECT, unit);
            }
            type.setMissingSuperclass(objectType);
        }
        packageBinding.addType(type);
        return type;
    }

    public void completeTypeBindings() {
        this.stepCompleted = 1;
        int i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            this.unitBeingCompleted = this.units[i];
            this.unitBeingCompleted.scope.checkAndSetImports();
            ++i;
        }
        this.stepCompleted = 2;
        i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            this.unitBeingCompleted = this.units[i];
            this.unitBeingCompleted.scope.connectTypeHierarchy();
            ++i;
        }
        this.stepCompleted = 3;
        i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            this.unitBeingCompleted = this.units[i];
            CompilationUnitScope unitScope = this.unitBeingCompleted.scope;
            unitScope.buildFieldsAndMethods();
            this.units[i] = null;
            ++i;
        }
        this.stepCompleted = 4;
        this.lastCompletedUnitIndex = this.lastUnitIndex;
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(char[][] types) {
        this.stepCompleted = 1;
        int i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            this.unitBeingCompleted = this.units[i];
            this.unitBeingCompleted.scope.checkAndSetImports();
            ++i;
        }
        this.stepCompleted = 2;
        i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            this.unitBeingCompleted = this.units[i];
            this.unitBeingCompleted.scope.connectTypeHierarchy(types);
            ++i;
        }
        this.stepCompleted = 3;
        i = this.lastCompletedUnitIndex + 1;
        while (i <= this.lastUnitIndex) {
            this.unitBeingCompleted = this.units[i];
            CompilationUnitScope unitScope = this.unitBeingCompleted.scope;
            unitScope.buildFieldsAndMethods();
            this.units[i] = null;
            ++i;
        }
        this.stepCompleted = 4;
        this.lastCompletedUnitIndex = this.lastUnitIndex;
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(CompilationUnitDeclaration parsedUnit) {
        this.completeTypeBindings(parsedUnit, CharOperation.NO_CHAR_CHAR);
    }

    public void completeTypeBindings(CompilationUnitDeclaration parsedUnit, char[][] typeNames) {
        if (this.stepCompleted == 4) {
            this.completeTypeBindings();
        } else {
            if (parsedUnit.scope == null) {
                return;
            }
            if (this.stepCompleted >= 2) {
                this.unitBeingCompleted = parsedUnit;
                this.unitBeingCompleted.scope.checkAndSetImports();
            }
            if (this.stepCompleted >= 3) {
                this.unitBeingCompleted = parsedUnit;
                this.unitBeingCompleted.scope.connectTypeHierarchy(typeNames);
            }
            this.unitBeingCompleted = null;
        }
    }

    public void completeTypeBindings(CompilationUnitDeclaration parsedUnit, char[][] typeNames, boolean buildFieldsAndMethods) {
        if (parsedUnit.scope == null) {
            return;
        }
        this.unitBeingCompleted = parsedUnit;
        this.unitBeingCompleted.scope.checkAndSetImports();
        parsedUnit.scope.connectTypeHierarchy(typeNames);
        if (buildFieldsAndMethods) {
            this.shouldBuildFieldsAndMethods = false;
            try {
                parsedUnit.scope.buildFieldsAndMethods();
            }
            finally {
                this.shouldBuildFieldsAndMethods = true;
            }
        }
        this.unitBeingCompleted = null;
    }

    public void completeTypeBindings(CompilationUnitDeclaration parsedUnit, boolean buildFieldsAndMethods) {
        this.completeTypeBindings(parsedUnit, CharOperation.NO_CHAR_CHAR, buildFieldsAndMethods);
    }

    public TypeBinding computeBoxingType(TypeBinding type) {
        switch (type.id) {
            case 33: {
                return TypeBinding.BOOLEAN;
            }
            case 28: {
                return TypeBinding.CHAR;
            }
            case 27: {
                return TypeBinding.SHORT;
            }
            case 32: {
                return TypeBinding.DOUBLE;
            }
            case 31: {
                return TypeBinding.FLOAT;
            }
            case 29: {
                return TypeBinding.INT;
            }
            case 30: {
                return TypeBinding.LONG;
            }
            case 10: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_INTEGER);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_INTEGER, null, 1);
            }
            case 4: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_SHORT);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_SHORT, null, 1);
            }
            case 2: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_CHARACTER);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_CHARACTER, null, 1);
            }
            case 7: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_LONG);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_LONG, null, 1);
            }
            case 9: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_FLOAT);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_FLOAT, null, 1);
            }
            case 8: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_DOUBLE);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_DOUBLE, null, 1);
            }
            case 5: {
                ReferenceBinding boxedType = this.getType(JAVA_LANG_BOOLEAN);
                if (boxedType != null) {
                    return boxedType;
                }
                return new ProblemReferenceBinding(JAVA_LANG_BOOLEAN, null, 1);
            }
        }
        return type;
    }

    private PackageBinding computePackageFrom(char[][] constantPoolName) {
        return this.defaultPackage;
    }

    public ArrayBinding createArrayType(TypeBinding leafComponentType, int dimensionCount) {
        ArrayBinding[] arrayBindings;
        if (leafComponentType instanceof LocalTypeBinding) {
            return ((LocalTypeBinding)leafComponentType).createArrayType(dimensionCount, this);
        }
        int dimIndex = dimensionCount - 1;
        int length = this.uniqueArrayBindings.length;
        if (dimIndex < length) {
            arrayBindings = this.uniqueArrayBindings[dimIndex];
            if (arrayBindings == null) {
                arrayBindings = new ArrayBinding[10];
                this.uniqueArrayBindings[dimIndex] = arrayBindings;
            }
        } else {
            this.uniqueArrayBindings = new ArrayBinding[dimensionCount][];
            System.arraycopy(this.uniqueArrayBindings, 0, this.uniqueArrayBindings, 0, length);
            arrayBindings = new ArrayBinding[10];
            this.uniqueArrayBindings[dimIndex] = arrayBindings;
        }
        int index = -1;
        length = arrayBindings.length;
        while (++index < length) {
            ArrayBinding currentBinding = arrayBindings[index];
            if (currentBinding == null) {
                arrayBindings[index] = new ArrayBinding(leafComponentType, dimensionCount, this);
                return arrayBindings[index];
            }
            if (currentBinding.leafComponentType != leafComponentType) continue;
            return currentBinding;
        }
        ArrayBinding[] arrayBindingArray = arrayBindings;
        arrayBindings = new ArrayBinding[length * 2];
        System.arraycopy(arrayBindingArray, 0, arrayBindings, 0, length);
        this.uniqueArrayBindings[dimIndex] = arrayBindings;
        arrayBindings[length] = new ArrayBinding(leafComponentType, dimensionCount, this);
        return arrayBindings[length];
    }

    public BinaryTypeBinding createBinaryTypeFrom(ISourceType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        return this.createBinaryTypeFrom(binaryType, packageBinding, true, accessRestriction);
    }

    public BinaryTypeBinding createBinaryTypeFrom(ISourceType binaryType, PackageBinding packageBinding, boolean needFieldsAndMethods, AccessRestriction accessRestriction) {
        BinaryTypeBinding binaryBinding = new BinaryTypeBinding(packageBinding, binaryType, this);
        ReferenceBinding cachedType = packageBinding.getType0(binaryBinding.compoundName[binaryBinding.compoundName.length - 1]);
        if (cachedType != null) {
            if (cachedType instanceof UnresolvedReferenceBinding) {
                ((UnresolvedReferenceBinding)cachedType).setResolvedType(binaryBinding, this);
            } else {
                if (cachedType.isBinaryBinding()) {
                    return (BinaryTypeBinding)cachedType;
                }
                return null;
            }
        }
        packageBinding.addType(binaryBinding);
        this.setAccessRestriction(binaryBinding, accessRestriction);
        binaryBinding.cachePartsFrom(binaryType, needFieldsAndMethods);
        return binaryBinding;
    }

    public PackageBinding createPackage(char[][] compoundName) {
        PackageBinding packageBinding = this.getPackage0(compoundName[0]);
        if (packageBinding == null) {
            packageBinding = new PackageBinding(compoundName[0], this);
        }
        int i = 1;
        int length = compoundName.length;
        while (i < length) {
            ReferenceBinding type = packageBinding.getType0(compoundName[i]);
            if (type != null && type != TheNotFoundType && !(type instanceof UnresolvedReferenceBinding)) {
                return null;
            }
            PackageBinding parent = packageBinding;
            if ((packageBinding = parent.getPackage0(compoundName[i])) == null) {
                packageBinding = new PackageBinding(CharOperation.subarray(compoundName, 0, i + 1), parent, this);
                parent.addPackage(packageBinding);
            }
            ++i;
        }
        return packageBinding;
    }

    public AccessRestriction getAccessRestriction(TypeBinding type) {
        return (AccessRestriction)this.accessRestrictions.get(type);
    }

    public ReferenceBinding getCachedType(char[][] compoundName) {
        if (compoundName.length == 1) {
            if (this.defaultPackage == null) {
                return null;
            }
            return this.defaultPackage.getType0(compoundName[0]);
        }
        PackageBinding packageBinding = this.getPackage0(compoundName[0]);
        if (packageBinding == null) {
            return null;
        }
        int i = 1;
        int packageLength = compoundName.length - 1;
        while (i < packageLength) {
            if ((packageBinding = packageBinding.getPackage0(compoundName[i])) == null) {
                return null;
            }
            ++i;
        }
        return packageBinding.getType0(compoundName[compoundName.length - 1]);
    }

    PackageBinding getPackage0(char[] name) {
        if (CharOperation.equals(name, this.defaultPackage.readableName())) {
            return this.defaultPackage;
        }
        return this.knownPackages.get(name);
    }

    public ReferenceBinding getResolvedType(char[][] compoundName, Scope scope) {
        ReferenceBinding type = this.getType(compoundName);
        if (type != null) {
            return type;
        }
        return this.cacheMissingBinaryType(compoundName, scope == null ? this.unitBeingCompleted : scope.referenceCompilationUnit());
    }

    PackageBinding getTopLevelPackage(char[] name) {
        if (CharOperation.equals(name, this.defaultPackage.readableName())) {
            return this.defaultPackage;
        }
        PackageBinding packageBinding = this.getPackage0(name);
        if (packageBinding != null) {
            return packageBinding;
        }
        if (this.nameEnvironment.isPackage(null, name)) {
            packageBinding = new PackageBinding(name, this);
            this.knownPackages.put(name, packageBinding);
            return packageBinding;
        }
        return null;
    }

    public ReferenceBinding getType(char[][] compoundName) {
        ReferenceBinding referenceBinding;
        if (compoundName.length == 1) {
            if (this.defaultPackage == null) {
                return null;
            }
            referenceBinding = this.defaultPackage.getType0(compoundName[0]);
            if (referenceBinding == null) {
                PackageBinding packageBinding = this.getPackage0(compoundName[0]);
                if (packageBinding != null) {
                    return null;
                }
                referenceBinding = this.askForType(this.defaultPackage, compoundName[0]);
            }
        } else {
            PackageBinding packageBinding = this.getPackage0(compoundName[0]);
            if (packageBinding != null) {
                int i = 1;
                int packageLength = compoundName.length - 1;
                while (i < packageLength) {
                    if ((packageBinding = packageBinding.getPackage0(compoundName[i])) == null) break;
                    ++i;
                }
            }
            if (packageBinding == null) {
                referenceBinding = this.askForType(compoundName);
            } else {
                referenceBinding = packageBinding.getType0(compoundName[compoundName.length - 1]);
                if (referenceBinding == null) {
                    referenceBinding = this.askForType(packageBinding, compoundName[compoundName.length - 1]);
                }
            }
        }
        if (referenceBinding == null || referenceBinding == TheNotFoundType) {
            return null;
        }
        if ((referenceBinding = BinaryTypeBinding.resolveType(referenceBinding, this, false)) == null || referenceBinding == TheNotFoundType) {
            return null;
        }
        if (referenceBinding.isNestedType()) {
            return new ProblemReferenceBinding(compoundName, referenceBinding, 4);
        }
        return referenceBinding;
    }

    ReferenceBinding getTypeFromCompoundName(char[][] compoundName, boolean isParameterized) {
        ReferenceBinding binding = this.getCachedType(compoundName);
        if (binding == null) {
            PackageBinding packageBinding = this.computePackageFrom(compoundName);
            binding = new UnresolvedReferenceBinding(compoundName, packageBinding);
            packageBinding.addType(binding);
        } else if (binding == TheNotFoundType) {
            binding = this.cacheMissingBinaryType(compoundName, this.unitBeingCompleted);
        }
        return binding;
    }

    ReferenceBinding getTypeFromConstantPoolName(char[] signature, int start, int end, boolean isParameterized) {
        if (end == -1) {
            end = signature.length;
        }
        char[][] compoundName = CharOperation.splitOn('/', signature, start, end);
        return this.getTypeFromCompoundName(compoundName, isParameterized);
    }

    TypeBinding getTypeFromSignature(char[] signature, int start, int end, boolean isParameterized, TypeBinding enclosingType) {
        int dimension = 0;
        while (signature[start] == '[') {
            ++start;
            ++dimension;
        }
        if (end == -1) {
            end = signature.length - 1;
        }
        TypeBinding binding = null;
        if (start == end) {
            switch (signature[start]) {
                case 'I': {
                    binding = TypeBinding.INT;
                    break;
                }
                case 'Z': {
                    binding = TypeBinding.BOOLEAN;
                    break;
                }
                case 'V': {
                    binding = TypeBinding.VOID;
                    break;
                }
                case 'C': {
                    binding = TypeBinding.CHAR;
                    break;
                }
                case 'D': {
                    binding = TypeBinding.DOUBLE;
                    break;
                }
                case 'F': {
                    binding = TypeBinding.FLOAT;
                    break;
                }
                case 'J': {
                    binding = TypeBinding.LONG;
                    break;
                }
                case 'S': {
                    binding = TypeBinding.SHORT;
                    break;
                }
                default: {
                    this.problemReporter.corruptedSignature(enclosingType, signature, start);
                    break;
                }
            }
        } else {
            binding = this.getTypeFromConstantPoolName(signature, start + 1, end, isParameterized);
        }
        if (dimension == 0) {
            return binding;
        }
        return this.createArrayType(binding, dimension);
    }

    TypeBinding getTypeFromTypeSignature(SignatureWrapper wrapper, ReferenceBinding enclosingType) {
        int dimension = 0;
        while (wrapper.signature[wrapper.start] == '[') {
            ++wrapper.start;
            ++dimension;
        }
        if (wrapper.signature[wrapper.start] == 'T') {
            return null;
        }
        TypeBinding type = this.getTypeFromSignature(wrapper.signature, wrapper.start, wrapper.computeEnd(), false, enclosingType);
        return dimension == 0 ? type : this.createArrayType(type, dimension);
    }

    TypeBinding getTypeFromVariantTypeSignature(SignatureWrapper wrapper, ReferenceBinding enclosingType, ReferenceBinding genericType, int rank) {
        switch (wrapper.signature[wrapper.start]) {
            case '-': {
                ++wrapper.start;
                this.getTypeFromTypeSignature(wrapper, enclosingType);
            }
            case '+': {
                ++wrapper.start;
                this.getTypeFromTypeSignature(wrapper, enclosingType);
            }
            case '*': {
                ++wrapper.start;
            }
        }
        return this.getTypeFromTypeSignature(wrapper, enclosingType);
    }

    boolean isPackage(char[][] compoundName, char[] name) {
        if (compoundName == null || compoundName.length == 0) {
            return this.nameEnvironment.isPackage(null, name);
        }
        return this.nameEnvironment.isPackage(compoundName, name);
    }

    public MethodVerifier methodVerifier() {
        if (this.verifier == null) {
            this.verifier = new MethodVerifier(this);
        }
        return this.verifier;
    }

    public void reset() {
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.accessRestrictions = new HashMap(3);
        this.verifier = null;
        int i = this.uniqueArrayBindings.length;
        while (--i >= 0) {
            ArrayBinding[] arrayBindings = this.uniqueArrayBindings[i];
            if (arrayBindings == null) continue;
            int j = arrayBindings.length;
            while (--j >= 0) {
                arrayBindings[j] = null;
            }
        }
        i = this.units.length;
        while (--i >= 0) {
            this.units[i] = null;
        }
        this.lastUnitIndex = -1;
        this.lastCompletedUnitIndex = -1;
        this.unitBeingCompleted = null;
        this.acceptedCompilationUnits.clear();
        this.fAskingForTypeBinding.clear();
    }

    public void setAccessRestriction(ReferenceBinding type, AccessRestriction accessRestriction) {
        if (accessRestriction == null) {
            return;
        }
        type.modifiers |= 0x40000;
        this.accessRestrictions.put(type, accessRestriction);
    }

    public void buildTypeBindings(LibraryAPIs libraryMetaData) {
        ClassData[] classes = libraryMetaData.classes;
        PackageBinding packageBinding = this.defaultPackage;
        int typeLength = classes != null ? classes.length : 0;
        int count = 0;
        LibraryAPIsScope scope = new LibraryAPIsScope(libraryMetaData, this);
        SourceTypeBinding[] topLevelTypes = new SourceTypeBinding[typeLength];
        int i = 0;
        while (i < typeLength) {
            ClassData clazz = classes[i];
            char[][] className = CharOperation.arrayConcat(packageBinding.compoundName, clazz.name.toCharArray());
            MetatdataTypeBinding binding = new MetatdataTypeBinding(className, packageBinding, clazz, scope);
            this.defaultPackage.addType(binding);
            binding.fPackage.addType(binding);
            topLevelTypes[count++] = binding;
            ++i;
        }
        if (count != topLevelTypes.length) {
            SourceTypeBinding[] sourceTypeBindingArray = topLevelTypes;
            topLevelTypes = new SourceTypeBinding[count];
            System.arraycopy(sourceTypeBindingArray, 0, topLevelTypes, 0, count);
        }
        char[] fullFileName = libraryMetaData.fileName;
        LibraryAPIsBinding libraryAPIsBinding = new LibraryAPIsBinding(null, this.defaultPackage, fullFileName);
        if (packageBinding != this.defaultPackage) {
            packageBinding.addBinding(libraryAPIsBinding, libraryAPIsBinding.shortReadableName(), 8192);
        }
    }

    public CompilationUnitDeclaration getExistingCompilationUnitDeclaration(char[] fileName) {
        int i = 0;
        while (i <= this.lastUnitIndex) {
            if (CharOperation.equals(this.units[i].getFileName(), fileName)) {
                return this.units[i];
            }
            ++i;
        }
        return null;
    }

    private boolean alreadyAskedForBinding(char[] typeName) {
        return !this.fAskingForTypeBinding.isEmpty() && this.fAskingForTypeBinding.contains(typeName);
    }

    private static class CharArrayStack
    extends Stack {
        private static final long serialVersionUID = 1L;

        private CharArrayStack() {
        }

        @Override
        public boolean contains(Object o) {
            boolean contains = false;
            contains = o instanceof char[] ? this.search(o) != -1 : super.contains(o);
            return contains;
        }

        @Override
        public synchronized int search(Object o) {
            int index = -1;
            if (o instanceof char[]) {
                int i = 0;
                while (i < this.size() && index == -1) {
                    Object curr = this.get(i);
                    if (curr instanceof char[] && CharOperation.equals((char[])o, (char[])curr)) {
                        index = i;
                    }
                    ++i;
                }
            } else {
                index = super.search(o);
            }
            return index;
        }
    }
}

