/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.CaseStatement;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InnerEmulationDependency;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;

public final class LocalTypeBinding
extends NestedTypeBinding {
    static final char[] LocalTypePrefix = new char[]{'$', 'L', 'o', 'c', 'a', 'l', '$'};
    private InnerEmulationDependency[] dependents;
    public ArrayBinding[] localArrayBindings;
    public CaseStatement enclosingCase;
    public int sourceStart;
    public MethodBinding enclosingMethod;

    public LocalTypeBinding(ClassScope scope, SourceTypeBinding enclosingType, CaseStatement switchCase) {
        super((char[][])new char[][]{CharOperation.concat(LocalTypePrefix, scope.referenceContext.name)}, scope, enclosingType);
        this.tagBits = this.sourceName == CharOperation.NO_CHAR ? (this.tagBits |= 0x34L) : (this.tagBits |= 0x14L);
        this.enclosingCase = switchCase;
        this.sourceStart = scope.referenceContext.sourceStart;
        MethodScope methodScope = scope.enclosingMethodScope();
        AbstractMethodDeclaration declaration = methodScope.referenceMethod();
        if (declaration != null) {
            this.enclosingMethod = declaration.getBinding();
        }
    }

    public void addInnerEmulationDependent(BlockScope dependentScope, boolean wasEnclosingInstanceSupplied) {
        int index;
        if (this.dependents == null) {
            index = 0;
            this.dependents = new InnerEmulationDependency[1];
        } else {
            index = this.dependents.length;
            int i = 0;
            while (i < index) {
                if (this.dependents[i].scope == dependentScope) {
                    return;
                }
                ++i;
            }
            this.dependents = new InnerEmulationDependency[index + 1];
            System.arraycopy(this.dependents, 0, this.dependents, 0, index);
        }
        this.dependents[index] = new InnerEmulationDependency(dependentScope, wasEnclosingInstanceSupplied);
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        char[] outerKey = this.outermostEnclosingType().computeUniqueKey(isLeaf);
        int semicolon = CharOperation.lastIndexOf(';', outerKey);
        StringBuffer sig = new StringBuffer();
        sig.append(outerKey, 0, semicolon);
        sig.append('$');
        sig.append(String.valueOf(this.sourceStart));
        if (!this.isAnonymousType()) {
            sig.append('$');
            sig.append(this.sourceName);
        }
        sig.append(outerKey, semicolon, outerKey.length - semicolon);
        int sigLength = sig.length();
        char[] uniqueKey = new char[sigLength];
        sig.getChars(0, sigLength, uniqueKey, 0);
        return uniqueKey;
    }

    @Override
    public char[] constantPoolName() {
        return this.constantPoolName;
    }

    ArrayBinding createArrayType(int dimensionCount, LookupEnvironment lookupEnvironment) {
        if (this.localArrayBindings == null) {
            this.localArrayBindings = new ArrayBinding[]{new ArrayBinding(this, dimensionCount, lookupEnvironment)};
            return this.localArrayBindings[0];
        }
        int length = this.localArrayBindings.length;
        int i = 0;
        while (i < length) {
            if (this.localArrayBindings[i].dimensions == dimensionCount) {
                return this.localArrayBindings[i];
            }
            ++i;
        }
        this.localArrayBindings = new ArrayBinding[length + 1];
        System.arraycopy(this.localArrayBindings, 0, this.localArrayBindings, 0, length);
        this.localArrayBindings[length] = new ArrayBinding(this, dimensionCount, lookupEnvironment);
        return this.localArrayBindings[length];
    }

    @Override
    public char[] readableName() {
        char[] readableName = this.isAnonymousType() ? CharOperation.concat(TypeConstants.ANONYM_PREFIX, this.getSuperBinding0().readableName(), TypeConstants.ANONYM_SUFFIX) : (this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : this.sourceName);
        return readableName;
    }

    @Override
    public char[] shortReadableName() {
        char[] shortReadableName = this.isAnonymousType() ? CharOperation.concat(TypeConstants.ANONYM_PREFIX, this.getSuperBinding0().shortReadableName(), TypeConstants.ANONYM_SUFFIX) : (this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.sourceName);
        return shortReadableName;
    }

    public void setAsMemberType() {
        this.tagBits |= 0xCL;
    }

    public void setConstantPoolName(char[] computedConstantPoolName) {
        this.constantPoolName = computedConstantPoolName;
    }

    @Override
    public char[] signature() {
        if (this.signature == null && this.constantPoolName() == null) {
            if (this.isAnonymousType()) {
                this.setConstantPoolName(this.getSuperBinding().sourceName());
            } else {
                this.setConstantPoolName(this.sourceName());
            }
        }
        return super.signature();
    }

    @Override
    public char[] sourceName() {
        if (this.isAnonymousType()) {
            return CharOperation.concat(TypeConstants.ANONYM_PREFIX, this.getSuperBinding0().sourceName(), TypeConstants.ANONYM_SUFFIX);
        }
        return this.sourceName;
    }

    @Override
    public String toString() {
        if (this.isAnonymousType()) {
            return "Anonymous type : " + super.toString();
        }
        if (this.isMemberType()) {
            return "Local member type : " + new String(this.sourceName()) + " " + super.toString();
        }
        return "Local type : " + new String(this.sourceName()) + " " + super.toString();
    }
}

