/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.resources;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.designtime.internal.resources.Messages;
import org.eclipse.jst.jsf.designtime.internal.resources.ResourceFragmentIdentifier;

public class ResourceIdentifier
extends ResourceFragmentIdentifier {
    public static final int RESOURCE_NAME_MUST_NOT_BE_EMPTY = 0;
    public static final String ResourceIdentifierValidationNamespace = "org.eclipse.jst.jsf.core_JSFResourceIdentifier";
    private final String _resName;

    public ResourceIdentifier(String resName) {
        this._resName = resName;
    }

    protected ResourceIdentifier() {
        this._resName = null;
    }

    @Override
    public String getResourceName() {
        return this._resName;
    }

    @Override
    public IStatus validate() {
        MultiStatus status = new MultiStatus(ResourceIdentifierValidationNamespace, 0, "Resource identifier problems", null);
        if (this.getResourceName() == null) {
            status.add((IStatus)new Status(4, ResourceIdentifierValidationNamespace, 0, Messages.ResourceIdentifier_0, null));
        }
        return status;
    }

    @Override
    public String toString() {
        if (!this.validate().isOK()) {
            throw new IllegalStateException();
        }
        String idString = this.getResourceName();
        if (this.getResourceVersion() != null) {
            idString = String.format("%s/%s", this.getResourceVersion(), idString);
        }
        if (this.getLibraryName() != null) {
            idString = String.format("%s/%s", this.getLibraryName(), idString);
        }
        if (this.getLocalePrefix() != null) {
            idString = String.format("%s/%s", this.getLocalePrefix(), idString);
        }
        if (this.getResourceVersion() != null) {
            idString = String.valueOf(idString) + "/" + this.getResourceVersion();
        }
        return idString;
    }

    @Override
    public final boolean isFragment() {
        return false;
    }
}

