/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import java.io.File;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;
import org.w3c.dom.Element;

public class TestCyclicGroupReferences
extends TestCase {
    private boolean isSetup = false;
    private final String fProjectName = "CyclicGroupReference";
    private final String fZipFileName = "cyclicgrouptestfiles.zip";

    public TestCyclicGroupReferences() {
        super("TestCyclicGroupReferences");
    }

    public void testCyclicGroupReferences() {
        IFile file = this.getFile("Test.xml");
        CMVisitor cmVisitor = new CMVisitor();
        IStructuredModel model = null;
        try {
            try {
                IModelManager modelManager = StructuredModelManager.getModelManager();
                model = modelManager.getModelForRead(file);
                TestCyclicGroupReferences.assertNotNull((String)"failure loading model", (Object)model);
                IDOMModel domModel = (IDOMModel)model;
                IDOMDocument document = domModel.getDocument();
                TestCyclicGroupReferences.assertNotNull((String)"failure getting document", (Object)document);
                ModelQuery modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)model);
                TestCyclicGroupReferences.assertNotNull((String)"ModelQuery is missing", (Object)modelQuery);
                IDOMElement documentElement = (IDOMElement)document.getDocumentElement();
                TestCyclicGroupReferences.assertNotNull((String)"missing document element", (Object)documentElement);
                CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration((Element)documentElement);
                TestCyclicGroupReferences.assertNotNull((String)("No element declaration for" + documentElement.getNodeName() + " (" + documentElement.getNamespaceURI() + ")"), (Object)cmElementDeclaration);
                cmVisitor.visitCMElementDeclaration(cmElementDeclaration);
            }
            catch (Throwable th) {
                TestCyclicGroupReferences.fail((String)("Test failed :" + th.getClass().getName()));
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "cyclicgrouptestfiles.zip", "projecttestfiles");
        URL platformLocationURL = platformLocation.getURL();
        String file = platformLocationURL.getFile();
        unzipUtil.unzipAndImport(zipFile, file);
        unzipUtil.initJavaProject("CyclicGroupReference");
    }

    private IFile getFile(String fileName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        Path path = new Path("CyclicGroupReference/" + fileName);
        return root.getFile((IPath)path);
    }
}

