/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingParameterStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingStyle;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.SOAPBindingUse;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.sync.SynchronizationTestFixture;
import org.eclipse.jst.ws.jaxws.testutils.jobs.JobUtils;
import org.eclipse.jst.ws.jaxws.utils.JaxWsUtils;

public class WsSynchronizationTest
extends SynchronizationTestFixture {
    public void test_changedWSnameSynched() throws JavaModelException, CoreException {
        this.target.startSynchronizing();
        ICompilationUnit ws1CU = this.testPrj1.getJavaProject().findType(this.ws1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(ws1CU, "@javax.jws.WebService(serviceName=\"WS1NewName\", endpointInterface=\"com.sap.test.modelsync1.Sei1\") public class WS1 {}");
        JobUtils.waitForJobs();
        WsSynchronizationTest.assertEquals((String)"WS1NewName", (String)this.ws1.getName());
        WsSynchronizationTest.assertSame((Object)this.sei1, (Object)this.ws1.getServiceEndpoint());
        WsSynchronizationTest.assertSame((Object)this.ws1, (Object)this.domUtil.findWsByImplName(this.wsPrj1, this.ws1.getImplementation()));
    }

    public void test_changedNameOfImplicitInterface() throws Exception {
        this.target.startSynchronizing();
        IPackageFragment modelSync3 = this.testPrj1.createPackage("com.sap.test.modelsync3");
        ICompilationUnit ws3CU = this.testPrj1.createType(modelSync3, "WS3.java", "@javax.jws.WebService(serviceName=\"WS3Name\", name=\"ImplicitInterfaceName\") public class WS3 {}").getCompilationUnit();
        JobUtils.waitForJobs();
        IWebService ws3 = this.domUtil.findWsByImplName(this.wsPrj1, ws3CU.findPrimaryType().getFullyQualifiedName());
        IServiceEndpointInterface implSei = ws3.getServiceEndpoint();
        WsSynchronizationTest.assertTrue((boolean)implSei.isImplicit());
        this.testUtil.setContents(ws3CU, "@javax.jws.WebService(serviceName=\"WS3Name\", name=\"ImplicitInterfaceNewName\") public class WS3 {}");
        JobUtils.waitForJobs();
        WsSynchronizationTest.assertSame((Object)implSei, (Object)ws3.getServiceEndpoint());
        WsSynchronizationTest.assertTrue((boolean)implSei.isImplicit());
        WsSynchronizationTest.assertEquals((String)"ImplicitInterfaceNewName", (String)implSei.getName());
    }

    public void test_changedTargetNamespaceSynched() throws Exception {
        this.target.startSynchronizing();
        WsSynchronizationTest.assertEquals((String)JaxWsUtils.composeJaxWsTargetNamespaceByPackage((String)"com.sap.test.modelsync1"), (String)this.ws1.getTargetNamespace());
        ICompilationUnit wsCU = this.testPrj1.getJavaProject().findType(this.ws1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(wsCU, "@javax.jws.WebService(serviceName=\"WS1Name\", targetNamespace=\"http://com.sap./test\") public class WS1 {}");
        JobUtils.waitForJobs();
        WsSynchronizationTest.assertEquals((String)"targetNamespace not synchronized", (String)"http://com.sap./test", (String)this.ws1.getTargetNamespace());
    }

    public void test_changedPortNameSynched() throws Exception {
        this.target.startSynchronizing();
        ICompilationUnit wsCU = this.testPrj1.getJavaProject().findType(this.ws1.getImplementation()).getCompilationUnit();
        WsSynchronizationTest.assertEquals((String)"WS1Port", (String)this.ws1.getPortName());
        this.testUtil.setContents(wsCU, "@javax.jws.WebService(portName=\"ChangedPortName\") public class WS1 {}");
        JobUtils.waitForJobs();
        WsSynchronizationTest.assertEquals((String)"portName not synchronized", (String)"ChangedPortName", (String)this.ws1.getPortName());
    }

    public void test_changedWsdlLocationSynched() throws Exception {
        this.target.startSynchronizing();
        ICompilationUnit wsCU = this.testPrj1.getJavaProject().findType(this.ws1.getImplementation()).getCompilationUnit();
        WsSynchronizationTest.assertEquals(null, (String)this.ws1.getWsdlLocation());
        this.testUtil.setContents(wsCU, "@javax.jws.WebService(wsdlLocation=\"C:/changed/wsdl/location\") public class WS1 {}");
        JobUtils.waitForJobs();
        WsSynchronizationTest.assertEquals((String)"wsdlLocation not synchronized", (String)"C:/changed/wsdl/location", (String)this.ws1.getWsdlLocation());
    }

    public void test_changedImplicitSeiSoapBinding() throws Exception {
        this.target.startSynchronizing();
        ICompilationUnit wsCU = this.testPrj1.getJavaProject().findType(this.ws1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(wsCU, "@javax.jws.WebService() public class WS1 {}");
        JobUtils.waitForJobs();
        IServiceEndpointInterface sei = this.ws1.getServiceEndpoint();
        WsSynchronizationTest.assertEquals((Object)SOAPBindingStyle.DOCUMENT, (Object)sei.getSoapBindingStyle());
        WsSynchronizationTest.assertEquals((Object)SOAPBindingUse.LITERAL, (Object)sei.getSoapBindingUse());
        WsSynchronizationTest.assertEquals((Object)SOAPBindingParameterStyle.WRAPPED, (Object)sei.getSoapBindingParameterStyle());
        this.testUtil.setContents(wsCU, "@javax.jws.soap.SOAPBinding(style=Style.RPC, use=Use.ENCODED, parameterStyle=ParameterStyle.BARE)\n@javax.jws.WebService() public class WS1 {}");
        JobUtils.waitForJobs();
        WsSynchronizationTest.assertEquals((Object)SOAPBindingStyle.RPC, (Object)sei.getSoapBindingStyle());
        WsSynchronizationTest.assertEquals((Object)SOAPBindingUse.ENCODED, (Object)sei.getSoapBindingUse());
        WsSynchronizationTest.assertEquals((Object)SOAPBindingParameterStyle.BARE, (Object)sei.getSoapBindingParameterStyle());
    }

    public void test_ContructorIsNotIncludedInWebMethods() throws CoreException {
        this.target.startSynchronizing();
        ICompilationUnit wsCU = this.testPrj1.getJavaProject().findType(this.ws1.getImplementation()).getCompilationUnit();
        this.testUtil.setContents(wsCU, "@javax.jws.WebService()public class WS1{public WS1(){};public WS1(String s){}public void myMethod(){}}");
        JobUtils.waitForJobs();
        IServiceEndpointInterface sei = this.ws1.getServiceEndpoint();
        EList methods = sei.getWebMethods();
        WsSynchronizationTest.assertEquals((String)"One method expected in the SEI", (int)1, (int)methods.size());
        WsSynchronizationTest.assertEquals((String)"Unpexpected method name in SEI", (String)"myMethod", (String)((IWebMethod)methods.iterator().next()).getName());
    }
}

