/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadAttributeConverterTestCase
extends BaseReadTestCase {
    public ReadAttributeConverterTestCase(String name) {
        super(name);
    }

    public void testSingleAttribute() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attribute1 = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeConverterTestCase.assertNotNull((Object)attribute1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private AttributeType getAttribute1(FacesConfigType facesConfig) {
        ConverterType converter1 = (ConverterType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getConverter(), "converter1");
        ReadAttributeConverterTestCase.assertNotNull((Object)converter1);
        return (AttributeType)FacesConfigModelUtil.findEObjectElementById((List)converter1.getAttribute(), "converter1Attribute");
    }

    public void testDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeConverterTestCase.assertNotNull((Object)attributeType);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)attributeType.getDescription(), "converter1_attribute_description");
            ReadAttributeConverterTestCase.assertEquals((String)"converter-attribute-description", (String)descType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeConverterTestCase.assertNotNull((Object)attributeType);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)attributeType.getDisplayName(), "converter1_attribute_display-name");
            ReadAttributeConverterTestCase.assertEquals((String)"converter-attribute-display-name", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attrType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeConverterTestCase.assertNotNull((Object)attrType);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)attrType.getIcon(), "converter1_attribute_icon");
            ReadAttributeConverterTestCase.assertNotNull((Object)iconType);
            ReadAttributeConverterTestCase.assertEquals((String)"converter1-attribute-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadAttributeConverterTestCase.assertEquals((String)"converter1-attribute-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttributeNameAndClass() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attribute1 = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeConverterTestCase.assertNotNull((Object)attribute1);
            ReadAttributeConverterTestCase.assertEquals((String)"converter1-attribute-name", (String)attribute1.getAttributeName().getTextContent());
            ReadAttributeConverterTestCase.assertEquals((String)"converter1-attribute-class", (String)attribute1.getAttributeClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSuggestedValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeConverterTestCase.assertEquals((String)"converter1-attribute-suggested-value", (String)attributeType.getSuggestedValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDefaultValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadAttributeConverterTestCase.assertNotNull((Object)edit.getFacesConfig());
            AttributeType attributeType = this.getAttribute1(edit.getFacesConfig());
            ReadAttributeConverterTestCase.assertEquals((String)"converter1-default-value", (String)attributeType.getDefaultValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testAttributeExtension() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            if (edit.getFacesConfig() != null) {
                EList comp = edit.getFacesConfig().getComponent();
                ReadAttributeConverterTestCase.assertTrue((!comp.isEmpty() ? 1 : 0) != 0);
                int i = 0;
                while (i < comp.size()) {
                    ComponentType compType = (ComponentType)comp.get(i);
                    ReadAttributeConverterTestCase.assertTrue((!compType.getAttribute().isEmpty() ? 1 : 0) != 0);
                    EList attr = compType.getAttribute();
                    int k = 0;
                    while (k < attr.size()) {
                        AttributeType attrType = (AttributeType)attr.get(k);
                        EList ext = attrType.getAttributeExtension();
                        ReadAttributeConverterTestCase.assertTrue((ext.size() != 0 ? 1 : 0) != 0);
                        ++k;
                    }
                    ++i;
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

