/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.basic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11CategoryAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11TypesCategoryAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddBindingCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddImportCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddInterfaceCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddSchemaCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddServiceCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11EditNamespacesCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddBindingAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddInterfaceAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddServiceAction;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMNamespaceInfoManager;
import org.w3c.dom.Element;

public class W11Description
extends WSDLBaseAdapter
implements IDescription {
    protected List categories = new ArrayList();

    protected W11CategoryAdapter getCategory(int categoryId) {
        return this.getCategory(categoryId, this.getCategoryAdapters());
    }

    protected W11CategoryAdapter getCategory(int categoryId, List list) {
        for (W11CategoryAdapter adapter : list) {
            if (adapter.getGroupType() != categoryId) continue;
            return adapter;
        }
        return null;
    }

    protected List getCategoryAdapters() {
        if (this.categories.size() == 0) {
            this.categories = this.createCategoryAdapters();
        } else {
            W11CategoryAdapter category = this.getCategory(1, this.categories);
            category.setChildren(this.getImports());
            category = this.getCategory(2, this.categories);
            this.addListenerToTypes(category);
            category = this.getCategory(3, this.categories);
            category.setChildren(this.getServices());
            category = this.getCategory(5, this.categories);
            category.setChildren(this.getBindings());
            category = this.getCategory(6, this.categories);
            category.setChildren(this.getInterfaces());
            category = this.getCategory(7, this.categories);
            category.setChildren(this.getMessages());
        }
        return this.categories;
    }

    protected List createCategoryAdapters() {
        ArrayList<W11CategoryAdapter> categories = new ArrayList<W11CategoryAdapter>();
        List importList = this.getImports();
        List serviceList = this.getServices();
        List bindingList = this.getBindings();
        List interfaceList = this.getInterfaces();
        List messageList = this.getMessages();
        String categoryTitle = W11CategoryAdapter.IMPORTS_HEADER_TEXT;
        Image categoryImage = WSDLEditorPlugin.getInstance().getImage("icons/importheader_obj.gif");
        W11CategoryAdapter category = new W11CategoryAdapter(this, categoryTitle, categoryImage, importList, 1);
        this.registerListener(category);
        categories.add(category);
        categoryTitle = W11CategoryAdapter.TYPES_HEADER_TEXT;
        categoryImage = WSDLEditorPlugin.getInstance().getImage("icons/types_obj.gif");
        category = new W11TypesCategoryAdapter(this, categoryTitle, categoryImage, 2);
        this.addListenerToTypes(category);
        this.registerListener(category);
        categories.add(category);
        categoryTitle = W11CategoryAdapter.SERVICE_HEADER_TEXT;
        categoryImage = WSDLEditorPlugin.getInstance().getImage("icons/serviceheader_obj.gif");
        category = new W11CategoryAdapter(this, categoryTitle, categoryImage, serviceList, 3);
        this.registerListener(category);
        categories.add(category);
        categoryTitle = W11CategoryAdapter.BINDING_HEADER_TEXT;
        categoryImage = WSDLEditorPlugin.getInstance().getImage("icons/bindingheader_obj.gif");
        category = new W11CategoryAdapter(this, categoryTitle, categoryImage, bindingList, 5);
        this.registerListener(category);
        categories.add(category);
        categoryTitle = W11CategoryAdapter.INTERFACE_HEADER_TEXT;
        categoryImage = WSDLEditorPlugin.getInstance().getImage("icons/porttypeheader_obj.gif");
        category = new W11CategoryAdapter(this, categoryTitle, categoryImage, interfaceList, 6);
        this.registerListener(category);
        categories.add(category);
        categoryTitle = W11CategoryAdapter.MESSAGE_HEADER_TEXT;
        categoryImage = WSDLEditorPlugin.getInstance().getImage("icons/messageheader_obj.gif");
        category = new W11CategoryAdapter(this, categoryTitle, categoryImage, messageList, 7);
        this.registerListener(category);
        categories.add(category);
        return categories;
    }

    private void addListenerToTypes(W11CategoryAdapter category) {
        Definition def = (Definition)this.getTarget();
        Types types = def.getETypes();
        if (types != null && !types.eAdapters().contains((Object)category)) {
            types.eAdapters().add((Object)category);
        }
    }

    @Override
    public String getTargetNamespace() {
        return ((Definition)this.target).getTargetNamespace();
    }

    @Override
    public String getTargetNamespacePrefix() {
        String tns = this.getTargetNamespace();
        return ((Definition)this.target).getPrefix(tns);
    }

    @Override
    public List getServices() {
        ArrayList adapterList = new ArrayList();
        ComponentReferenceUtil util = new ComponentReferenceUtil((Definition)this.getTarget());
        List services = util.getServices();
        this.populateAdapterList(services, adapterList);
        return adapterList;
    }

    @Override
    public List getBindings() {
        ArrayList adapterList = new ArrayList();
        ComponentReferenceUtil util = new ComponentReferenceUtil((Definition)this.getTarget());
        List bindings = util.getBindings();
        this.populateAdapterList(bindings, adapterList);
        return adapterList;
    }

    @Override
    public List getInterfaces() {
        ArrayList adapterList = new ArrayList();
        ComponentReferenceUtil util = new ComponentReferenceUtil((Definition)this.getTarget());
        List portTypes = util.getPortTypes();
        this.populateAdapterList(portTypes, adapterList);
        return adapterList;
    }

    @Override
    public List getImports() {
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList((List)((Definition)this.target).getEImports(), adapterList);
        return adapterList;
    }

    @Override
    public List getTypes() {
        ArrayList adapterList = new ArrayList();
        Types types = ((Definition)this.target).getETypes();
        if (types != null) {
            this.populateAdapterList(types.getSchemas(), adapterList);
        }
        return adapterList;
    }

    @Override
    public List getMessages() {
        ArrayList adapterList = new ArrayList();
        ComponentReferenceUtil util = new ComponentReferenceUtil((Definition)this.getTarget());
        List messages = util.getMessages();
        this.populateAdapterList(messages, adapterList);
        return adapterList;
    }

    @Override
    public String getName() {
        String name = "";
        Definition definition = (Definition)this.target;
        if (definition.getQName() != null) {
            name = definition.getQName().getLocalPart();
        }
        return name;
    }

    @Override
    public String[] getActions(Object object) {
        String[] actionIDs = new String[]{ASDAddServiceAction.ID, ASDAddBindingAction.ID, ASDAddInterfaceAction.ID};
        return actionIDs;
    }

    @Override
    public Command getAddImportCommand() {
        return new W11AddImportCommand((Definition)this.target);
    }

    @Override
    public Command getAddSchemaCommand() {
        return new W11AddSchemaCommand((Definition)this.target);
    }

    @Override
    public Command getAddServiceCommand() {
        return new W11AddServiceCommand((Definition)this.target);
    }

    @Override
    public Command getAddBindingCommand() {
        return new W11AddBindingCommand((Definition)this.target);
    }

    @Override
    public Command getAddInterfaceCommand() {
        return new W11AddInterfaceCommand((Definition)this.target);
    }

    @Override
    public Command getAddMessageCommand() {
        return new W11AddMessageCommand((Definition)this.target);
    }

    public Command getEditNamespacesCommand() {
        return new W11EditNamespacesCommand((Definition)this.target);
    }

    public List getNamespacesInfo() {
        DOMNamespaceInfoManager namespaceInfoManager = new DOMNamespaceInfoManager();
        Element element = WSDLEditorUtil.getInstance().getElementForObject((Definition)this.target);
        return namespaceInfoManager.getNamespaceInfoList(element);
    }

    @Override
    public Image getImage() {
        return null;
    }

    @Override
    public String getText() {
        return "definition";
    }

    @Override
    public ITreeElement[] getChildren() {
        List children = this.getCategoryAdapters();
        return children.toArray(new ITreeElement[0]);
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @Override
    public ITreeElement getParent() {
        return null;
    }

    @Override
    public void notifyChanged(Notification msg) {
        class CategoryNotification
        extends NotificationImpl {
            protected Object category;
            private final /* synthetic */ Notification val$msg;

            public CategoryNotification(Object category, Notification notification) {
                this.val$msg = notification;
                super(notification.getEventType(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
                this.category = category;
            }

            public Object getNotifier() {
                return this.category;
            }

            public Object getFeature() {
                return this.val$msg.getFeature();
            }
        }
        if (msg.getFeature() == WSDLPackage.eINSTANCE.getDefinition_EImports()) {
            W11CategoryAdapter adapter = this.getCategory(1);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            adapter.setChildren(this.getImports());
            this.notifyListeners((Object)new CategoryNotification(adapter, msg), adapter.getText());
        } else if (msg.getFeature() == WSDLPackage.eINSTANCE.getDefinition_ETypes()) {
            W11CategoryAdapter adapter = this.getCategory(2);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            adapter.setChildren(this.getImports());
            this.notifyListeners((Object)new CategoryNotification(adapter, msg), adapter.getText());
        } else if (msg.getFeature() == WSDLPackage.eINSTANCE.getDefinition_EServices()) {
            W11CategoryAdapter adapter = this.getCategory(3);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            adapter.setChildren(this.getServices());
            this.notifyListeners((Object)new CategoryNotification(adapter, msg), adapter.getText());
        } else if (msg.getFeature() == WSDLPackage.eINSTANCE.getDefinition_EBindings()) {
            W11CategoryAdapter adapter = this.getCategory(5);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            adapter.setChildren(this.getBindings());
            this.notifyListeners((Object)new CategoryNotification(adapter, msg), adapter.getText());
        } else if (msg.getFeature() == WSDLPackage.eINSTANCE.getDefinition_EPortTypes()) {
            W11CategoryAdapter adapter = this.getCategory(6);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            adapter.setChildren(this.getInterfaces());
            this.notifyListeners((Object)new CategoryNotification(adapter, msg), adapter.getText());
        } else if (msg.getFeature() == WSDLPackage.eINSTANCE.getDefinition_EMessages()) {
            W11CategoryAdapter adapter = this.getCategory(7);
            Assert.isTrue((adapter != null ? 1 : 0) != 0);
            adapter.setChildren(this.getMessages());
            this.notifyListeners((Object)new CategoryNotification(adapter, msg), adapter.getText());
        } else {
            this.notifyListeners(null, null);
        }
    }
}

