/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.IPredefinedSourceWrapProvider;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.util.MementoFormat;

public class LaunchParams {
    public static final String CHROMIUM_DEBUG_HOST = "debug_host";
    public static final String CHROMIUM_DEBUG_PORT = "debug_port";
    public static final String ADD_NETWORK_CONSOLE = "add_network_console";
    public static final String BREAKPOINT_SYNC_DIRECTION = "breakpoint_startup_sync_direction";
    public static final String SOURCE_LOOKUP_MODE = "source_lookup_mode";
    public static final String WIP_BACKEND_ID = "wip_backend_id";
    public static final String ATTR_APP_PROJECT = "attr_app_project";
    public static final String ATTR_APP_PROJECT_RELATIVE_PATH = "attr_app_project_relative_path";
    public static final String ATTR_REMOTE_HOME_DIR = "attr_remote_home dir";
    public static final String ATTR_BASE_URL = "attr_base_url";
    public static final List<? extends BreakpointOption> BREAKPOINT_OPTIONS = Arrays.asList(new BreakpointOption(Messages.LaunchParams_MERGE_OPTION, BreakpointSynchronizer.Direction.MERGE), new BreakpointOption(Messages.LaunchParams_RESET_REMOTE_OPTION, BreakpointSynchronizer.Direction.RESET_REMOTE), new BreakpointOption(Messages.LaunchParams_NONE_OPTION, null));

    public static BreakpointSynchronizer.Direction readBreakpointSyncDirection(ILaunchConfiguration launchConfiguration) throws CoreException {
        String breakpointOptionString = launchConfiguration.getAttribute(BREAKPOINT_SYNC_DIRECTION, null);
        int optionIndex = LaunchParams.findBreakpointOption(breakpointOptionString);
        return BREAKPOINT_OPTIONS.get(optionIndex).getDirection();
    }

    public static int findBreakpointOption(String optionText) {
        int res = LaunchParams.findBreakpointOptionRaw(optionText);
        if (res != -1) {
            return res;
        }
        res = LaunchParams.findBreakpointOptionRaw(null);
        if (res != -1) {
            return res;
        }
        throw new RuntimeException("Failed to find breakpoint option");
    }

    private static int findBreakpointOptionRaw(String optionText) {
        BreakpointSynchronizer.Direction direction;
        if (optionText == null || optionText.length() == 0) {
            direction = null;
        } else {
            try {
                direction = BreakpointSynchronizer.Direction.valueOf(optionText);
            }
            catch (IllegalArgumentException e) {
                ChromiumDebugPlugin.log(new Exception("Failed to parse breakpoint synchronization option", e));
                return -1;
            }
        }
        int i = 0;
        while (i < BREAKPOINT_OPTIONS.size()) {
            if (BREAKPOINT_OPTIONS.get(i).getDirection() == direction) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static class BreakpointOption {
        private final String label;
        private final BreakpointSynchronizer.Direction direction;

        BreakpointOption(String label, BreakpointSynchronizer.Direction direction) {
            this.label = label;
            this.direction = direction;
        }

        public BreakpointSynchronizer.Direction getDirection() {
            return this.direction;
        }

        public String getDirectionStringValue() {
            if (this.direction == null) {
                return "";
            }
            return this.direction.toString();
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum LookupMode {
        EXACT_MATCH{

            @Override
            public <R> R accept(Visitor<R> visitor) {
                return visitor.visitExactMatch();
            }
        }
        ,
        AUTO_DETECT{

            @Override
            public <R> R accept(Visitor<R> visitor) {
                return visitor.visitAutoDetect();
            }
        };

        public static final LookupMode DEFAULT_VALUE;
        public static final ValueConverter<String, LookupMode> STRING_CONVERTER;

        static {
            DEFAULT_VALUE = EXACT_MATCH;
            STRING_CONVERTER = new ValueConverter<String, LookupMode>(){

                @Override
                public String encode(LookupMode logical) {
                    return logical.toString();
                }

                @Override
                public LookupMode decode(String persistent) throws CoreException {
                    try {
                        return LookupMode.valueOf(persistent);
                    }
                    catch (IllegalArgumentException e) {
                        Status status = new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", "Failed to parse lookup mode value", (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                }
            };
        }

        public abstract <R> R accept(Visitor<R> var1);

        public static interface Visitor<R> {
            public R visitExactMatch();

            public R visitAutoDetect();
        }
    }

    public static class PredefinedSourceWrapperIds {
        public static String CONFIG_PROPERTY = "predefined_source_wrapperd_ids";
        public static final ValueConverter<String, List<String>> CONVERTER = new ValueConverter<String, List<String>>(){

            @Override
            public String encode(List<String> logical) {
                StringBuilder builder = new StringBuilder();
                ArrayList<String> list = new ArrayList<String>(logical);
                Collections.sort(list);
                for (String id : list) {
                    MementoFormat.encodeComponent(id, builder);
                }
                return builder.toString();
            }

            @Override
            public List<String> decode(String persistent) throws CoreException {
                ArrayList<String> result = new ArrayList<String>();
                MementoFormat.Parser parser = new MementoFormat.Parser(persistent);
                while (parser.hasMore()) {
                    try {
                        result.add(parser.nextComponent());
                    }
                    catch (MementoFormat.ParserException e) {
                        throw new RuntimeException("Failed to read config value '" + persistent + "'", e);
                    }
                }
                return result;
            }
        };

        public static List<IPredefinedSourceWrapProvider.Entry> resolveEntries(ILaunchConfiguration config) throws CoreException {
            String attributeValue = config.getAttribute(CONFIG_PROPERTY, "");
            List<String> predefinedWrapperIds = CONVERTER.decode(attributeValue);
            Map<String, IPredefinedSourceWrapProvider.Entry> entries = IPredefinedSourceWrapProvider.Access.getEntries();
            ArrayList<IPredefinedSourceWrapProvider.Entry> result = new ArrayList<IPredefinedSourceWrapProvider.Entry>(predefinedWrapperIds.size());
            for (String id : predefinedWrapperIds) {
                IPredefinedSourceWrapProvider.Entry entry = entries.get(id);
                if (entry == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", "Failed to find source wrapper by id '" + id + "'"));
                }
                result.add(entry);
            }
            return result;
        }
    }

    public static abstract class ValueConverter<P, L> {
        public abstract P encode(L var1);

        public abstract L decode(P var1) throws CoreException;

        public static <T> ValueConverter<T, T> getTrivial() {
            return Trivial.INSTANCE;
        }

        private static class Trivial<T>
        extends ValueConverter<T, T> {
            private static final Trivial<?> INSTANCE = new Trivial();

            private Trivial() {
            }

            @Override
            public T encode(T logical) {
                return logical;
            }

            @Override
            public T decode(T persistent) {
                return persistent;
            }
        }
    }
}

