/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmNamedQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlCompletionProposalComputer;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlSseCompletionProposal;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.persistence.jpa.jpql.tools.utility.XmlEscapeCharacterConverter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.contentassist.ICompletionProposalComputer;

public final class JpaJpqlSseCompletionProposalComputer
extends JpqlCompletionProposalComputer<ICompletionProposal>
implements ICompletionProposalComputer {
    private boolean cDATASection;

    @Override
    ICompletionProposal buildProposal(String proposal, String displayString, String additionalInfo, Image image, int cursorOffset) {
        return new JpqlSseCompletionProposal(this.contentAssistProposals, proposal, displayString, additionalInfo, image, this.namedQuery, this.jpqlQuery, this.actualQuery, this.tokenStart, this.tokenEnd, this.position, this.actualPosition, cursorOffset, this.cDATASection);
    }

    public List<ICompletionProposal> computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        monitor.beginTask(null, 100);
        try {
            int offset = context.getInvocationOffset();
            if (offset == -1) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer buffer = manager.getTextFileBuffer(context.getDocument());
            if (buffer == null) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile(buffer.getLocation());
            JpaFile jpaFile = (JpaFile)file.getAdapter(JpaFile.class);
            if (jpaFile == null) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            monitor.worked(80);
            this.checkCanceled(monitor);
            int[] position = new int[1];
            OrmNamedQuery namedQuery = this.namedQuery(jpaFile, offset, position);
            if (namedQuery == null) {
                List<ICompletionProposal> list = Collections.emptyList();
                return list;
            }
            Object[] info = this.jpqlQuery(namedQuery, context.getDocument());
            String jpqlQuery = (String)info[0];
            this.cDATASection = (Boolean)info[1];
            int tokenStart = offset - position[0];
            int tokenEnd = tokenStart + jpqlQuery.length();
            List<ICompletionProposal> list = this.buildProposals((NamedQuery)namedQuery, jpqlQuery, tokenStart, tokenEnd, position[0], this.getResourceManager());
            return list;
        }
        catch (Exception ex) {
            JptJpaUiPlugin.instance().logError(ex, JptJpaUiMessages.JPA_JPQL_SSE_COMPLETION_PROPOSAL_COMPUTER_ERROR);
        }
        finally {
            monitor.done();
        }
        return Collections.emptyList();
    }

    public List<IContextInformation> computeContextInformation(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    private OrmNamedQuery findNamedQuery(JpaStructureNode structureNode, int offset, int[] position) {
        if (structureNode instanceof EntityMappings) {
            EntityMappings entityMappings = (EntityMappings)structureNode;
            OrmNamedQuery query = this.findNamedQuery(entityMappings.getQueryContainer(), offset, position);
            if (query != null) {
                return query;
            }
            for (PersistentType persistentType : entityMappings.getPersistentTypes()) {
                TypeMapping typeMapping = persistentType.getMapping();
                if (!(typeMapping instanceof OrmEntity) || (query = this.findNamedQuery(((OrmEntity)typeMapping).getQueryContainer(), offset, position)) == null) continue;
                return query;
            }
        }
        return null;
    }

    private OrmNamedQuery findNamedQuery(OrmQueryContainer container, int offset, int[] position) {
        for (OrmNamedQuery namedQuery : container.getNamedQueries()) {
            for (TextRange textRange : namedQuery.getQueryTextRanges()) {
                if (!textRange.touches(offset)) continue;
                position[0] = offset - textRange.getOffset();
                return namedQuery;
            }
        }
        return null;
    }

    private Object[] jpqlQuery(OrmNamedQuery namedQuery, IDocument document) {
        try {
            TextRange range = (TextRange)namedQuery.getQueryTextRanges().get(0);
            return new Object[]{document.get(range.getOffset(), range.getLength()), namedQuery.getXmlQuery().isQueryInsideCDATASection()};
        }
        catch (BadLocationException badLocationException) {
            return new Object[]{"", Boolean.FALSE};
        }
    }

    @Override
    String modifyJpqlQuery(String jpqlQuery, int[] position) {
        if (!this.cDATASection) {
            jpqlQuery = XmlEscapeCharacterConverter.unescape((String)jpqlQuery, (int[])position);
        }
        return jpqlQuery;
    }

    private OrmNamedQuery namedQuery(JpaFile jpaFile, int offset, int[] position) {
        for (JpaStructureNode node : jpaFile.getRootStructureNodes()) {
            OrmNamedQuery namedQuery = this.findNamedQuery(node, offset, position);
            if (namedQuery == null) continue;
            return namedQuery;
        }
        return null;
    }
}

