/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.validation.IMutableValidator;
import org.eclipse.wst.validation.MutableProjectSettings;
import org.eclipse.wst.validation.MutableWorkspaceSettings;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResults;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;
import org.osgi.framework.Bundle;

public class TestSuite8
extends TestCase {
    private TestEnvironment _env;
    private IProject _project;

    public static Test suite() {
        return new TestSuite(TestSuite8.class);
    }

    public TestSuite8(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        this._env.turnoffAutoBuild();
        this._project = this._env.createProject("TestSuite8");
        IPath first = this._env.addFolder(this._project.getFullPath(), "some-folder");
        this._env.addFile(first, "first.t6a", "error - one error line");
    }

    protected void tearDown() throws Exception {
        this._project.delete(true, null);
        this._env.dispose();
        super.tearDown();
    }

    public void testPrefs() throws CoreException, UnsupportedEncodingException, InterruptedException, InvocationTargetException {
        Tracing.log((String)"TestSuite8-01: testClean starting");
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.runtime");
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.append(".settings/org.eclipse.wst.validation.prefs");
        File file = path.toFile();
        long lastModified = file.lastModified();
        ValidationFramework vf = ValidationFramework.getDefault();
        MutableWorkspaceSettings mws = vf.getWorkspaceSettings();
        IMutableValidator[] validators = mws.getValidators();
        TestSuite8.assertTrue((String)"There must be sime validators defined", (validators.length > 0 ? 1 : 0) != 0);
        IMutableValidator[] iMutableValidatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            IMutableValidator val = iMutableValidatorArray[n2];
            val.setBuildValidation(false);
            val.setManualValidation(true);
            ++n2;
        }
        vf.applyChanges(mws, false);
        TestSuite8.assertEquals((String)"The global preference file should not have changed", (long)lastModified, (long)file.lastModified());
        NullProgressMonitor monitor = new NullProgressMonitor();
        ValidationResults vr = vf.validate(new IProject[]{this._project}, true, false, (IProgressMonitor)monitor);
        TestSuite8.assertEquals((String)"We expect exactly one error", (int)1, (int)vr.getSeverityError());
        mws = vf.getWorkspaceSettings();
        IMutableValidator[] iMutableValidatorArray2 = validators = mws.getValidators();
        int n3 = validators.length;
        int n4 = 0;
        while (n4 < n3) {
            IMutableValidator val = iMutableValidatorArray2[n4];
            TestSuite8.assertEquals((String)("We expected " + val.getName() + " to have build turned off"), (boolean)false, (boolean)val.isBuildValidation());
            TestSuite8.assertEquals((String)("We expected " + val.getName() + " to have manual turned on"), (boolean)true, (boolean)val.isManualValidation());
            val.setBuildValidation(true);
            val.setManualValidation(false);
            ++n4;
        }
        vf.applyChanges(mws, true);
        TestSuite8.assertTrue((String)"The global preference file should have changed", (lastModified < file.lastModified() ? 1 : 0) != 0);
        vr = vf.validate(new IProject[]{this._project}, true, false, (IProgressMonitor)monitor);
        TestSuite8.assertEquals((String)"The validator is off, there should be no errors", (int)0, (int)vr.getSeverityError());
        this.projectTest();
        Tracing.log((String)"TestSuite8-02:testClean finished");
    }

    private void projectTest() throws CoreException {
        long lastModified = this.lastModifiedForProject();
        ValidationFramework vf = ValidationFramework.getDefault();
        MutableProjectSettings mps = vf.getProjectSettings(this._project);
        TestSuite8.assertFalse((String)"By default, projects can not override workspace settings", (boolean)mps.getOverride());
        mps.setOverride(true);
        vf.applyChanges(mps, false);
        IMutableValidator[] validators = mps.getValidators();
        TestSuite8.assertTrue((String)"There must be sime validators defined", (validators.length > 0 ? 1 : 0) != 0);
        IMutableValidator[] iMutableValidatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            IMutableValidator val = iMutableValidatorArray[n2];
            val.setBuildValidation(false);
            val.setManualValidation(true);
            ++n2;
        }
        vf.applyChanges(mps, false);
        TestSuite8.assertEquals((String)"The project preference file should not have changed", (long)lastModified, (long)this.lastModifiedForProject());
        NullProgressMonitor monitor = new NullProgressMonitor();
        ValidationResults vr = vf.validate(new IProject[]{this._project}, true, false, (IProgressMonitor)monitor);
        TestSuite8.assertEquals((String)"We expect exactly one error", (int)1, (int)vr.getSeverityError());
        mps = vf.getProjectSettings(this._project);
        IMutableValidator[] iMutableValidatorArray2 = validators = mps.getValidators();
        int n3 = validators.length;
        int n4 = 0;
        while (n4 < n3) {
            IMutableValidator val = iMutableValidatorArray2[n4];
            TestSuite8.assertEquals((String)("We expected " + val.getName() + " to have build turned off"), (boolean)false, (boolean)val.isBuildValidation());
            TestSuite8.assertEquals((String)("We expected " + val.getName() + " to have manual turned on"), (boolean)true, (boolean)val.isManualValidation());
            val.setBuildValidation(true);
            val.setManualValidation(false);
            ++n4;
        }
        vf.applyChanges(mps, true);
        TestSuite8.assertTrue((String)"The project preference file should have changed", (lastModified < this.lastModifiedForProject() ? 1 : 0) != 0);
        vr = vf.validate(new IProject[]{this._project}, true, false, (IProgressMonitor)monitor);
        TestSuite8.assertEquals((String)"The validator is off, there should be no errors", (int)0, (int)vr.getSeverityError());
    }

    private long lastModifiedForProject() {
        long lastModified = 0L;
        IResource prefs = this._project.findMember(".settings/org.eclipse.wst.validation.prefs");
        if (prefs != null) {
            File pf = prefs.getLocation().toFile();
            lastModified = pf.lastModified();
        }
        return lastModified;
    }
}

