/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.utils;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jst.ws.annotations.core.AnnotationDefinition;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFPackage;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.TextEdit;
import org.osgi.framework.Version;

public final class CXFModelUtils {
    private static final Version v_0_0_0 = new Version("0.0.0");
    private static final Version v_2_1 = new Version("2.1");
    private static final Version v_2_0_7 = new Version("2.0.7");
    private static final Version v_2_1_1 = new Version("2.1.1");
    public static final String WEB_SERVICE = "WebService";
    public static final String WEB_METHOD = "WebMethod";
    public static final String WEB_PARAM = "WebParam";
    public static final String REQUEST_WRAPPER = "RequestWrapper";
    public static final String RESPONSE_WRAPPER = "ResponseWrapper";
    public static final String WEB_RESULT = "WebResult";
    private static final String ENDPOINT_INTERFACE = "endpointInterface";
    private static Map<String, String> ANNOTATION_TYPENAME_MAP = new HashMap<String, String>();

    static {
        ANNOTATION_TYPENAME_MAP.put("ServiceMode", "javax.xml.ws.ServiceMode");
        ANNOTATION_TYPENAME_MAP.put("WebFault", "javax.xml.ws.WebFault");
        ANNOTATION_TYPENAME_MAP.put(REQUEST_WRAPPER, "javax.xml.ws.RequestWrapper");
        ANNOTATION_TYPENAME_MAP.put(RESPONSE_WRAPPER, "javax.xml.ws.ResponseWrapper");
        ANNOTATION_TYPENAME_MAP.put("WebServiceClient", "javax.xml.ws.WebServiceClient");
        ANNOTATION_TYPENAME_MAP.put("WebEndpoint", "javax.xml.ws.WebEndpoint");
        ANNOTATION_TYPENAME_MAP.put("WebServiceProvider", "javax.xml.ws.WebServiceProvider");
        ANNOTATION_TYPENAME_MAP.put("BindingType", "javax.xml.ws.BindingType");
        ANNOTATION_TYPENAME_MAP.put("WebServiceRef", "javax.xml.ws.WebServiceRef");
        ANNOTATION_TYPENAME_MAP.put("WebServiceRefs", "javax.xml.ws.WebServiceRefs");
        ANNOTATION_TYPENAME_MAP.put(WEB_SERVICE, "javax.jws.WebService");
        ANNOTATION_TYPENAME_MAP.put(WEB_METHOD, "javax.jws.WebMethod");
        ANNOTATION_TYPENAME_MAP.put("Oneway", "javax.jws.OneWay");
        ANNOTATION_TYPENAME_MAP.put(WEB_PARAM, "javax.jws.WebParam");
        ANNOTATION_TYPENAME_MAP.put(WEB_RESULT, "javax.jws.WebResult");
        ANNOTATION_TYPENAME_MAP.put("SOAPBinding", "javax.jws.SOAPBinding");
        ANNOTATION_TYPENAME_MAP.put("HandlerChain", "javax.jws.HandlerChain");
    }

    private CXFModelUtils() {
    }

    public static void getWebServiceAnnotationChange(IType type, Java2WSDataModel model, TextFileChange textFileChange) throws CoreException {
        ICompilationUnit source = type.getCompilationUnit();
        CompilationUnit compilationUnit = CXFModelUtils.getAST(source);
        AST ast = compilationUnit.getAST();
        org.eclipse.jdt.core.dom.Annotation webServiceAnnotation = CXFModelUtils.getAnnotation(type, WebService.class);
        if (webServiceAnnotation != null) {
            if (type.isClass() && model.isUseServiceEndpointInterface() && webServiceAnnotation.isNormalAnnotation()) {
                MemberValuePair endpointInterface = CXFModelUtils.getMemberValuePair((NormalAnnotation)webServiceAnnotation, ENDPOINT_INTERFACE);
                if (endpointInterface != null && endpointInterface.getValue() instanceof StringLiteral) {
                    StringLiteral stringLiteral = (StringLiteral)endpointInterface.getValue();
                    if (!stringLiteral.getLiteralValue().equals(model.getServiceEndpointInterfaceName())) {
                        StringLiteral newSEIValue = AnnotationsCore.createStringLiteral((AST)ast, (String)model.getServiceEndpointInterfaceName());
                        textFileChange.addEdit(AnnotationUtils.createUpdateMemberValuePairTextEdit((MemberValuePair)endpointInterface, (ASTNode)newSEIValue));
                    }
                } else {
                    MemberValuePair endpointInterfacePair = AnnotationsCore.createMemberValuePair((AST)ast, (String)ENDPOINT_INTERFACE, (Expression)AnnotationsCore.createStringLiteral((AST)ast, (String)model.getServiceEndpointInterfaceName()));
                    textFileChange.addEdit(AnnotationUtils.createAddMemberValuePairTextEdit((NormalAnnotation)((NormalAnnotation)webServiceAnnotation), (MemberValuePair)endpointInterfacePair));
                }
            }
        } else {
            List<MemberValuePair> memberValuePairs = new ArrayList();
            AnnotationDefinition annotationDefinition = AnnotationsManager.getAnnotationDefinitionForClass((String)WebService.class.getCanonicalName());
            IAnnotationAttributeInitializer annotationAttributeInitializer = annotationDefinition.getAnnotationAttributeInitializer();
            IType annotationType = annotationDefinition.getAnnotationType();
            if (annotationAttributeInitializer != null) {
                memberValuePairs = annotationAttributeInitializer.getMemberValuePairs((IJavaElement)type, ast, annotationType);
            }
            if (model.isUseServiceEndpointInterface() && type.isClass()) {
                MemberValuePair endpointInterfaceValuePair = AnnotationsCore.createStringMemberValuePair((AST)ast, (String)ENDPOINT_INTERFACE, (String)model.getServiceEndpointInterfaceName());
                memberValuePairs.add(1, endpointInterfaceValuePair);
            }
            NormalAnnotation annotation = AnnotationsCore.createNormalAnnotation((AST)ast, (String)WebService.class.getSimpleName(), memberValuePairs);
            textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)source.findPrimaryType(), (org.eclipse.jdt.core.dom.Annotation)annotation));
        }
    }

    private static org.eclipse.jdt.core.dom.Annotation getAnnotation(IType type, Class<? extends Annotation> annotation) {
        return AnnotationUtils.getAnnotation((IJavaElement)type, annotation);
    }

    private static MemberValuePair getMemberValuePair(NormalAnnotation annotation, String memberName) {
        List memberValuePairs = annotation.values();
        for (MemberValuePair memberValuePair : memberValuePairs) {
            if (!memberValuePair.getName().getIdentifier().equals(memberName)) continue;
            return memberValuePair;
        }
        return null;
    }

    public static void getWebMethodAnnotationChange(IType type, IMethod method, TextFileChange textFileChange) throws CoreException {
        ICompilationUnit source = type.getCompilationUnit();
        CompilationUnit compilationUnit = CXFModelUtils.getAST(source);
        AST ast = compilationUnit.getAST();
        org.eclipse.jdt.core.dom.Annotation annotation = CXFModelUtils.getAnnotation((IJavaElement)method, ast, WebMethod.class);
        textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (org.eclipse.jdt.core.dom.Annotation)annotation));
    }

    public static void getRequestWrapperAnnotationChange(IType type, IMethod method, TextFileChange textFileChange) throws CoreException {
        ICompilationUnit source = type.getCompilationUnit();
        CompilationUnit compilationUnit = CXFModelUtils.getAST(source);
        AST ast = compilationUnit.getAST();
        org.eclipse.jdt.core.dom.Annotation annotation = CXFModelUtils.getAnnotation((IJavaElement)method, ast, RequestWrapper.class);
        textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (org.eclipse.jdt.core.dom.Annotation)annotation));
    }

    public static void getResponseWrapperAnnotationChange(IType type, IMethod method, TextFileChange textFileChange) throws CoreException {
        ICompilationUnit source = type.getCompilationUnit();
        CompilationUnit compilationUnit = CXFModelUtils.getAST(source);
        AST ast = compilationUnit.getAST();
        org.eclipse.jdt.core.dom.Annotation annotation = CXFModelUtils.getAnnotation((IJavaElement)method, ast, ResponseWrapper.class);
        textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (org.eclipse.jdt.core.dom.Annotation)annotation));
    }

    public static void getWebResultAnnotationChange(IType type, IMethod method, TextFileChange textFileChange) throws CoreException {
        ICompilationUnit source = type.getCompilationUnit();
        CompilationUnit compilationUnit = CXFModelUtils.getAST(source);
        AST ast = compilationUnit.getAST();
        org.eclipse.jdt.core.dom.Annotation annotation = CXFModelUtils.getAnnotation((IJavaElement)method, ast, WebResult.class);
        textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)method, (org.eclipse.jdt.core.dom.Annotation)annotation));
    }

    public static void getWebParamAnnotationChange(IType type, IMethod method, ILocalVariable parameter, TextFileChange textFileChange) throws CoreException {
        ICompilationUnit source = type.getCompilationUnit();
        CompilationUnit compilationUnit = CXFModelUtils.getAST(source);
        AST ast = compilationUnit.getAST();
        org.eclipse.jdt.core.dom.Annotation annotation = CXFModelUtils.getAnnotation((IJavaElement)parameter, ast, WebParam.class);
        textFileChange.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)parameter, (org.eclipse.jdt.core.dom.Annotation)annotation));
    }

    private static org.eclipse.jdt.core.dom.Annotation getAnnotation(IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        List memberValuePairs = new ArrayList();
        AnnotationDefinition annotationDefinition = AnnotationsManager.getAnnotationDefinitionForClass((String)annotationClass.getCanonicalName());
        IAnnotationAttributeInitializer annotationAttributeInitializer = annotationDefinition.getAnnotationAttributeInitializer();
        IType annotationType = annotationDefinition.getAnnotationType();
        if (annotationAttributeInitializer != null) {
            memberValuePairs = annotationAttributeInitializer.getMemberValuePairs(javaElement, ast, annotationType);
        }
        return AnnotationsCore.createNormalAnnotation((AST)ast, (String)annotationClass.getSimpleName(), memberValuePairs);
    }

    public static void getImportsChange(ICompilationUnit compilationUnit, Java2WSDataModel model, TextFileChange textFileChange, boolean classOnly) {
        try {
            ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)compilationUnit, (boolean)true);
            importRewrite.addImport(ANNOTATION_TYPENAME_MAP.get(WEB_SERVICE));
            if (!classOnly) {
                Map<IMethod, Map<String, Boolean>> methodAnnotationMap = model.getMethodMap();
                Set<Map.Entry<IMethod, Map<String, Boolean>>> methodAnnotationSet = methodAnnotationMap.entrySet();
                for (Map.Entry<IMethod, Map<String, Boolean>> methodAnnotation : methodAnnotationSet) {
                    Map<String, Boolean> methodMap = methodAnnotation.getValue();
                    Set<Map.Entry<String, Boolean>> methodSet = methodMap.entrySet();
                    for (Map.Entry<String, Boolean> method : methodSet) {
                        if (!ANNOTATION_TYPENAME_MAP.containsKey(method.getKey()) || !method.getValue().booleanValue()) continue;
                        importRewrite.addImport(ANNOTATION_TYPENAME_MAP.get(method.getKey()));
                    }
                }
            }
            if (importRewrite.hasRecordedChanges()) {
                TextEdit importTextEdit = importRewrite.rewriteImports(null);
                textFileChange.addEdit(importTextEdit);
            }
        }
        catch (CoreException ce) {
            CXFCorePlugin.log(ce.getStatus());
        }
    }

    public static Map<IMethod, Map<String, Boolean>> getMethodMap(IType type, Java2WSDataModel model) {
        HashMap<IMethod, Map<String, Boolean>> methodMap = new HashMap<IMethod, Map<String, Boolean>>();
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (type.isInterface()) {
                    methodMap.put(method, CXFModelUtils.getAnnotationMap(model));
                } else if (type.isClass() && JDTUtils.isPublicMethod((IMethod)method)) {
                    methodMap.put(method, CXFModelUtils.getAnnotationMap(model));
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            CXFCorePlugin.log(jme.getStatus());
        }
        return methodMap;
    }

    public static Map<String, Boolean> getAnnotationMap(Java2WSDataModel model) {
        HashMap<String, Boolean> annotationdMap = new HashMap<String, Boolean>();
        annotationdMap.put(WEB_METHOD, model.isGenerateWebMethodAnnotation());
        annotationdMap.put(WEB_PARAM, model.isGenerateWebParamAnnotation());
        annotationdMap.put(REQUEST_WRAPPER, model.isGenerateRequestWrapperAnnotation());
        annotationdMap.put(RESPONSE_WRAPPER, model.isGenerateResponseWrapperAnnotation());
        annotationdMap.put(WEB_RESULT, model.isGenerateWebResultAnnotation());
        return annotationdMap;
    }

    public static boolean isAutoNameResolutionPermitted() {
        Version currentVersion = CXFCorePlugin.getDefault().getCurrentRuntimeVersion();
        if (currentVersion.compareTo(v_0_0_0) == 0) {
            return true;
        }
        if (currentVersion.compareTo(v_2_1_1) >= 0) {
            return true;
        }
        return currentVersion.compareTo(v_2_0_7) >= 0 && currentVersion.compareTo(v_2_1) < 0;
    }

    public static boolean getDefaultBooleanValue(int classifierID, int featureID) {
        Object defaultValue = null;
        if (classifierID == 0) {
            switch (featureID) {
                case 10: {
                    defaultValue = CXFPackage.eINSTANCE.getCXFContext_ExportCXFClasspathContainer().getDefaultValue();
                    break;
                }
                case 3: {
                    defaultValue = CXFPackage.eINSTANCE.getCXFContext_Verbose().getDefaultValue();
                    break;
                }
                case 4: {
                    defaultValue = CXFPackage.eINSTANCE.getCXFContext_GenerateAntBuildFile().getDefaultValue();
                    break;
                }
                case 9: {
                    defaultValue = CXFPackage.eINSTANCE.getCXFContext_UseSpringApplicationContext().getDefaultValue();
                    break;
                }
                case 5: {
                    defaultValue = CXFPackage.eINSTANCE.getCXFContext_GenerateClient().getDefaultValue();
                    break;
                }
                case 6: {
                    defaultValue = CXFPackage.eINSTANCE.getCXFContext_GenerateServer().getDefaultValue();
                }
            }
        }
        if (classifierID == 2) {
            switch (featureID) {
                case 16: {
                    defaultValue = CXFPackage.eINSTANCE.getJava2WSContext_AnnotationProcessingEnabled().getDefaultValue();
                    break;
                }
                case 12: {
                    defaultValue = CXFPackage.eINSTANCE.getJava2WSContext_Soap12Binding().getDefaultValue();
                    break;
                }
                case 13: {
                    defaultValue = CXFPackage.eINSTANCE.getJava2WSContext_GenerateXSDImports().getDefaultValue();
                    break;
                }
                case 15: {
                    defaultValue = CXFPackage.eINSTANCE.getJava2WSContext_GenerateWrapperFaultBeans().getDefaultValue();
                    break;
                }
                case 14: {
                    defaultValue = CXFPackage.eINSTANCE.getJava2WSContext_GenerateWSDL().getDefaultValue();
                    break;
                }
                case 17: {
                    defaultValue = CXFPackage.eINSTANCE.getJava2WSContext_GenerateWebMethodAnnotation().getDefaultValue();
                    break;
                }
                case 18: {
                    defaultValue = CXFPackage.eINSTANCE.getJava2WSContext_GenerateWebParamAnnotation().getDefaultValue();
                    break;
                }
                case 19: {
                    defaultValue = CXFPackage.eINSTANCE.getJava2WSContext_GenerateRequestWrapperAnnotation().getDefaultValue();
                    break;
                }
                case 20: {
                    defaultValue = CXFPackage.eINSTANCE.getJava2WSContext_GenerateResponseWrapperAnnotation().getDefaultValue();
                }
            }
        }
        if (classifierID == 4) {
            switch (featureID) {
                case 20: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_NoAddressBinding().getDefaultValue();
                    break;
                }
                case 18: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_UseDefaultValues().getDefaultValue();
                    break;
                }
                case 29: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_AutoNameResolution().getDefaultValue();
                    break;
                }
                case 12: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_GenerateImplementation().getDefaultValue();
                    break;
                }
                case 13: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_ProcessSOAPHeaders().getDefaultValue();
                    break;
                }
                case 4: {
                    defaultValue = CXFPackage.eINSTANCE.getCXFContext_GenerateAntBuildFile().getDefaultValue();
                    break;
                }
                case 16: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_Validate().getDefaultValue();
                    break;
                }
                case 14: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_LoadDefaultNamespacePackageNameMapping().getDefaultValue();
                    break;
                }
                case 15: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_LoadDefaultExcludesNamepsaceMapping().getDefaultValue();
                    break;
                }
                case 21: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_XjcUseDefaultValues().getDefaultValue();
                    break;
                }
                case 22: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_XjcToString().getDefaultValue();
                    break;
                }
                case 23: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_XjcToStringMultiLine().getDefaultValue();
                    break;
                }
                case 24: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_XjcToStringSimple().getDefaultValue();
                    break;
                }
                case 25: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_XjcLocator().getDefaultValue();
                    break;
                }
                case 26: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_XjcSyncMethods().getDefaultValue();
                    break;
                }
                case 27: {
                    defaultValue = CXFPackage.eINSTANCE.getWSDL2JavaContext_XjcMarkGenerated().getDefaultValue();
                }
            }
        }
        if (defaultValue != null && defaultValue instanceof Boolean) {
            return (Boolean)defaultValue;
        }
        return false;
    }

    private static CompilationUnit getAST(ICompilationUnit source) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source);
        return (CompilationUnit)parser.createAST(null);
    }
}

