/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.contentassist;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.text.html.HTML2TextReader;
import org.eclipse.wst.jsdt.ui.tests.utils.TestProjectSetup;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;
import org.junit.Assert;

public class ContentAssistTestUtilities {
    public static void runProposalTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals) throws Exception {
        ContentAssistTestUtilities.runProposalTest(testProject, filePath, lineNum, lineRelativeCharOffset, expectedProposals, false, true);
    }

    public static void runProposalTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals, boolean negativeTest, boolean exactMatch) throws Exception {
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(testProject, filePath, lineNum, lineRelativeCharOffset, expectedProposals.length);
        ContentAssistTestUtilities.verifyExpectedProposal(pages, expectedProposals, negativeTest, exactMatch, false);
    }

    public static void runProposalTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals, boolean negativeTest, boolean exactMatch, boolean inOrder) throws Exception {
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(testProject, filePath, lineNum, lineRelativeCharOffset, expectedProposals.length);
        ContentAssistTestUtilities.verifyExpectedProposal(pages, expectedProposals, negativeTest, exactMatch, inOrder);
    }

    public static void runProposalInfoTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String[][] expectedProposals, String[][] expectedProposalInfo) throws Exception {
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(testProject, filePath, lineNum, lineRelativeCharOffset, expectedProposals.length);
        ContentAssistTestUtilities.verifyExpectedProposalInfo(pages, expectedProposals, expectedProposalInfo);
    }

    public static void verifyNoDuplicates(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset) throws Exception {
        int numOfPages = 1;
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(testProject, filePath, lineNum, lineRelativeCharOffset, numOfPages);
        ContentAssistTestUtilities.checkForDuplicates(pages, numOfPages);
    }

    private static ICompletionProposal[][] getProposals(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, int numOfPages) throws Exception {
        IFile file = testProject.getFile(filePath);
        JavaEditor editor = testProject.getEditor(file);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        int offset = doc.getLineOffset(lineNum) + lineRelativeCharOffset;
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(editor, offset, numOfPages);
        return pages;
    }

    private static ICompletionProposal[][] getProposals(JavaEditor editor, int offset, int pageCount) throws Exception {
        JavaScriptSourceViewerConfiguration configuration = new JavaScriptSourceViewerConfiguration(JavaScriptPlugin.getDefault().getJavaTextTools().getColorManager(), JavaScriptPlugin.getDefault().getCombinedPreferenceStore(), (ITextEditor)editor, "___java_partitioning");
        ISourceViewer viewer = editor.getViewer();
        ContentAssistant contentAssistant = (ContentAssistant)configuration.getContentAssistant(viewer);
        String partitionTypeID = viewer.getDocument().getPartition(offset).getType();
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(partitionTypeID);
        Method privateFireSessionBeginEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionBeginEvent", Boolean.TYPE);
        privateFireSessionBeginEventMethod.setAccessible(true);
        privateFireSessionBeginEventMethod.invoke((Object)contentAssistant, Boolean.TRUE);
        ICompletionProposal[][] pages = new ICompletionProposal[pageCount][];
        int p = 0;
        while (p < pageCount) {
            pages[p] = processor.computeCompletionProposals((ITextViewer)viewer, offset);
            ++p;
        }
        Method privateFireSessionEndEventMethod = ContentAssistant.class.getDeclaredMethod("fireSessionEndEvent", null);
        privateFireSessionEndEventMethod.setAccessible(true);
        privateFireSessionEndEventMethod.invoke((Object)contentAssistant, null);
        return pages;
    }

    private static void verifyExpectedProposal(ICompletionProposal[][] pages, String[][] expectedProposals, boolean negativeTest, boolean exactMatch, boolean inOrder) {
        StringBuffer error = new StringBuffer();
        int lastFoundIndex = -1;
        String lastFoundProposal = "";
        int page = 0;
        while (page < expectedProposals.length) {
            int expected = 0;
            while (expected < expectedProposals[page].length) {
                String expectedProposal = expectedProposals[page][expected];
                boolean found = false;
                int suggestion = 0;
                while (suggestion < pages[page].length && !found) {
                    String displayString = pages[page][suggestion].getDisplayString();
                    found = found || !(exactMatch ? !displayString.equals(expectedProposal) : displayString.indexOf(expectedProposal) == -1);
                    ++suggestion;
                }
                if (inOrder && found && suggestion < lastFoundIndex) {
                    error.append("\nProposal was found out of order: " + expectedProposal + " found before " + lastFoundProposal);
                }
                if (found && negativeTest) {
                    error.append("\nUnexpected proposal was found on page " + page + ": '" + expectedProposal + "'");
                } else if (!found && !negativeTest) {
                    error.append("\n Expected proposal was not found on page " + page + ": '" + expectedProposal + "'");
                }
                if (found) {
                    lastFoundProposal = expectedProposal;
                    lastFoundIndex = suggestion;
                }
                ++expected;
            }
            ++page;
        }
        if (error.length() > 0) {
            int n;
            StringBuffer expected = new StringBuffer();
            String[][] stringArray = expectedProposals;
            int n2 = expectedProposals.length;
            int expectedProposal = 0;
            while (expectedProposal < n2) {
                String[] expectedProposal2;
                String[] stringArray2 = expectedProposal2 = stringArray[expectedProposal];
                n = expectedProposal2.length;
                int n3 = 0;
                while (n3 < n) {
                    String element = stringArray2[n3];
                    expected.append(element);
                    expected.append('\n');
                    ++n3;
                }
                ++expectedProposal;
            }
            StringBuffer actual = new StringBuffer();
            ICompletionProposal[][] iCompletionProposalArray = pages;
            int n4 = pages.length;
            n2 = 0;
            while (n2 < n4) {
                ICompletionProposal[] page2;
                ICompletionProposal[] iCompletionProposalArray2 = page2 = iCompletionProposalArray[n2];
                int n5 = page2.length;
                n = 0;
                while (n < n5) {
                    ICompletionProposal element = iCompletionProposalArray2[n];
                    actual.append(element.getDisplayString());
                    actual.append('\n');
                    ++n;
                }
                ++n2;
            }
            Assert.assertEquals((String)error.toString(), (Object)expected.toString(), (Object)actual.toString());
        }
    }

    private static void verifyExpectedProposalInfo(ICompletionProposal[][] pages, String[][] expectedProposals, String[][] expectedProposalsInfo) {
        StringBuffer error = new StringBuffer();
        String proposalInfo = new String();
        int page = 0;
        while (page < expectedProposals.length) {
            int expected = 0;
            while (expected < expectedProposals[page].length) {
                String expectedProposal = expectedProposals[page][expected];
                String expectedProposalInfo = expectedProposalsInfo[page][expected];
                boolean found = false;
                int suggestion = 0;
                while (suggestion < pages[page].length && !found) {
                    found = pages[page][suggestion].getDisplayString().equals(expectedProposal);
                    if (found) {
                        proposalInfo = pages[page][suggestion].getAdditionalProposalInfo();
                        if (proposalInfo != null && proposalInfo.indexOf(expectedProposalInfo) >= 0) break;
                        error.append("\nRequired proposal info for " + expectedProposal + " does not exist.");
                        break;
                    }
                    ++suggestion;
                }
                ++expected;
            }
            ++page;
        }
        if (error.length() > 0) {
            int n;
            StringBuffer expected = new StringBuffer();
            String[][] stringArray = expectedProposalsInfo;
            int n2 = expectedProposalsInfo.length;
            int expectedProposal = 0;
            while (expectedProposal < n2) {
                String[] element;
                String[] stringArray2 = element = stringArray[expectedProposal];
                n = element.length;
                int n3 = 0;
                while (n3 < n) {
                    String element2 = stringArray2[n3];
                    expected.append(element2);
                    expected.append('\n');
                    ++n3;
                }
                ++expectedProposal;
            }
            StringBuffer actual = new StringBuffer();
            ICompletionProposal[][] iCompletionProposalArray = pages;
            int n4 = pages.length;
            n2 = 0;
            while (n2 < n4) {
                ICompletionProposal[] page2;
                ICompletionProposal[] iCompletionProposalArray2 = page2 = iCompletionProposalArray[n2];
                int n5 = page2.length;
                n = 0;
                while (n < n5) {
                    ICompletionProposal element = iCompletionProposalArray2[n];
                    try {
                        String rawAdditionalProposalInfo = element.getAdditionalProposalInfo();
                        if (rawAdditionalProposalInfo != null) {
                            actual.append(new HTML2TextReader((Reader)new StringReader(rawAdditionalProposalInfo), null).getString().trim());
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    actual.append('\n');
                    ++n;
                }
                ++n2;
            }
            Assert.assertEquals((String)error.toString(), (Object)expected.toString(), (Object)actual.toString());
        }
    }

    private static void checkForDuplicates(ICompletionProposal[][] pages, int numOfPages) {
        HashSet<String> set = new HashSet<String>();
        StringBuffer error = new StringBuffer();
        int suggestion = 0;
        while (suggestion < pages[0].length) {
            if (set.contains(pages[0][suggestion].toString())) {
                error.append("\nDuplicate proposal found: '" + pages[0][suggestion] + "'");
            } else {
                set.add(pages[0][suggestion].toString());
            }
            ++suggestion;
        }
        if (error.length() > 0) {
            Assert.fail((String)error.toString());
        }
        set.clear();
    }

    public static void runProposalandInertTest(TestProjectSetup testProject, String filePath, int lineNum, int lineRelativeCharOffset, String expectedResult) throws Exception {
        System.out.println("TEST PROJECT _ > " + testProject);
        IFile file = testProject.getFile(filePath);
        JavaEditor editor = testProject.getEditor(file);
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        int offset = doc.getLineOffset(lineNum) + lineRelativeCharOffset;
        ICompletionProposal[][] pages = ContentAssistTestUtilities.getProposals(editor, offset, 1);
        ContentAssistTestUtilities.verifyInsertProposalToEditor(editor, offset, pages, expectedResult);
    }

    public static void verifyInsertProposalToEditor(JavaEditor editor, int offset, ICompletionProposal[][] pages, String expectedResult) throws Exception {
        ISourceViewer viewer = editor.getViewer();
        Field fContentAssistant = SourceViewer.class.getDeclaredField("fContentAssistant");
        fContentAssistant.setAccessible(true);
        ContentAssistant contentassistant = (ContentAssistant)fContentAssistant.get(viewer);
        Field fProposalPopup = ContentAssistant.class.getDeclaredField("fProposalPopup");
        fProposalPopup.setAccessible(true);
        Object objPopup = fProposalPopup.get(contentassistant);
        Class<?> proposalPopupClass = Class.forName("org.eclipse.jface.text.contentassist.CompletionProposalPopup");
        Method privateInsertProposalMethod = proposalPopupClass.getDeclaredMethod("insertProposal", ICompletionProposal.class, Character.TYPE, Integer.TYPE, Integer.TYPE);
        privateInsertProposalMethod.setAccessible(true);
        viewer.setSelectedRange(offset, 0);
        privateInsertProposalMethod.invoke(objPopup, pages[0][0], Character.valueOf('\u0000'), 524288, offset);
        String strAfterInsert = viewer.getDocument().get();
        if (!expectedResult.equals(strAfterInsert)) {
            Assert.fail((String)("\n<ExpectedResult>\n" + expectedResult + "\n<The result after inserting to Editor>\n" + strAfterInsert));
        }
    }
}

