/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.tests.util;

import java.util.Collection;
import org.eclipse.jst.ws.jaxws.dom.integration.internal.util.LoadingWsProjectNodesCollector;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ILoadingWsProject;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LoadingWsProjectNodesCollectorTest
extends MockObjectTestCase {
    private TreeItem parentItem;
    private TreeItem childItem;
    private Mock<ILoadingWsProject> loadingProject;
    private Shell treeShell;
    private LoadingWsProjectNodesCollector collector;

    protected void setUp() throws Exception {
        super.setUp();
        this.collector = new LoadingWsProjectNodesCollector();
        this.loadingProject = this.mock(ILoadingWsProject.class);
        this.treeShell = new Shell();
        Tree parentTree = new Tree((Composite)this.treeShell, 0);
        this.parentItem = new TreeItem(parentTree, 0);
        this.childItem = new TreeItem(this.parentItem, 0);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.treeShell.dispose();
    }

    public void testLoadingProjectAsParent() {
        this.parentItem.setData(this.loadingProject.proxy());
        this.childItem.setData(new Object());
        this.verifyFoundItem(this.parentItem);
    }

    public void testLoadingProjectAsChild() {
        this.parentItem.setData(new Object());
        this.childItem.setData(this.loadingProject.proxy());
        this.verifyFoundItem(this.childItem);
    }

    public void testStopCollectingOnWebServiceProject() {
        this.parentItem.setData(this.mock(IWebServiceProject.class).proxy());
        this.childItem.setData(this.loadingProject.proxy());
        LoadingWsProjectNodesCollectorTest.assertEquals((String)"Collector did not stop when IWebServiceProject encoutered", (int)0, (int)this.getLoadingProjectItems().size());
    }

    private void verifyFoundItem(TreeItem expectedItem) {
        Collection<TreeItem> items = this.getLoadingProjectItems();
        LoadingWsProjectNodesCollectorTest.assertEquals((String)"One item expected", (int)1, (int)items.size());
        LoadingWsProjectNodesCollectorTest.assertSame((String)"Unexpected item", (Object)expectedItem, (Object)items.iterator().next());
    }

    private Collection<TreeItem> getLoadingProjectItems() {
        return this.collector.getLoadingWsProjects(new TreeItem[]{this.parentItem});
    }
}

