/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis2.consumption.ui.preferences;

import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterContext;
import org.eclipse.jst.ws.axis2.core.context.Axis2EmitterDefaults;
import org.eclipse.jst.ws.axis2.core.plugin.WebServiceAxis2CorePlugin;
import org.eclipse.jst.ws.axis2.core.plugin.messages.Axis2CoreUIMessages;
import org.eclipse.jst.ws.axis2.core.utils.Axis2CoreUtils;
import org.eclipse.jst.ws.axis2.core.utils.RuntimePropertyUtils;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Axis2RuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text axis2Path;
    private Text statusLabel;
    private Combo aarExtensionCombo;
    private Combo serviceDatabindingCombo;
    private Combo clientDatabindingCombo;
    private Button generateServerSideInterfaceCheckBoxButton;
    private Button generateAllCheckBoxButton;
    private Button syncAndAsyncRadioButton;
    private Button syncOnlyRadioButton;
    private Button asyncOnlyRadioButton;
    private Button clientTestCaseCheckBoxButton;
    private Button clientGenerateAllCheckBoxButton;

    protected Control createContents(Composite superparent) {
        UIUtils uiUtils = new UIUtils("org.eclipse.jst.ws.axis2.ui");
        final Composite mainComp = uiUtils.createComposite(superparent, 1);
        TabFolder axis2PreferenceTab = new TabFolder(mainComp, 64);
        axis2PreferenceTab.setLayoutData((Object)new GridData(1808));
        axis2PreferenceTab.setBackground(mainComp.getBackground());
        TabItem runtimeInstalLocationItem = new TabItem(axis2PreferenceTab, 64);
        runtimeInstalLocationItem.setText(Axis2CoreUIMessages.AXIS2_RUNTIME);
        runtimeInstalLocationItem.setToolTipText(Axis2CoreUIMessages.AXIS2_RUNTIME_TOOLTIP);
        Composite runtimeTab = uiUtils.createComposite((Composite)axis2PreferenceTab, 1);
        runtimeTab.setLayoutData((Object)new GridData(1808));
        Composite runtimeGroup = uiUtils.createComposite(runtimeTab, 3);
        runtimeTab.setBackground(axis2PreferenceTab.getBackground());
        runtimeInstalLocationItem.setControl((Control)runtimeTab);
        runtimeTab.setToolTipText(Axis2CoreUIMessages.AXIS2_RUNTIME_TOOLTIP);
        this.axis2Path = uiUtils.createText(runtimeGroup, Axis2CoreUIMessages.AXIS2_RUNTIME_LOCATION, null, null, 2048);
        Button browseButton = uiUtils.createPushButton(runtimeGroup, Axis2CoreUIMessages.LABEL_BROUSE, null, null);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Axis2RuntimePreferencePage.this.handleBrowse(mainComp.getShell());
            }
        });
        this.axis2Path.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Axis2RuntimePreferencePage.this.statusUpdate(Axis2RuntimePreferencePage.this.runtimeExist(Axis2RuntimePreferencePage.this.axis2Path.getText()));
            }
        });
        new Label(runtimeTab, 256);
        this.statusLabel = new Text(runtimeTab, 16777544);
        this.statusLabel.setLayoutData((Object)new GridData(1808));
        this.statusLabel.setBackground(axis2PreferenceTab.getBackground());
        TabItem codegenPreferencesItem = new TabItem(axis2PreferenceTab, 64);
        codegenPreferencesItem.setText(Axis2CoreUIMessages.AXIS2_PREFERENCES);
        codegenPreferencesItem.setToolTipText(Axis2CoreUIMessages.AXIS2_PREFERENCES_TOOLTIP);
        Composite codegenGroup = uiUtils.createComposite((Composite)axis2PreferenceTab, 1);
        codegenPreferencesItem.setControl((Control)codegenGroup);
        codegenGroup.setToolTipText(Axis2CoreUIMessages.AXIS2_PREFERENCES_TOOLTIP);
        codegenGroup.setBackground(mainComp.getBackground());
        Composite serviceCodegenGroup = uiUtils.createComposite(codegenGroup, 1);
        Text serviceCodegenGroupLabel = new Text(serviceCodegenGroup, 72);
        serviceCodegenGroupLabel.setText(Axis2CoreUIMessages.LABEL_WEB_SERVICE_CODEGEN);
        serviceCodegenGroupLabel.setBackground(axis2PreferenceTab.getBackground());
        Composite dataBindComp = uiUtils.createComposite(serviceCodegenGroup, 2);
        this.serviceDatabindingCombo = uiUtils.createCombo(dataBindComp, Axis2CoreUIMessages.LABEL_DATABINDING, null, null, 8);
        this.generateServerSideInterfaceCheckBoxButton = uiUtils.createCheckbox(serviceCodegenGroup, Axis2CoreUIMessages.LABEL_GENERATE_SERVERSIDE_INTERFACE, null, null);
        this.generateAllCheckBoxButton = uiUtils.createCheckbox(serviceCodegenGroup, Axis2CoreUIMessages.LABEL_GENERATE_ALL, null, null);
        uiUtils.createHorizontalSeparator(codegenGroup, 2);
        Composite clientCodegenGroup = uiUtils.createComposite(codegenGroup, 1);
        Text clientCodegenGroupLabel = new Text(clientCodegenGroup, 8);
        clientCodegenGroupLabel.setText(Axis2CoreUIMessages.LABEL_WEB_SERVICE_CLIENT_CODEGEN);
        clientCodegenGroupLabel.setBackground(axis2PreferenceTab.getBackground());
        Group clientModeRadioComp = uiUtils.createGroup(clientCodegenGroup, Axis2CoreUIMessages.LABEL_CLIENT_SIDE, null, null);
        this.syncAndAsyncRadioButton = uiUtils.createRadioButton((Composite)clientModeRadioComp, Axis2CoreUIMessages.LABEL_SYNC_AND_ASYNC, null, null);
        this.syncOnlyRadioButton = uiUtils.createRadioButton((Composite)clientModeRadioComp, Axis2CoreUIMessages.LABEL_SYNC, null, null);
        this.asyncOnlyRadioButton = uiUtils.createRadioButton((Composite)clientModeRadioComp, Axis2CoreUIMessages.LABEL_ASYNC, null, null);
        Composite dataBind = uiUtils.createComposite(clientCodegenGroup, 2);
        this.clientDatabindingCombo = uiUtils.createCombo(dataBind, Axis2CoreUIMessages.LABEL_DATABINDING, null, null, 8);
        this.clientTestCaseCheckBoxButton = uiUtils.createCheckbox(clientCodegenGroup, Axis2CoreUIMessages.LABEL_GENERATE_TESTCASE_CAPTION, null, null);
        this.clientGenerateAllCheckBoxButton = uiUtils.createCheckbox(clientCodegenGroup, Axis2CoreUIMessages.LABEL_GENERATE_ALL, null, null);
        uiUtils.createHorizontalSeparator(codegenGroup, 2);
        Composite aarGroup = uiUtils.createComposite(codegenGroup, 1);
        Text arrGroupLabel = new Text(aarGroup, 8);
        arrGroupLabel.setText(Axis2CoreUIMessages.LABEL_WEB_SERVICE_AAR);
        arrGroupLabel.setBackground(axis2PreferenceTab.getBackground());
        Composite aarExtGroup = uiUtils.createComposite(aarGroup, 2);
        this.aarExtensionCombo = uiUtils.createCombo(aarExtGroup, Axis2CoreUIMessages.LABEL_AAR_EXTENTION, null, null, 8);
        this.initializeValues();
        axis2PreferenceTab.setEnabled(true);
        axis2PreferenceTab.setVisible(true);
        return mainComp;
    }

    public void init(IWorkbench workbench) {
    }

    private void handleBrowse(Shell parent) {
        DirectoryDialog fileDialog = new DirectoryDialog(parent);
        String fileName = fileDialog.open();
        if (fileName != null) {
            this.axis2Path.setText(fileName);
        }
    }

    private void statusUpdate(boolean status) {
        if (this.statusLabel != null) {
            if (!this.axis2Path.getText().equals("")) {
                if (status) {
                    this.statusLabel.setText(Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD);
                } else {
                    this.statusLabel.setText(Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_LOAD_ERROR);
                }
            } else {
                this.statusLabel.setText(Axis2CoreUIMessages.LABEL_AXIS2_RUNTIME_NOT_EXIT);
            }
        }
    }

    private boolean runtimeExist(String path) {
        File axis2HomeDir = new File(path);
        if (!axis2HomeDir.isDirectory()) {
            return false;
        }
        String axis2LibPath = Axis2CoreUtils.addAnotherNodeToPath((String)axis2HomeDir.getAbsolutePath(), (String)"lib");
        String axis2WebappPath = Axis2CoreUtils.addAnotherNodeToPath((String)axis2HomeDir.getAbsolutePath(), (String)"webapp");
        if (new File(axis2LibPath).isDirectory() && new File(axis2WebappPath).isDirectory()) {
            return true;
        }
        String axis2WarPath = Axis2CoreUtils.addAnotherNodeToPath((String)path, (String)"axis2.war");
        if (new File(axis2WarPath).isFile()) {
            RuntimePropertyUtils.writeWarStausToPropertiesFile((boolean)true);
            return true;
        }
        return false;
    }

    private void storeValues() {
        Axis2EmitterContext context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
        context.setAxis2RuntimeLocation(this.axis2Path.getText());
        RuntimePropertyUtils.writeServerPathToPropertiesFile((String)this.axis2Path.getText());
        context.setServiceDatabinding(this.serviceDatabindingCombo.getItem(this.serviceDatabindingCombo.getSelectionIndex()));
        context.setServiceInterfaceSkeleton(this.generateServerSideInterfaceCheckBoxButton.getSelection());
        context.setServiceGenerateAll(this.generateAllCheckBoxButton.getSelection());
        context.setAsync(this.asyncOnlyRadioButton.getSelection());
        context.setSync(this.syncOnlyRadioButton.getSelection());
        context.setClientDatabinding(this.clientDatabindingCombo.getItem(this.clientDatabindingCombo.getSelectionIndex()));
        context.setClientTestCase(this.clientTestCaseCheckBoxButton.getSelection());
        context.setClientGenerateAll(this.clientGenerateAllCheckBoxButton.getSelection());
        context.setAarExtention(this.aarExtensionCombo.getText());
    }

    private void initializeDefaults() {
        this.aarExtensionCombo.select(0);
        this.serviceDatabindingCombo.select(0);
        this.clientDatabindingCombo.select(0);
        this.generateServerSideInterfaceCheckBoxButton.setSelection(Axis2EmitterDefaults.isServiceInterfaceSkeleton());
        this.generateAllCheckBoxButton.setSelection(Axis2EmitterDefaults.isServiceGenerateAll());
        this.syncAndAsyncRadioButton.setSelection(!Axis2EmitterDefaults.isClientSync() && !Axis2EmitterDefaults.isClientAsync() ? true : Axis2EmitterDefaults.isClientSync() && Axis2EmitterDefaults.isClientAsync());
        this.syncOnlyRadioButton.setSelection(Axis2EmitterDefaults.isClientSync() && !Axis2EmitterDefaults.isClientAsync());
        this.asyncOnlyRadioButton.setSelection(Axis2EmitterDefaults.isClientAsync() && !Axis2EmitterDefaults.isClientSync());
        this.clientTestCaseCheckBoxButton.setSelection(Axis2EmitterDefaults.isClientTestCase());
        this.clientGenerateAllCheckBoxButton.setSelection(Axis2EmitterDefaults.isClientGenerateAll());
        this.axis2Path.setText(Axis2EmitterDefaults.getAxis2RuntimeLocation());
    }

    private void initializeValues() {
        Axis2EmitterContext context = WebServiceAxis2CorePlugin.getDefault().getAxisEmitterContext();
        String[] databindingItems = new String[]{"ADB", "XMLBEANS"};
        this.serviceDatabindingCombo.setItems(databindingItems);
        int selected = this.serviceDatabindingCombo.indexOf(context.getServiceDatabinding().toUpperCase());
        if (selected == -1) {
            this.serviceDatabindingCombo.select(0);
        } else {
            this.serviceDatabindingCombo.select(selected);
        }
        this.clientDatabindingCombo.setItems(databindingItems);
        selected = this.clientDatabindingCombo.indexOf(context.getClientDatabinding().toUpperCase());
        if (selected == -1) {
            this.clientDatabindingCombo.select(0);
        } else {
            this.clientDatabindingCombo.select(selected);
        }
        this.generateServerSideInterfaceCheckBoxButton.setSelection(context.isServiceInterfaceSkeleton());
        this.generateAllCheckBoxButton.setSelection(context.isServiceGenerateAll());
        this.syncAndAsyncRadioButton.setSelection(!context.isSync() && !context.isAsync() ? true : context.isSync() && context.isAsync());
        this.syncOnlyRadioButton.setSelection(context.isSync() && !context.isAsync());
        this.asyncOnlyRadioButton.setSelection(context.isAsync() && !context.isSync());
        this.clientTestCaseCheckBoxButton.setSelection(context.isClientTestCase());
        this.clientGenerateAllCheckBoxButton.setSelection(context.isClientGenerateAll());
        String[] aarExtentionItems = new String[]{"aar"};
        this.aarExtensionCombo.setItems(aarExtentionItems);
        this.aarExtensionCombo.select(0);
        String serverPath = context.getAxis2RuntimeLocation();
        if (serverPath != null) {
            this.axis2Path.setText(serverPath);
            this.statusUpdate(this.runtimeExist(serverPath));
            RuntimePropertyUtils.writeWarStausToPropertiesFile((boolean)false);
        } else {
            this.statusUpdate(false);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    protected void performApply() {
        this.performOk();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }
}

