/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.internal.reference.SimpleObjectReference;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedObject;
import org.eclipse.jpt.common.utility.reference.ModifiableObjectReference;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class SynchronizedObjectTests
extends MultiThreadedTestCase {
    private volatile SynchronizedObject<Object> so;
    volatile boolean timeoutOccurred;
    volatile Object value = new Object();
    volatile long startTime;
    volatile long endTime;
    volatile Object soValue;

    public SynchronizedObjectTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.so = new SynchronizedObject();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.soValue = null;
    }

    public void testCtorObjectObject() throws Exception {
        String v = "foo";
        String mutex = "lock";
        this.so = new SynchronizedObject((Object)v, (Object)mutex);
        SynchronizedObjectTests.assertEquals((Object)v, (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals((Object)mutex, (Object)this.so.getMutex());
    }

    public void testAccessors() throws Exception {
        this.so.setValue(null);
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNotNull());
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNull());
        this.so.setValue(this.value);
        SynchronizedObjectTests.assertEquals((Object)this.value, (Object)this.so.getValue());
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNotNull());
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNull());
        this.so.setNull();
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNotNull());
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNull());
        SynchronizedObjectTests.assertSame(this.so, (Object)this.so.getMutex());
    }

    public void testValueEqualsObject() throws Exception {
        String v = "foo";
        this.so.setValue(null);
        SynchronizedObjectTests.assertTrue((boolean)this.so.valueEquals(null));
        SynchronizedObjectTests.assertFalse((boolean)this.so.valueEquals((Object)v));
        this.so.setValue((Object)v);
        SynchronizedObjectTests.assertTrue((boolean)this.so.valueEquals((Object)v));
        SynchronizedObjectTests.assertFalse((boolean)this.so.valueEquals(null));
    }

    public void testValueNotEqualObject() throws Exception {
        String v = "foo";
        this.so.setValue(null);
        SynchronizedObjectTests.assertFalse((boolean)this.so.valueNotEqual(null));
        SynchronizedObjectTests.assertTrue((boolean)this.so.valueNotEqual((Object)v));
        this.so.setValue((Object)v);
        SynchronizedObjectTests.assertFalse((boolean)this.so.valueNotEqual((Object)v));
        SynchronizedObjectTests.assertTrue((boolean)this.so.valueNotEqual(null));
    }

    public void testIsObject() throws Exception {
        String v = "foo";
        this.so.setValue(null);
        SynchronizedObjectTests.assertTrue((boolean)this.so.is(null));
        SynchronizedObjectTests.assertFalse((boolean)this.so.is((Object)v));
        this.so.setValue((Object)v);
        SynchronizedObjectTests.assertTrue((boolean)this.so.is((Object)v));
        SynchronizedObjectTests.assertFalse((boolean)this.so.is(null));
        SynchronizedObjectTests.assertFalse((boolean)this.so.is((Object)new String(v)));
    }

    public void testIsNotObject() throws Exception {
        String v = "foo";
        this.so.setValue(null);
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNot(null));
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNot((Object)v));
        this.so.setValue((Object)v);
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNot((Object)v));
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNot(null));
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNot((Object)new String(v)));
    }

    public void testIsMemberOfPredicate() throws Exception {
        String v = "foo";
        this.so.setValue(null);
        SynchronizedObjectTests.assertTrue((boolean)this.so.isMemberOf(PredicateTools.isNull()));
        SynchronizedObjectTests.assertFalse((boolean)this.so.isMemberOf(PredicateTools.isNotNull()));
        this.so.setValue((Object)v);
        SynchronizedObjectTests.assertFalse((boolean)this.so.isMemberOf(PredicateTools.isNull()));
        SynchronizedObjectTests.assertTrue((boolean)this.so.isMemberOf(PredicateTools.isNotNull()));
    }

    public void testIsNotMemberOfPredicate() throws Exception {
        String v = "foo";
        this.so.setValue(null);
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNotMemberOf(PredicateTools.isNull()));
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNotMemberOf(PredicateTools.isNotNull()));
        this.so.setValue((Object)v);
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNotMemberOf(PredicateTools.isNull()));
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNotMemberOf(PredicateTools.isNotNull()));
    }

    public void testCommit() throws Exception {
        String v1 = "foo";
        this.so.setValue(null);
        SynchronizedObjectTests.assertTrue((boolean)this.so.commit((Object)v1, null));
        SynchronizedObjectTests.assertEquals((Object)v1, (Object)this.so.getValue());
        SynchronizedObjectTests.assertFalse((boolean)this.so.commit((Object)v1, null));
        SynchronizedObjectTests.assertEquals((Object)v1, (Object)this.so.getValue());
        String v2 = "bar";
        SynchronizedObjectTests.assertTrue((boolean)this.so.commit((Object)v2, (Object)v1));
        SynchronizedObjectTests.assertEquals((Object)v2, (Object)this.so.getValue());
        SynchronizedObjectTests.assertFalse((boolean)this.so.commit((Object)v2, (Object)v1));
        SynchronizedObjectTests.assertEquals((Object)v2, (Object)this.so.getValue());
    }

    public void testSwapRef() throws Exception {
        this.so.setValue(null);
        SynchronizedObject<Object> temp = this.so;
        SynchronizedObjectTests.assertEquals(null, (Object)this.so.swap(temp));
        SimpleObjectReference ref = new SimpleObjectReference((Object)"foo");
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.swap((ModifiableObjectReference)ref));
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals(null, (Object)ref.getValue());
        this.so.setValue((Object)"foo");
        ref.setValue((Object)"foo");
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.swap((ModifiableObjectReference)ref));
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)ref.getValue());
    }

    public void testSwapSyncObject() throws Exception {
        this.so.setValue(null);
        SynchronizedObjectTests.assertEquals(null, (Object)this.so.swap(this.so));
        SynchronizedObject ref = new SynchronizedObject((Object)"foo");
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.swap((ModifiableObjectReference)ref));
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals(null, (Object)ref.getValue());
        this.so.setValue((Object)"foo");
        ref.setValue((Object)"foo");
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.swap((ModifiableObjectReference)ref));
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)ref.getValue());
        ref.setValue((Object)"bar");
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)ref.swap(this.so));
        SynchronizedObjectTests.assertEquals((Object)"bar", (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)ref.getValue());
    }

    public void testSwapSyncInt2() throws Exception {
        this.so.setValue(null);
        SynchronizedObjectTests.assertEquals(null, (Object)this.so.swap(this.so));
        SynchronizedObject ref = new SynchronizedObject((Object)"foo");
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.swap(ref));
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals(null, (Object)ref.getValue());
        this.so.setValue((Object)"foo");
        ref.setValue((Object)"foo");
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.swap(ref));
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)ref.getValue());
    }

    public void testWaitUntilNull() throws Exception {
        this.verifyWaitUntilNull(-1L);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        this.calculateElapsedTime();
    }

    public void testWaitUntilNull2() throws Exception {
        this.verifyWaitUntilNull(0L);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        this.calculateElapsedTime();
    }

    public void testWaitUntilNullTimeout() throws Exception {
        this.verifyWaitUntilNull(TICK);
        SynchronizedObjectTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        long time = this.calculateElapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit late (expected value should be < " + THREE_TICKS + "): " + time), (time < THREE_TICKS ? 1 : 0) != 0);
    }

    public void testWaitUntilNullTimeout2() throws Exception {
        this.verifyWaitUntilNull(THREE_TICKS);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
        this.calculateElapsedTime();
    }

    private void verifyWaitUntilNull(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetNullCommand(), this.buildWaitUntilNullCommand(t2Timeout));
    }

    private Command buildWaitUntilNullCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) throws InterruptedException {
                SynchronizedObjectTests.this.startTime = System.currentTimeMillis();
                SynchronizedObjectTests.this.timeoutOccurred = this.timeoutOccurred(sObject);
                SynchronizedObjectTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedObject<Object> sObject) throws InterruptedException {
                if (timeout < 0L) {
                    sObject.waitUntilNull();
                    return false;
                }
                return !sObject.waitUntilNull(timeout);
            }
        };
    }

    public void testWaitUntilNotPredicate() throws Exception {
        this.so.setValue(this.value);
        this.so.waitUntilNot(PredicateTools.isNull());
        SynchronizedObjectTests.assertEquals((Object)this.value, (Object)this.so.getValue());
    }

    public void testWaitUntilValueEqualsObject() throws Exception {
        String v1 = "foo";
        this.so.setValue((Object)v1);
        String v2 = new String(v1);
        this.so.waitUntilValueEquals((Object)v2);
        SynchronizedObjectTests.assertEquals((Object)v2, (Object)this.so.getValue());
    }

    public void testWaitUntilValueNotEqualObject() throws Exception {
        String v = "foo";
        this.so.setValue((Object)v);
        this.so.waitUntilValueNotEqual(null);
        SynchronizedObjectTests.assertEquals((Object)v, (Object)this.so.getValue());
    }

    public void testWaitUntilValueIsObject() throws Exception {
        String v1 = "foo";
        this.so.setValue((Object)v1);
        this.so.waitUntilValueIs((Object)v1);
        SynchronizedObjectTests.assertEquals((Object)v1, (Object)this.so.getValue());
    }

    public void testWaitUntilValueIsNotObject() throws Exception {
        String v1 = "foo";
        this.so.setValue((Object)v1);
        String v2 = new String(v1);
        this.so.waitUntilValueIsNot((Object)v2);
        SynchronizedObjectTests.assertSame((Object)v1, (Object)this.so.getValue());
        SynchronizedObjectTests.assertNotSame((Object)v2, (Object)this.so.getValue());
    }

    public void testWaitUntilNotNull() throws Exception {
        String v1 = "foo";
        this.so.setValue((Object)v1);
        this.so.waitUntilNotNull();
        SynchronizedObjectTests.assertEquals((Object)v1, (Object)this.so.getValue());
    }

    public void testWaitToSetValueObject() throws Exception {
        this.so.setValue(null);
        SynchronizedObjectTests.assertNull((Object)this.so.waitToSetValue(this.value));
        SynchronizedObjectTests.assertEquals((Object)this.value, (Object)this.so.getValue());
    }

    public void testWaitToSetNull() throws Exception {
        this.so.setValue(this.value);
        SynchronizedObjectTests.assertEquals((Object)this.value, (Object)this.so.waitToSetNull());
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
    }

    public void testWaitToCommit() throws Exception {
        this.so.setValue(this.value);
        SynchronizedObjectTests.assertEquals((Object)this.value, (Object)this.so.waitToCommit((Object)"foo", this.value));
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
    }

    public void testWaitToSetValue() throws Exception {
        this.verifyWaitToSetValue(-1L);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNotNull());
        this.calculateElapsedTime();
    }

    public void testWaitToSetValue2() throws Exception {
        this.verifyWaitToSetValue(0L);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNotNull());
        this.calculateElapsedTime();
    }

    public void testWaitToSetValueTimeout() throws Exception {
        this.verifyWaitToSetValue(TICK);
        SynchronizedObjectTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertTrue((boolean)this.so.isNull());
        long time = this.calculateElapsedTime();
        SynchronizedObjectTests.assertTrue((String)("t2 finished a bit late (expected value should be < " + THREE_TICKS + "): " + time), (time < THREE_TICKS ? 1 : 0) != 0);
    }

    public void testWaitToSetValueTimeout2() throws Exception {
        this.verifyWaitToSetValue(THREE_TICKS);
        SynchronizedObjectTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedObjectTests.assertFalse((boolean)this.so.isNull());
        this.calculateElapsedTime();
    }

    private void verifyWaitToSetValue(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetNullCommand(), this.buildWaitToSetValueCommand(t2Timeout));
    }

    private Command buildWaitToSetValueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) throws InterruptedException {
                SynchronizedObjectTests.this.startTime = System.currentTimeMillis();
                SynchronizedObjectTests.this.timeoutOccurred = this.timeoutOccurred(sObject);
                SynchronizedObjectTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedObject<Object> sObject) throws InterruptedException {
                if (timeout < 0L) {
                    sObject.waitToSetValue(SynchronizedObjectTests.this.value);
                    return false;
                }
                return !sObject.waitToSetValue(SynchronizedObjectTests.this.value, timeout);
            }
        };
    }

    public void testExecute() throws Exception {
        this.so.setValue(null);
        Runnable r1 = this.buildRunnable(this.buildInitializeValueCommand(), this.so, 0L);
        Runnable r2 = this.buildRunnable(this.buildGetValueCommand(), this.so, TICK);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.soValue);
        this.calculateElapsedTime();
    }

    private void executeThreads(Command t1Command, Command t2Command) throws Exception {
        this.so.setValue(this.value);
        Runnable r1 = this.buildRunnable(t1Command, this.so, TWO_TICKS);
        Runnable r2 = this.buildRunnable(t2Command, this.so, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildSetNullCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) {
                sObject.setNull();
            }
        };
    }

    private Command buildInitializeValueCommand() {
        return new Command(){

            @Override
            public void execute(final SynchronizedObject<Object> sObject) throws InterruptedException {
                sObject.execute(new org.eclipse.jpt.common.utility.command.Command(){

                    public void execute() {
                        try {
                            Thread.sleep(5L * TICK);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                        sObject.setValue((Object)"foo");
                    }
                });
            }
        };
    }

    private Command buildGetValueCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedObject<Object> sObject) throws InterruptedException {
                SynchronizedObjectTests.this.startTime = System.currentTimeMillis();
                SynchronizedObjectTests.this.soValue = sObject.getValue();
                SynchronizedObjectTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedObject<Object> sObject, final long sleep) {
        return new MultiThreadedTestCase.TestRunnable(this){

            @Override
            protected void run_() throws InterruptedException {
                if (sleep != 0L) {
                    Thread.sleep(sleep);
                }
                command.execute((SynchronizedObject<Object>)sObject);
            }
        };
    }

    private long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    public void testWaitUntilNotPredicateTimeout() throws Exception {
        this.so.setValue(this.value);
        this.so.waitUntilNot(PredicateTools.isNull(), TWO_TICKS);
        SynchronizedObjectTests.assertEquals((Object)this.value, (Object)this.so.getValue());
    }

    public void testWaitUntilValueEqualsObjectTimeout() throws Exception {
        String v1 = "foo";
        this.so.setValue((Object)v1);
        String v2 = new String(v1);
        this.so.waitUntilValueEquals((Object)v2, TWO_TICKS);
        SynchronizedObjectTests.assertEquals((Object)v2, (Object)this.so.getValue());
    }

    public void testWaitUntilValueNotEqualObjectTimeout() throws Exception {
        String v = "foo";
        this.so.setValue((Object)v);
        this.so.waitUntilValueNotEqual(null, TWO_TICKS);
        SynchronizedObjectTests.assertEquals((Object)v, (Object)this.so.getValue());
    }

    public void testWaitUntilValueIsObjectTimeout() throws Exception {
        String v1 = "foo";
        this.so.setValue((Object)v1);
        this.so.waitUntilValueIs((Object)v1, TWO_TICKS);
        SynchronizedObjectTests.assertEquals((Object)v1, (Object)this.so.getValue());
    }

    public void testWaitUntilValueIsNotObjectTimeout() throws Exception {
        String v1 = "foo";
        this.so.setValue((Object)v1);
        String v2 = new String(v1);
        this.so.waitUntilValueIsNot((Object)v2, TWO_TICKS);
        SynchronizedObjectTests.assertSame((Object)v1, (Object)this.so.getValue());
        SynchronizedObjectTests.assertNotSame((Object)v2, (Object)this.so.getValue());
    }

    public void testWaitUntilNotNullTimeout() throws Exception {
        String v1 = "foo";
        this.so.setValue((Object)v1);
        this.so.waitUntilNotNull(TWO_TICKS);
        SynchronizedObjectTests.assertEquals((Object)v1, (Object)this.so.getValue());
    }

    public void testWaitToSetValueObjectTimeout() throws Exception {
        this.so.setValue(null);
        SynchronizedObjectTests.assertTrue((boolean)this.so.waitToSetValue(this.value, TWO_TICKS));
        SynchronizedObjectTests.assertEquals((Object)this.value, (Object)this.so.getValue());
    }

    public void testWaitToSetNullTimeout() throws Exception {
        this.so.setValue(this.value);
        SynchronizedObjectTests.assertTrue((boolean)this.so.waitToSetNull(TWO_TICKS));
        SynchronizedObjectTests.assertNull((Object)this.so.getValue());
    }

    public void testWaitToCommitTimeout() throws Exception {
        this.so.setValue(this.value);
        SynchronizedObjectTests.assertTrue((boolean)this.so.waitToCommit((Object)"foo", this.value, TWO_TICKS));
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)this.so.getValue());
    }

    public void testEquals() {
        SynchronizedObject so2 = new SynchronizedObject();
        SynchronizedObjectTests.assertTrue((boolean)this.so.equals(this.so));
        SynchronizedObjectTests.assertFalse((boolean)this.so.equals((Object)so2));
    }

    public void testHashCode() {
        SynchronizedObjectTests.assertEquals((int)this.so.hashCode(), (int)this.so.hashCode());
    }

    public void testClone() {
        this.so.setValue(null);
        SynchronizedObject clone = this.so.clone();
        SynchronizedObjectTests.assertNull((Object)clone.getValue());
        SynchronizedObjectTests.assertNotSame((Object)clone, this.so);
        this.so.setValue((Object)"foo");
        clone = this.so.clone();
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)clone.getValue());
        SynchronizedObjectTests.assertNotSame((Object)clone, this.so);
    }

    public void testSerialization() throws Exception {
        this.so.setValue((Object)"foo");
        SynchronizedObject<Object> clone = TestTools.serialize(this.so);
        SynchronizedObjectTests.assertNotSame(this.so, clone);
        SynchronizedObjectTests.assertEquals((Object)"foo", (Object)clone.getValue());
    }

    public void testToString() {
        SynchronizedObjectTests.assertEquals((String)"[null]", (String)this.so.toString());
        this.so.setValue((Object)"foo");
        SynchronizedObjectTests.assertEquals((String)"[foo]", (String)this.so.toString());
    }

    private static interface Command {
        public void execute(SynchronizedObject<Object> var1) throws InterruptedException;
    }
}

