/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.predicate.DisabledPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.False;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class PredicateTests
extends TestCase {
    public PredicateTests(String name) {
        super(name);
    }

    public void testPredicateAdapter() {
        PredicateAdapter filter = new PredicateAdapter();
        PredicateTests.assertFalse((boolean)filter.evaluate((Object)""));
        PredicateTests.assertFalse((boolean)filter.evaluate(null));
        PredicateTests.assertFalse((boolean)filter.evaluate((Object)"foo"));
        PredicateTests.assertFalse((boolean)filter.evaluate((Object)"bar"));
    }

    public void testPredicateAdapter_toString() {
        PredicateAdapter filter = new PredicateAdapter();
        PredicateTests.assertNotNull((Object)filter.toString());
    }

    public void testTruePredicate() {
        Predicate predicate = PredicateTools.true_();
        PredicateTests.assertTrue((boolean)predicate.evaluate((Object)""));
        PredicateTests.assertTrue((boolean)predicate.evaluate((Object)"foo"));
        PredicateTests.assertTrue((boolean)predicate.evaluate((Object)"bar"));
    }

    public void testTruePredicate_toString() {
        Predicate predicate = PredicateTools.true_();
        PredicateTests.assertNotNull((Object)predicate.toString());
    }

    public void testTruePredicate_serialization() throws Exception {
        Predicate predicate = PredicateTools.true_();
        PredicateTests.assertSame((Object)predicate, (Object)TestTools.serialize(predicate));
    }

    public void testFalsePredicate() {
        Predicate predicate = False.instance();
        PredicateTests.assertFalse((boolean)predicate.evaluate((Object)""));
        PredicateTests.assertFalse((boolean)predicate.evaluate((Object)"foo"));
        PredicateTests.assertFalse((boolean)predicate.evaluate((Object)"bar"));
    }

    public void testFalsePredicate_toString() {
        Predicate predicate = False.instance();
        PredicateTests.assertNotNull((Object)predicate.toString());
    }

    public void testFalsePredicate_serialization() throws Exception {
        Predicate predicate = False.instance();
        PredicateTests.assertSame((Object)predicate, (Object)TestTools.serialize(predicate));
    }

    public void testNotNullPredicate() {
        Predicate filter = PredicateTools.isNotNull();
        PredicateTests.assertTrue((boolean)filter.evaluate((Object)""));
        PredicateTests.assertFalse((boolean)filter.evaluate(null));
        PredicateTests.assertTrue((boolean)filter.evaluate((Object)"foo"));
        PredicateTests.assertTrue((boolean)filter.evaluate((Object)"bar"));
    }

    public void testNotNullPredicate_toString() {
        Predicate filter = PredicateTools.isNotNull();
        PredicateTests.assertNotNull((Object)filter.toString());
    }

    public void testNullPredicate() {
        Predicate filter = PredicateTools.isNull();
        PredicateTests.assertFalse((boolean)filter.evaluate((Object)""));
        PredicateTests.assertTrue((boolean)filter.evaluate(null));
        PredicateTests.assertFalse((boolean)filter.evaluate((Object)"foo"));
        PredicateTests.assertFalse((boolean)filter.evaluate((Object)"bar"));
    }

    public void testNullPredicate_toString() {
        Predicate filter = PredicateTools.isNull();
        PredicateTests.assertNotNull((Object)filter.toString());
    }

    public void testDisabledPredicate() {
        Predicate predicate = DisabledPredicate.instance();
        boolean exCaught = false;
        try {
            PredicateTests.assertFalse((boolean)predicate.evaluate((Object)"foo"));
            PredicateTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        PredicateTests.assertTrue((boolean)exCaught);
    }

    public void testDisabledPredicate_toString() {
        Predicate predicate = DisabledPredicate.instance();
        PredicateTests.assertNotNull((Object)predicate.toString());
    }

    public void testDisabledPredicate_serialization() throws Exception {
        Predicate predicate = DisabledPredicate.instance();
        PredicateTests.assertSame((Object)predicate, (Object)TestTools.serialize(predicate));
    }
}

