/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.node;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.node.AbstractNode;
import org.eclipse.jpt.common.utility.node.Node;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class AbstractNodeTests
extends TestCase {
    private TestWorkbenchModel root;

    public AbstractNodeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.root = this.buildRoot();
    }

    private TestWorkbenchModel buildRoot() {
        RootTestWorkbenchModel r = new RootTestWorkbenchModel("root");
        TestWorkbenchModel node1 = r.addTestChildNamed("node 1");
        TestWorkbenchModel node1_1 = node1.addTestChildNamed("node 1.1");
        node1_1.addTestChildNamed("node 1.1.1");
        node1_1.addTestChildNamed("node 1.1.2");
        node1_1.addTestChildNamed("node 1.1.3");
        node1.addTestChildNamed("node 1.2");
        TestWorkbenchModel node2 = r.addTestChildNamed("node 2");
        node2.addTestChildNamed("node 2.1");
        node2.addTestChildNamed("node 2.2");
        r.addTestChildNamed("node 3");
        r.addTestChildNamed("node 4");
        r.markEntireBranchClean();
        return r;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testTestWorkbenchModel() {
        AbstractNodeTests.assertNull((Object)((Object)this.root.testChildNamed("")));
        AbstractNodeTests.assertNotNull((Object)((Object)this.root.testChildNamed("node 1")));
        AbstractNodeTests.assertTrue((boolean)this.root.testChildNamed("node 1").isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.testChildNamed("node 1").isCleanBranch());
        AbstractNodeTests.assertNotNull((Object)((Object)this.root.testChildNamed("node 2")));
        AbstractNodeTests.assertTrue((boolean)this.root.testChildNamed("node 2").isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.testChildNamed("node 2").isCleanBranch());
        AbstractNodeTests.assertNull((Object)((Object)this.root.testChildNamed("node 2.1")));
        AbstractNodeTests.assertNull((Object)((Object)this.root.testDescendantNamed("")));
        AbstractNodeTests.assertNotNull((Object)((Object)this.root.testDescendantNamed("node 1")));
        AbstractNodeTests.assertNotNull((Object)((Object)this.root.testDescendantNamed("node 2")));
        AbstractNodeTests.assertNotNull((Object)((Object)this.root.testDescendantNamed("node 2.1")));
        AbstractNodeTests.assertTrue((boolean)this.root.testDescendantNamed("node 2.1").isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.testDescendantNamed("node 2.1").isCleanBranch());
        AbstractNodeTests.assertNotNull((Object)((Object)this.root.testDescendantNamed("node 1.1.3")));
        AbstractNodeTests.assertTrue((boolean)this.root.testDescendantNamed("node 1.1.3").isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.testDescendantNamed("node 1.1.3").isCleanBranch());
    }

    public void testParentAndChildren() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        AbstractNodeTests.assertEquals((String)"node 1.1.3", (String)node.getName());
        AbstractNodeTests.assertEquals((int)0, (int)IteratorTools.size((Iterator)node.children()));
        node = (TestWorkbenchModel)node.getParent();
        AbstractNodeTests.assertEquals((String)"node 1.1", (String)node.getName());
        AbstractNodeTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)node.children()));
        node = (TestWorkbenchModel)node.getParent();
        AbstractNodeTests.assertEquals((String)"node 1", (String)node.getName());
        AbstractNodeTests.assertEquals((int)2, (int)IteratorTools.size((Iterator)node.children()));
        node = (TestWorkbenchModel)node.getParent();
        AbstractNodeTests.assertEquals((String)"root", (String)node.getName());
        AbstractNodeTests.assertEquals((int)4, (int)IteratorTools.size((Iterator)node.children()));
        node = (TestWorkbenchModel)node.getParent();
        AbstractNodeTests.assertNull((Object)((Object)node));
    }

    public void testDirty() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        node.setSize(42);
        AbstractNodeTests.assertTrue((boolean)node.isDirty());
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        AbstractNodeTests.assertTrue((boolean)parent.isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.isClean());
    }

    public void testDirtyUnchangedAttribute() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        node.setSize(42);
        AbstractNodeTests.assertTrue((boolean)node.isDirty());
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        AbstractNodeTests.assertTrue((boolean)parent.isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.isClean());
        this.root.markEntireBranchClean();
        node.setSize(42);
        AbstractNodeTests.assertTrue((boolean)node.isClean());
        AbstractNodeTests.assertTrue((boolean)parent.isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.isClean());
    }

    public void testDirtyBranch() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        node.setSize(42);
        AbstractNodeTests.assertTrue((boolean)node.isDirtyBranch());
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        AbstractNodeTests.assertTrue((boolean)parent.isDirtyBranch());
        AbstractNodeTests.assertTrue((boolean)this.root.isDirtyBranch());
        parent.setSize(77);
        AbstractNodeTests.assertTrue((boolean)parent.isDirty());
        AbstractNodeTests.assertTrue((boolean)parent.isDirtyBranch());
        node.markEntireBranchClean();
        AbstractNodeTests.assertTrue((boolean)parent.isDirty());
        AbstractNodeTests.assertTrue((boolean)parent.isDirtyBranch());
    }

    public void testDirtyBranchCleanChildDirtyParent() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        node.setSize(42);
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        parent.setSize(77);
        AbstractNodeTests.assertTrue((boolean)parent.isDirty());
        AbstractNodeTests.assertTrue((boolean)parent.isDirtyBranch());
        node.markEntireBranchClean();
        AbstractNodeTests.assertTrue((boolean)parent.isDirty());
        AbstractNodeTests.assertTrue((boolean)parent.isDirtyBranch());
    }

    public void testDirtyBranchCleanChildDirtyChild() {
        TestWorkbenchModel node1 = this.root.testDescendantNamed("node 1.1.1");
        node1.setSize(41);
        TestWorkbenchModel node2 = this.root.testDescendantNamed("node 1.1.2");
        node2.setSize(42);
        TestWorkbenchModel parent = (TestWorkbenchModel)node1.getParent();
        AbstractNodeTests.assertTrue((boolean)parent.isClean());
        AbstractNodeTests.assertTrue((boolean)parent.isDirtyBranch());
        node1.markEntireBranchClean();
        AbstractNodeTests.assertTrue((boolean)parent.isClean());
        AbstractNodeTests.assertTrue((boolean)parent.isDirtyBranch());
    }

    public void testDirtyBranchForced() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        AbstractNodeTests.assertTrue((boolean)node.isClean());
        AbstractNodeTests.assertTrue((boolean)node.isCleanBranch());
        AbstractNodeTests.assertTrue((boolean)parent.isClean());
        AbstractNodeTests.assertTrue((boolean)parent.isCleanBranch());
        AbstractNodeTests.assertTrue((boolean)this.root.isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.isCleanBranch());
        this.root.markEntireBranchDirty();
        AbstractNodeTests.assertTrue((boolean)node.isDirty());
        AbstractNodeTests.assertTrue((boolean)node.isDirtyBranch());
        AbstractNodeTests.assertTrue((boolean)parent.isDirty());
        AbstractNodeTests.assertTrue((boolean)parent.isDirtyBranch());
        AbstractNodeTests.assertTrue((boolean)this.root.isDirty());
        AbstractNodeTests.assertTrue((boolean)this.root.isDirtyBranch());
    }

    public void testDirtyTransientAttribute() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        node.setName("BOGUS");
        AbstractNodeTests.assertTrue((boolean)node.isDirty());
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        AbstractNodeTests.assertTrue((boolean)parent.isClean());
        AbstractNodeTests.assertTrue((boolean)parent.isDirtyBranch());
        AbstractNodeTests.assertTrue((boolean)this.root.isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.isDirtyBranch());
        this.root.markEntireBranchClean();
        this.root.validateBranch();
        AbstractNodeTests.assertTrue((this.root.problemsSize() == 0 ? 1 : 0) != 0);
        AbstractNodeTests.assertTrue((boolean)node.branchProblems().hasNext());
        AbstractNodeTests.assertTrue((parent.problemsSize() == 0 ? 1 : 0) != 0);
        AbstractNodeTests.assertTrue((boolean)parent.branchProblems().hasNext());
        AbstractNodeTests.assertTrue((node.problemsSize() > 0 ? 1 : 0) != 0);
        AbstractNodeTests.assertTrue((boolean)node.isClean());
        AbstractNodeTests.assertTrue((boolean)node.isCleanBranch());
        AbstractNodeTests.assertTrue((boolean)parent.isClean());
        AbstractNodeTests.assertTrue((boolean)parent.isCleanBranch());
        AbstractNodeTests.assertTrue((boolean)this.root.isClean());
        AbstractNodeTests.assertTrue((boolean)this.root.isCleanBranch());
    }

    public void testProblems() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        node.setName("BOGUS");
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        this.root.validateBranch();
        AbstractNodeTests.assertEquals((int)0, (int)this.root.problemsSize());
        AbstractNodeTests.assertTrue((boolean)node.branchProblems().hasNext());
        AbstractNodeTests.assertEquals((int)0, (int)parent.problemsSize());
        AbstractNodeTests.assertTrue((boolean)parent.branchProblems().hasNext());
        AbstractNodeTests.assertEquals((int)1, (int)node.problemsSize());
        Node.Problem problem1 = (Node.Problem)node.problems().next();
        node.setName("STILL BOGUS");
        this.root.validateBranch();
        AbstractNodeTests.assertEquals((int)0, (int)this.root.problemsSize());
        AbstractNodeTests.assertTrue((boolean)node.branchProblems().hasNext());
        AbstractNodeTests.assertEquals((int)0, (int)parent.problemsSize());
        AbstractNodeTests.assertTrue((boolean)parent.branchProblems().hasNext());
        AbstractNodeTests.assertEquals((int)1, (int)node.problemsSize());
        Node.Problem problem2 = (Node.Problem)node.problems().next();
        AbstractNodeTests.assertFalse((problem1 == problem2 ? 1 : 0) != 0);
        problem1 = problem2;
        node.setName("STILL BOGUS");
        this.root.validateBranch();
        AbstractNodeTests.assertEquals((int)0, (int)this.root.problemsSize());
        AbstractNodeTests.assertTrue((boolean)node.branchProblems().hasNext());
        AbstractNodeTests.assertEquals((int)0, (int)parent.problemsSize());
        AbstractNodeTests.assertTrue((boolean)parent.branchProblems().hasNext());
        AbstractNodeTests.assertEquals((int)1, (int)node.problemsSize());
        problem2 = (Node.Problem)node.problems().next();
        AbstractNodeTests.assertTrue((boolean)problem1.equals((Object)problem2));
    }

    public void testBranchProblems() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        node.setName("BOGUS");
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        parent.setName("BOGUS TOO");
        this.root.setName("BOGUS TOO TOO");
        this.root.validateBranch();
        AbstractNodeTests.assertEquals((int)1, (int)this.root.problemsSize());
        AbstractNodeTests.assertEquals((int)3, (int)this.root.branchProblemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)parent.problemsSize());
        AbstractNodeTests.assertEquals((int)2, (int)parent.branchProblemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)node.problemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)node.branchProblemsSize());
        node.setName("okie-dokie");
        this.root.validateBranch();
        AbstractNodeTests.assertEquals((int)1, (int)this.root.problemsSize());
        AbstractNodeTests.assertEquals((int)2, (int)this.root.branchProblemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)parent.problemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)parent.branchProblemsSize());
        AbstractNodeTests.assertEquals((int)0, (int)node.problemsSize());
        AbstractNodeTests.assertEquals((int)0, (int)node.branchProblemsSize());
    }

    public void testClearAllBranchProblems() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        node.setName("BOGUS");
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        parent.setName("BOGUS TOO");
        this.root.setName("BOGUS TOO TOO");
        this.root.validateBranch();
        AbstractNodeTests.assertEquals((int)1, (int)this.root.problemsSize());
        AbstractNodeTests.assertEquals((int)3, (int)this.root.branchProblemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)parent.problemsSize());
        AbstractNodeTests.assertEquals((int)2, (int)parent.branchProblemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)node.problemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)node.branchProblemsSize());
        parent.clearAllBranchProblems();
        AbstractNodeTests.assertEquals((int)1, (int)this.root.problemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)this.root.branchProblemsSize());
        AbstractNodeTests.assertEquals((int)0, (int)parent.problemsSize());
        AbstractNodeTests.assertEquals((int)0, (int)parent.branchProblemsSize());
        AbstractNodeTests.assertEquals((int)0, (int)node.problemsSize());
        AbstractNodeTests.assertEquals((int)0, (int)IteratorTools.size((Iterator)node.branchProblems()));
    }

    public void testRemovedBranchProblems() {
        TestWorkbenchModel node = this.root.testDescendantNamed("node 1.1.3");
        node.setName("BOGUS");
        TestWorkbenchModel parent = (TestWorkbenchModel)node.getParent();
        parent.setName("BOGUS TOO");
        this.root.setName("BOGUS TOO TOO");
        this.root.validateBranch();
        AbstractNodeTests.assertEquals((int)1, (int)this.root.problemsSize());
        AbstractNodeTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)this.root.branchProblems()));
        AbstractNodeTests.assertEquals((int)1, (int)parent.problemsSize());
        AbstractNodeTests.assertEquals((int)2, (int)parent.branchProblemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)node.problemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)IteratorTools.size((Iterator)node.branchProblems()));
        parent.removeTestChild(node);
        this.root.validateBranch();
        AbstractNodeTests.assertEquals((int)1, (int)this.root.problemsSize());
        AbstractNodeTests.assertEquals((int)2, (int)IteratorTools.size((Iterator)this.root.branchProblems()));
        AbstractNodeTests.assertEquals((int)1, (int)parent.problemsSize());
        AbstractNodeTests.assertEquals((int)1, (int)parent.branchProblemsSize());
    }

    private class RootTestWorkbenchModel
    extends TestWorkbenchModel {
        public RootTestWorkbenchModel(String name) {
            super(null, name);
        }

        public Node.Validator getValidator() {
            return Node.NULL_VALIDATOR;
        }
    }

    public class TestWorkbenchModel
    extends AbstractNode {
        private String name;
        public static final String NAME_PROPERTY = "name";
        private int size;
        public static final String SIZE_PROPERTY = "size";
        private Collection<TestWorkbenchModel> testChildren;
        public static final String TEST_CHILDREN_COLLECTION = "children";

        public TestWorkbenchModel(TestWorkbenchModel parent, String name) {
            super((Node)parent);
            if (name == null) {
                throw new NullPointerException();
            }
            this.name = name;
        }

        protected void initialize() {
            super.initialize();
            this.size = 0;
            this.testChildren = new HashBag();
        }

        protected void checkParent(Node parent) {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            int old = this.size;
            this.size = size;
            this.firePropertyChanged(SIZE_PROPERTY, old, size);
        }

        public Iterator<TestWorkbenchModel> testChildren() {
            return IteratorTools.clone(this.testChildren, (Closure)new Closure<TestWorkbenchModel>(){

                public void execute(TestWorkbenchModel current) {
                    TestWorkbenchModel.this.removeTestChild(current);
                }
            });
        }

        public int testChildrenSize() {
            return this.testChildren.size();
        }

        private TestWorkbenchModel addTestChild(TestWorkbenchModel testChild) {
            this.addItemToCollection((Object)testChild, this.testChildren, TEST_CHILDREN_COLLECTION);
            return testChild;
        }

        public TestWorkbenchModel addTestChildNamed(String childName) {
            if (this.testChildNamed(childName) != null) {
                throw new IllegalArgumentException(childName);
            }
            return this.addTestChild(new TestWorkbenchModel(this, childName));
        }

        public void removeTestChild(TestWorkbenchModel testChild) {
            this.removeItemFromCollection((Object)testChild, this.testChildren, TEST_CHILDREN_COLLECTION);
        }

        public String displayString() {
            return this.name;
        }

        public TestWorkbenchModel testChildNamed(String childName) {
            for (TestWorkbenchModel testChild : this.testChildren) {
                if (!testChild.getName().equals(childName)) continue;
                return testChild;
            }
            return null;
        }

        public TestWorkbenchModel testDescendantNamed(String descendantName) {
            for (TestWorkbenchModel testDescendant : this.testChildren) {
                if (testDescendant.getName().equals(descendantName)) {
                    return testDescendant;
                }
                if ((testDescendant = testDescendant.testDescendantNamed(descendantName)) == null) continue;
                return testDescendant;
            }
            return null;
        }

        protected void addChildrenTo(List<Node> children) {
            super.addChildrenTo(children);
            children.addAll(this.testChildren);
        }

        protected void addProblemsTo(List<Node.Problem> currentProblems) {
            super.addProblemsTo(currentProblems);
            int i = this.name.length();
            while (i-- > 0) {
                char c = this.name.charAt(i);
                if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
                currentProblems.add(this.buildProblem("NAME_MUST_BE_LOWERCASE", 3, new Object[]{this.name}));
                return;
            }
        }

        public void toString(StringBuilder sb) {
            sb.append(this.name);
        }
    }
}

