/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeBooleanPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.common.utility.model.listener.ChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class CompositeBooleanPropertyValueModelTests
extends TestCase {
    private SimplePropertyValueModel<Boolean> pvm1;
    private ModifiablePropertyValueModel<Boolean> pvm2;
    private ModifiablePropertyValueModel<Boolean> pvm3;
    private ModifiablePropertyValueModel<Boolean> pvm4;
    private Collection<ModifiablePropertyValueModel<Boolean>> collection;
    private SimpleCollectionValueModel<ModifiablePropertyValueModel<Boolean>> cvm;
    private PropertyValueModel<Boolean> compositePVM;
    PropertyChangeEvent event;

    public CompositeBooleanPropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.pvm1 = new SimplePropertyValueModel((Object)Boolean.TRUE);
        this.pvm2 = new SimplePropertyValueModel((Object)Boolean.TRUE);
        this.pvm3 = new SimplePropertyValueModel((Object)Boolean.TRUE);
        this.pvm4 = new SimplePropertyValueModel((Object)Boolean.TRUE);
        this.collection = new ArrayList<ModifiablePropertyValueModel<Boolean>>();
        this.collection.add((ModifiablePropertyValueModel<Boolean>)this.pvm1);
        this.collection.add(this.pvm2);
        this.collection.add(this.pvm3);
        this.collection.add(this.pvm4);
        this.cvm = new SimpleCollectionValueModel(this.collection);
        this.compositePVM = this.buildCompositePVM((CollectionValueModel<ModifiablePropertyValueModel<Boolean>>)this.cvm);
    }

    private PropertyValueModel<Boolean> buildCompositePVM(CollectionValueModel<ModifiablePropertyValueModel<Boolean>> pvms) {
        return CompositeBooleanPropertyValueModel.and(pvms);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetValue() {
        CompositeBooleanPropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
        ChangeListener listener = this.buildListener();
        this.compositePVM.addChangeListener(listener);
        CompositeBooleanPropertyValueModelTests.assertTrue((boolean)((Boolean)this.compositePVM.getValue()));
    }

    public void testValueAndListeners1() {
        CompositeBooleanPropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
        ChangeListener listener = this.buildListener();
        this.compositePVM.addChangeListener(listener);
        CompositeBooleanPropertyValueModelTests.assertTrue((boolean)((Boolean)this.compositePVM.getValue()));
        this.compositePVM.removeChangeListener(listener);
        CompositeBooleanPropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
    }

    public void testValueAndListeners2() {
        CompositeBooleanPropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
        ChangeListener listener = this.buildListener();
        this.compositePVM.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        CompositeBooleanPropertyValueModelTests.assertTrue((boolean)((Boolean)this.compositePVM.getValue()));
        this.compositePVM.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        CompositeBooleanPropertyValueModelTests.assertNull((Object)this.compositePVM.getValue());
    }

    public void testPropertyChange1() {
        this.compositePVM.addChangeListener(this.buildListener());
        this.verifyPropertyChange();
    }

    public void testPropertyChange2() {
        this.compositePVM.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.verifyPropertyChange();
    }

    private void verifyPropertyChange() {
        this.event = null;
        this.pvm1.setValue((Object)Boolean.FALSE);
        this.verifyEvent(true, false);
        this.event = null;
        this.pvm2.setValue((Object)Boolean.FALSE);
        CompositeBooleanPropertyValueModelTests.assertNull((Object)this.event);
        this.event = null;
        this.pvm2.setValue((Object)Boolean.TRUE);
        CompositeBooleanPropertyValueModelTests.assertNull((Object)this.event);
        this.event = null;
        this.pvm1.setValue((Object)Boolean.TRUE);
        this.verifyEvent(false, true);
        this.event = null;
        this.pvm4.setValue((Object)Boolean.FALSE);
        this.verifyEvent(true, false);
    }

    public void testCollectionChange1() {
        this.compositePVM.addChangeListener(this.buildListener());
        this.verifyCollectionChange();
    }

    public void testCollectionChange2() {
        this.compositePVM.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.verifyCollectionChange();
    }

    private void verifyCollectionChange() {
        this.event = null;
        SimplePropertyValueModel pvm = new SimplePropertyValueModel((Object)Boolean.FALSE);
        this.cvm.add((Object)pvm);
        this.verifyEvent(true, false);
        this.event = null;
        this.cvm.remove((Object)pvm);
        this.verifyEvent(false, true);
        this.event = null;
        this.cvm.clear();
        this.verifyEvent(Boolean.TRUE, null);
        ArrayList<Object> c2 = new ArrayList<Object>();
        c2.add(this.pvm1);
        c2.add(this.pvm2);
        this.event = null;
        this.cvm.setValues(c2);
        this.verifyEvent(null, Boolean.TRUE);
    }

    public void testLazyListening1() {
        CompositeBooleanPropertyValueModelTests.assertFalse((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
        ChangeListener listener = this.buildListener();
        this.compositePVM.addChangeListener(listener);
        CompositeBooleanPropertyValueModelTests.assertTrue((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
        this.compositePVM.removeChangeListener(listener);
        CompositeBooleanPropertyValueModelTests.assertFalse((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
    }

    public void testLazyListening2() {
        CompositeBooleanPropertyValueModelTests.assertFalse((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
        ChangeListener listener = this.buildListener();
        this.compositePVM.addPropertyChangeListener("value", (PropertyChangeListener)listener);
        CompositeBooleanPropertyValueModelTests.assertTrue((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
        this.compositePVM.removePropertyChangeListener("value", (PropertyChangeListener)listener);
        CompositeBooleanPropertyValueModelTests.assertFalse((boolean)this.pvm1.hasAnyPropertyChangeListeners("value"));
    }

    private ChangeListener buildListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                CompositeBooleanPropertyValueModelTests.this.event = e;
            }
        };
    }

    private void verifyEvent(boolean oldValue, boolean newValue) {
        this.verifyEvent((Boolean)oldValue, (Boolean)newValue);
    }

    private void verifyEvent(Boolean oldValue, Boolean newValue) {
        CompositeBooleanPropertyValueModelTests.assertEquals(this.compositePVM, (Object)this.event.getSource());
        CompositeBooleanPropertyValueModelTests.assertEquals((String)"value", (String)this.event.getPropertyName());
        CompositeBooleanPropertyValueModelTests.assertEquals((Object)oldValue, (Object)this.event.getOldValue());
        CompositeBooleanPropertyValueModelTests.assertEquals((Object)newValue, (Object)this.event.getNewValue());
    }
}

