/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.iterable;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.DisabledTransformer;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public class TransformationIterableTests
extends TestCase {
    static final Transformer<String, Integer> STRING_LENGTH_TRANSFORMER = new StringLengthTransformer();

    public TransformationIterableTests(String name) {
        super(name);
    }

    public void testTransform() {
        int i = 1;
        for (Integer integer : this.buildIterable()) {
            TransformationIterableTests.assertEquals((int)i++, (int)integer);
        }
    }

    private Iterable<Integer> buildIterable() {
        return this.buildTransformationIterable(this.buildNestedIterable());
    }

    private Iterable<Integer> buildTransformationIterable(Iterable<String> nestedIterable) {
        return new TransformationIterable(nestedIterable, STRING_LENGTH_TRANSFORMER);
    }

    private Iterable<String> buildNestedIterable() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("1");
        c.add("22");
        c.add("333");
        c.add("4444");
        c.add("55555");
        c.add("666666");
        c.add("7777777");
        c.add("88888888");
        return c;
    }

    public void testToString() {
        TransformationIterableTests.assertNotNull((Object)this.buildIterable().toString());
    }

    public void testMissingTransformer() {
        TransformationIterable iterable = new TransformationIterable(this.buildNestedIterable(), DisabledTransformer.instance());
        boolean exCaught = false;
        try {
            int i = 1;
            for (Integer integer : iterable) {
                TransformationIterableTests.assertEquals((int)i++, (int)integer);
            }
        }
        catch (RuntimeException runtimeException) {
            exCaught = true;
        }
        TransformationIterableTests.assertTrue((boolean)exCaught);
    }

    static class StringLengthTransformer
    extends TransformerAdapter<String, Integer> {
        StringLengthTransformer() {
        }

        public Integer transform(String s) {
            return new Integer(s.length());
        }
    }
}

