/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.util.Comparator;
import org.eclipse.jpt.common.utility.internal.deque.DequeTools;
import org.eclipse.jpt.common.utility.internal.deque.FixedCapacityPriorityDeque;
import org.eclipse.jpt.common.utility.tests.internal.deque.AbstractPriorityDequeTests;

public class FixedCapacityPriorityDequeTests
extends AbstractPriorityDequeTests {
    public FixedCapacityPriorityDequeTests(String name) {
        super(name);
    }

    <E extends Comparable<E>> FixedCapacityPriorityDeque<E> buildDeque() {
        return DequeTools.fixedCapacityPriorityDeque((int)10);
    }

    <E extends Comparable<E>> FixedCapacityPriorityDeque<E> buildDeque(int capacity) {
        return DequeTools.fixedCapacityPriorityDeque((int)capacity);
    }

    <E extends Comparable<E>> FixedCapacityPriorityDeque<E> buildDeque(Comparator<E> comparator, int capacity) {
        return DequeTools.fixedCapacityPriorityDeque(comparator, (int)capacity);
    }

    public void testIsFull() throws Exception {
        FixedCapacityPriorityDeque deque = this.buildDeque();
        FixedCapacityPriorityDequeTests.assertFalse((boolean)deque.isFull());
        deque.enqueue((Object)"first");
        FixedCapacityPriorityDequeTests.assertFalse((boolean)deque.isFull());
        deque.enqueue((Object)"second");
        FixedCapacityPriorityDequeTests.assertFalse((boolean)deque.isFull());
        deque.enqueue((Object)"third");
        deque.enqueue((Object)"fourth");
        deque.enqueue((Object)"fifth");
        deque.enqueue((Object)"sixth");
        deque.enqueue((Object)"seventh");
        deque.enqueue((Object)"eighth");
        deque.enqueue((Object)"ninth");
        deque.enqueue((Object)"tenth");
        FixedCapacityPriorityDequeTests.assertTrue((boolean)deque.isFull());
        deque.dequeueHead();
        FixedCapacityPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.dequeueHead();
        deque.dequeueHead();
        deque.dequeueHead();
        deque.dequeueHead();
        deque.dequeueHead();
        deque.dequeueHead();
        deque.dequeueHead();
        FixedCapacityPriorityDequeTests.assertFalse((boolean)deque.isFull());
    }

    public void testCapacityExceeded() {
        FixedCapacityPriorityDeque deque = this.buildDeque();
        FixedCapacityPriorityDequeTests.assertTrue((boolean)deque.isEmpty());
        deque.enqueue((Object)"first");
        FixedCapacityPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.enqueue((Object)"second");
        FixedCapacityPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        deque.enqueue((Object)"third");
        deque.enqueue((Object)"fourth");
        deque.enqueue((Object)"fifth");
        deque.enqueue((Object)"sixth");
        deque.enqueue((Object)"seventh");
        deque.enqueue((Object)"eighth");
        deque.enqueue((Object)"ninth");
        deque.enqueue((Object)"tenth");
        boolean exCaught = false;
        try {
            deque.enqueue((Object)"eleventh");
            FixedCapacityPriorityDequeTests.fail((String)("bogus deque: " + deque));
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        FixedCapacityPriorityDequeTests.assertTrue((boolean)exCaught);
        FixedCapacityPriorityDequeTests.assertEquals((String)"eighth", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertEquals((String)"fifth", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertEquals((String)"first", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertEquals((String)"fourth", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        FixedCapacityPriorityDequeTests.assertEquals((String)"ninth", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertEquals((String)"second", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertEquals((String)"seventh", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertEquals((String)"sixth", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertFalse((boolean)deque.isEmpty());
        FixedCapacityPriorityDequeTests.assertEquals((String)"tenth", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertEquals((String)"third", (String)((String)deque.dequeueHead()));
        FixedCapacityPriorityDequeTests.assertTrue((boolean)deque.isEmpty());
    }
}

