/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.deque.DequeTools;
import org.eclipse.jpt.common.utility.internal.deque.EmptyDeque;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class EmptyDequeTests
extends TestCase {
    public EmptyDequeTests(String name) {
        super(name);
    }

    public void testEnqueueTail() {
        Deque deque = DequeTools.emptyDeque();
        boolean exCaught = false;
        try {
            deque.enqueueTail((Object)"junk");
            EmptyDequeTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        EmptyDequeTests.assertTrue((boolean)exCaught);
    }

    public void testEnqueueHead() {
        Deque deque = EmptyDeque.instance();
        boolean exCaught = false;
        try {
            deque.enqueueHead((Object)"junk");
            EmptyDequeTests.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        EmptyDequeTests.assertTrue((boolean)exCaught);
    }

    public void testDequeueHead() {
        Deque deque = EmptyDeque.instance();
        boolean exCaught = false;
        try {
            String bogus = (String)deque.dequeueHead();
            EmptyDequeTests.fail((String)bogus);
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyDequeTests.assertTrue((boolean)exCaught);
    }

    public void testDequeueTail() {
        Deque deque = EmptyDeque.instance();
        boolean exCaught = false;
        try {
            String bogus = (String)deque.dequeueTail();
            EmptyDequeTests.fail((String)bogus);
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyDequeTests.assertTrue((boolean)exCaught);
    }

    public void testPeekHead() {
        Deque deque = EmptyDeque.instance();
        boolean exCaught = false;
        try {
            String bogus = (String)deque.peekHead();
            EmptyDequeTests.fail((String)bogus);
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyDequeTests.assertTrue((boolean)exCaught);
    }

    public void testPeekTail() {
        Deque deque = EmptyDeque.instance();
        boolean exCaught = false;
        try {
            String bogus = (String)deque.peekTail();
            EmptyDequeTests.fail((String)bogus);
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        EmptyDequeTests.assertTrue((boolean)exCaught);
    }

    public void testIsEmpty() {
        Deque deque = EmptyDeque.instance();
        EmptyDequeTests.assertTrue((boolean)deque.isEmpty());
    }

    public void testToString() {
        Deque deque = EmptyDeque.instance();
        EmptyDequeTests.assertEquals((String)"[]", (String)deque.toString());
    }

    public void testSerialization() throws Exception {
        Deque deque = EmptyDeque.instance();
        EmptyDequeTests.assertSame((Object)deque, (Object)TestTools.serialize(deque));
    }
}

