/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValidatorMessage {
    public static final String ValidationId = "ValidationId";
    private final Map<String, Object> _map = new HashMap<String, Object>(5);
    private IResource _resource;
    private String _type;

    public static ValidatorMessage create(String message, IResource resource) {
        ValidatorMessage msg = new ValidatorMessage();
        msg._type = "org.eclipse.wst.validation.problemmarker2";
        msg._resource = resource;
        msg.setAttribute("message", ValidationPlugin.getPlugin().isDebugging() ? Tracing.timestampIt(message) : message);
        return msg;
    }

    private ValidatorMessage() {
    }

    public ValidatorMessage asCopy() {
        ValidatorMessage msg = new ValidatorMessage();
        msg._resource = this._resource;
        msg._type = this._type;
        msg._map.putAll(this._map);
        return msg;
    }

    public Object getAttribute(String attributeName) {
        return this._map.get(attributeName);
    }

    public int getAttribute(String attributeName, int defaultValue) {
        Integer value = null;
        try {
            value = (Integer)this._map.get(attributeName);
        }
        catch (Exception exception) {}
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String value = null;
        try {
            value = (String)this._map.get(attributeName);
        }
        catch (Exception exception) {}
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public boolean getAttribute(String attributeName, boolean defaultValue) {
        Boolean value = null;
        try {
            value = (Boolean)this._map.get(attributeName);
        }
        catch (Exception exception) {}
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map getAttributes() {
        return this._map;
    }

    public IResource getResource() {
        return this._resource;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        assert (type != null);
        this._type = type;
    }

    public void setAttribute(String attributeName, int value) {
        this._map.put(attributeName, new Integer(value));
    }

    public void setAttribute(String attributeName, Object value) {
        this._map.put(attributeName, value);
    }

    public void setAttribute(String attributeName, boolean value) {
        this._map.put(attributeName, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAttributes(String[] attributeNames, Object[] values) {
        Assert.isTrue((attributeNames.length == values.length ? 1 : 0) != 0);
        int i = 0;
        while (i < attributeNames.length) {
            this.setAttribute(attributeNames[i], values[i]);
            ++i;
        }
    }

    public void setAttributes(Map<String, Object> attributes) {
        this._map.clear();
        this._map.putAll(attributes);
    }
}

