/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestOperation;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.ejb.internal.plugin.EjbPlugin;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EJBClientJarCreationHelper;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EJBClientJarFileMoveDataModelProvider;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EJBClientManifestUtility;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.IEjbClientJarCreationDataModelProperties;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.InvertClientJARDependencyCompoundOperation;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.facet.UtilityProjectCreationDataModelProvider;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.jee.project.facet.IEJBCreateDeploymentFilesDataModelProperties;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class EjbClientJarCreationOperation
extends AbstractDataModelOperation
implements IEjbClientJarCreationDataModelProperties {
    private IProgressMonitor monitor = null;

    public EjbClientJarCreationOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor aMonitor, IAdaptable info) throws ExecutionException {
        this.monitor = aMonitor;
        IStatus stat = OK_STATUS;
        IProject ejbproject = ProjectUtilities.getProject((String)this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME"));
        if (ejbproject.exists() && ejbproject.isAccessible()) {
            IFacetedProject facetedProject = null;
            IRuntime runtime = null;
            String javaSourceFolder = "";
            try {
                facetedProject = ProjectFacetsManager.create((IProject)ejbproject);
            }
            catch (CoreException e) {
                EjbPlugin.logError(e);
            }
            if (facetedProject != null) {
                runtime = facetedProject.getRuntime();
                IContainer container = J2EEProjectUtilities.getSourceFolderOrFirst((IProject)ejbproject, null);
                if (container.getType() == 2) {
                    javaSourceFolder = container.getName();
                }
            }
            IProject[] earprojects = EarUtilities.getReferencingEARProjects((IProject)ejbproject);
            String projectName = this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new UtilityProjectCreationDataModelProvider());
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel javadm = map.getFacetDataModel("jst.java");
            IDataModel utildm = map.getFacetDataModel("jst.utility");
            utildm.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
            javadm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projectName);
            javadm.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", (Object)javaSourceFolder);
            javadm.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", (Object)javaSourceFolder);
            if (earprojects.length > 0) {
                utildm.setProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME", (Object)earprojects[0].getName());
            }
            utildm.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
            dm.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)runtime);
            FacetProjectCreationOperation op = new FacetProjectCreationOperation(dm);
            try {
                stat = op.execute(this.monitor, null);
            }
            catch (ExecutionException e) {
                EjbPlugin.logError(e);
            }
            IVirtualComponent c = ComponentCore.createComponent((IProject)ejbproject);
            c.setMetaProperty("ClientProject", projectName);
            String clientURI = this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ");
            c.setMetaProperty("ClientJARURI", clientURI);
            try {
                int i = 0;
                while (i < earprojects.length) {
                    this.runAddClientToEAROperation(earprojects[i].getName(), this.model, this.monitor);
                    ++i;
                }
                this.updateEJBDD(this.model, this.monitor);
                this.moveOutgoingJARDependencies();
                EJBClientJarCreationHelper.copyOutgoingClasspathEntries(ejbproject, ProjectUtilities.getProject((String)projectName), true);
                this.modifyEJBModuleJarDependency(this.model, this.monitor);
                IProject clientProject = ProjectUtilities.getProject((String)this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME"));
                this.moveIncomingJARDependencies(ejbproject, clientProject);
            }
            catch (CoreException e) {
                EjbPlugin.logError(e);
            }
            catch (InvocationTargetException e) {
                EjbPlugin.logError(e);
            }
            catch (InterruptedException e) {
                EjbPlugin.logError(e);
            }
            EJBClientJarCreationHelper helper = new EJBClientJarCreationHelper(ejbproject);
            IDataModel moveModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBClientJarFileMoveDataModelProvider());
            moveModel.setProperty("IEJBClientJarFileMoveDataModelProperties.EJB_PROJECT_NAME", (Object)ejbproject.getName());
            moveModel.setProperty("IEJBClientJarFileMoveDataModelProperties.CLIENT_PROJECT_NAME", (Object)this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME"));
            moveModel.setProperty("IEJBClientJarFileMoveDataModelProperties.FILES_TO_MOVE_MAP", (Object)helper.getFilesToMove());
            moveModel.getDefaultOperation().execute(this.monitor, null);
        }
        return stat;
    }

    protected void runAddClientToEAROperation(String earProjectName, IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        IProject earproject = ProjectUtilities.getProject((String)earProjectName);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earproject);
        String clientProjectName = model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
        IProject clientProject = ProjectUtilities.getProject((String)clientProjectName);
        IVirtualComponent component = ComponentCore.createComponent((IProject)clientProject);
        if (earComp.exists() && component.exists()) {
            IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
            List modList = (List)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
            modList.add(component);
            dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
            String clientURI = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ");
            ((Map)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP")).put(component, clientURI);
            try {
                dm.getDefaultOperation().execute(monitor, null);
            }
            catch (ExecutionException e) {
                EjbPlugin.logError(e);
            }
        }
    }

    protected void runAddClientToEJBOperation(IDataModel model, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        String ejbprojectName = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
        IProject ejbProj = ProjectUtilities.getProject((String)ejbprojectName);
        IVirtualComponent ejbcomponent = ComponentCore.createComponent((IProject)ejbProj);
        String clientProjectName = model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
        IProject clientProject = ProjectUtilities.getProject((String)clientProjectName);
        IVirtualComponent ejbclientcomponent = ComponentCore.createComponent((IProject)clientProject);
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)ejbcomponent);
        List modList = (List)dm.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modList.add(ejbclientcomponent);
        dm.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
        try {
            dm.getDefaultOperation().execute(monitor, null);
        }
        catch (ExecutionException e) {
            EjbPlugin.logError(e);
        }
    }

    private void modifyEJBModuleJarDependency(IDataModel model, IProgressMonitor aMonitor) throws InvocationTargetException, InterruptedException {
        String ejbprojectName = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
        IProject ejbProj = ProjectUtilities.getProject((String)ejbprojectName);
        IVirtualComponent ejbComponent = ComponentCore.createComponent((IProject)ejbProj);
        IVirtualFile vf = ejbComponent.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile manifestmf = vf.getUnderlyingFile();
        String clientURI = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.CLIENT_URI ");
        IDataModel updateManifestDataModel = DataModelFactory.createDataModel(UpdateManifestDataModelProvider.class);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)ejbprojectName);
        updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)manifestmf);
        updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", (Object)UpdateManifestDataModelProvider.convertClasspathStringToList((String)clientURI));
        try {
            updateManifestDataModel.getDefaultOperation().execute(aMonitor, null);
        }
        catch (Exception e) {
            EjbPlugin.logError(e);
        }
    }

    private void updateEJBDD(final IDataModel model, IProgressMonitor monitor) {
        String ejbprojectName = model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME");
        final IProject ejbProj = ProjectUtilities.getProject((String)ejbprojectName);
        if (!this.hasDeploymentDescriptor(ejbProj)) {
            IDataModel dataModel = DataModelFactory.createDataModel(IEJBCreateDeploymentFilesDataModelProperties.class);
            dataModel.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)ejbProj);
            try {
                dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                EjbPlugin.logError(e);
            }
        }
        IModelProvider ejbModel = ModelProviderManager.getModelProvider((IProject)ejbProj);
        ejbModel.modify(new Runnable(){

            @Override
            public void run() {
                IModelProvider writableEjbModel = ModelProviderManager.getModelProvider((IProject)ejbProj);
                Object modelObject = writableEjbModel.getModelObject();
                String clientProjectName = model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
                IVirtualComponent c = ComponentCore.createComponent((IProject)ejbProj);
                Properties props = c.getMetaProperties();
                String clienturi = props.getProperty("ClientJARURI");
                if (modelObject instanceof EJBJar) {
                    EJBJar ejbres = (EJBJar)writableEjbModel.getModelObject();
                    if (clienturi != null && !clienturi.equals("")) {
                        ejbres.setEjbClientJar(clienturi);
                    } else {
                        ejbres.setEjbClientJar(String.valueOf(clientProjectName) + ".jar");
                    }
                } else {
                    org.eclipse.jst.j2ee.ejb.EJBJar ejbres = (org.eclipse.jst.j2ee.ejb.EJBJar)writableEjbModel.getModelObject();
                    if (clienturi != null && !clienturi.equals("")) {
                        ejbres.setEjbClientJar(clienturi);
                    } else {
                        ejbres.setEjbClientJar(String.valueOf(clientProjectName) + ".jar");
                    }
                }
            }
        }, null);
    }

    private void moveIncomingJARDependencies(IProject ejbProject, IProject clientProject) throws InvocationTargetException, InterruptedException {
        InvertClientJARDependencyCompoundOperation op = new InvertClientJARDependencyCompoundOperation(EarUtilities.getReferencingEARProjects((IProject)ejbProject), ejbProject, clientProject);
        try {
            op.execute(this.createSubProgressMonitor(1), null);
        }
        catch (ExecutionException e) {
            EjbPlugin.logError(e);
        }
    }

    protected IProgressMonitor createSubProgressMonitor(int ticks) {
        return new SubProgressMonitor(this.monitor, ticks);
    }

    private void moveOutgoingJARDependencies() throws InvocationTargetException, InterruptedException {
        IProject ejbProject = ProjectUtilities.getProject((String)this.model.getStringProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME"));
        String clientProjectName = this.model.getStringProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME");
        ArchiveManifest ejbMf = J2EEProjectUtilities.readManifest((IProject)ejbProject);
        if (ejbMf == null) {
            return;
        }
        String[] mfEntries = ejbMf.getClassPathTokenized();
        if (mfEntries.length == 0) {
            return;
        }
        IProject[] earProjects = EarUtilities.getReferencingEARProjects((IProject)ejbProject);
        IProject clientProject = ResourcesPlugin.getWorkspace().getRoot().getProject(clientProjectName);
        IProgressMonitor sub = this.createSubProgressMonitor(earProjects.length * 2);
        int i = 0;
        while (i < earProjects.length) {
            List normalized = EJBClientJarCreationHelper.normalize(mfEntries, earProjects[i], ejbProject, true);
            UpdateManifestOperation addOp = new EJBClientManifestUtility().getAddOperation(clientProject, earProjects[i], normalized);
            UpdateManifestOperation removeOp = new EJBClientManifestUtility().getRemoveOperation(ejbProject, earProjects[i], normalized, null);
            try {
                addOp.execute((IProgressMonitor)new SubProgressMonitor(sub, 1), null);
                removeOp.execute((IProgressMonitor)new SubProgressMonitor(sub, 1), null);
            }
            catch (ExecutionException e) {
                EjbPlugin.logError(e);
            }
            ++i;
        }
    }

    private boolean hasDeploymentDescriptor(IProject project) {
        boolean ret = true;
        Path ddFilePath = new Path("META-INF/ejb-jar.xml");
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component.getRootFolder() != null && component.getRootFolder().getUnderlyingFolder() != null) {
            IFile ddXmlFile = component.getRootFolder().getUnderlyingFolder().getFile((IPath)ddFilePath);
            ret = ddXmlFile.exists();
        }
        return ret;
    }
}

