/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.predicate.int_;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.internal.predicate.int_.AND;
import org.eclipse.jpt.common.utility.internal.predicate.int_.AnyFlagsAreOff;
import org.eclipse.jpt.common.utility.internal.predicate.int_.AnyFlagsAreSet;
import org.eclipse.jpt.common.utility.internal.predicate.int_.DisabledIntPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.int_.Equals;
import org.eclipse.jpt.common.utility.internal.predicate.int_.False;
import org.eclipse.jpt.common.utility.internal.predicate.int_.FlagIsOff;
import org.eclipse.jpt.common.utility.internal.predicate.int_.FlagIsSet;
import org.eclipse.jpt.common.utility.internal.predicate.int_.IntPredicateWrapper;
import org.eclipse.jpt.common.utility.internal.predicate.int_.IsEven;
import org.eclipse.jpt.common.utility.internal.predicate.int_.IsGreaterThan;
import org.eclipse.jpt.common.utility.internal.predicate.int_.IsGreaterThanOrEqual;
import org.eclipse.jpt.common.utility.internal.predicate.int_.IsLessThan;
import org.eclipse.jpt.common.utility.internal.predicate.int_.IsLessThanOrEqual;
import org.eclipse.jpt.common.utility.internal.predicate.int_.IsOdd;
import org.eclipse.jpt.common.utility.internal.predicate.int_.NOT;
import org.eclipse.jpt.common.utility.internal.predicate.int_.NotEqual;
import org.eclipse.jpt.common.utility.internal.predicate.int_.OR;
import org.eclipse.jpt.common.utility.internal.predicate.int_.OnlyFlagIsOff;
import org.eclipse.jpt.common.utility.internal.predicate.int_.OnlyFlagIsSet;
import org.eclipse.jpt.common.utility.internal.predicate.int_.True;
import org.eclipse.jpt.common.utility.internal.predicate.int_.XOR;
import org.eclipse.jpt.common.utility.predicate.CompoundIntPredicate;
import org.eclipse.jpt.common.utility.predicate.IntPredicate;

public class IntPredicateTools {
    public static final IntPredicate[] EMPTY_ARRAY = new IntPredicate[0];

    public static IntPredicate true_() {
        return True.instance();
    }

    public static IntPredicate false_() {
        return False.instance();
    }

    public static IntPredicate isEven() {
        return IsEven.instance();
    }

    public static IntPredicate isOdd() {
        return IsOdd.instance();
    }

    public static IntPredicate disabledIntPredicate() {
        return DisabledIntPredicate.instance();
    }

    public static IntPredicate isEqual(int criterion) {
        return new Equals(criterion);
    }

    public static IntPredicate notEqual(int criterion) {
        return new NotEqual(criterion);
    }

    public static IntPredicate isGreaterThan(int criterion) {
        return new IsGreaterThan(criterion);
    }

    public static IntPredicate isGreaterThanOrEqual(int criterion) {
        return new IsGreaterThanOrEqual(criterion);
    }

    public static IntPredicate isLessThan(int criterion) {
        return new IsLessThan(criterion);
    }

    public static IntPredicate isLessThanOrEqual(int criterion) {
        return new IsLessThanOrEqual(criterion);
    }

    public static IntPredicate flagIsSet(int flag) {
        return new FlagIsSet(flag);
    }

    public static IntPredicate flagIsOff(int flag) {
        return new FlagIsOff(flag);
    }

    public static IntPredicate onlyFlagIsSet(int flag) {
        return new OnlyFlagIsSet(flag);
    }

    public static IntPredicate onlyFlagIsOff(int flag) {
        return new OnlyFlagIsOff(flag);
    }

    public static IntPredicate anyFlagsAreSet(int flags) {
        return new AnyFlagsAreSet(flags);
    }

    public static IntPredicate anyFlagsAreOff(int flags) {
        return new AnyFlagsAreOff(flags);
    }

    public static CompoundIntPredicate and(Iterable<IntPredicate> predicates) {
        return IntPredicateTools.and(predicates.iterator());
    }

    public static CompoundIntPredicate and(Iterator<IntPredicate> predicates) {
        return IntPredicateTools.and(IteratorTools.toArray(predicates, EMPTY_ARRAY));
    }

    public static CompoundIntPredicate and(IntPredicate ... predicates) {
        return new AND(predicates);
    }

    public static CompoundIntPredicate or(Iterable<IntPredicate> predicates) {
        return IntPredicateTools.or(predicates.iterator());
    }

    public static CompoundIntPredicate or(Iterator<IntPredicate> predicates) {
        return IntPredicateTools.or(IteratorTools.toArray(predicates, EMPTY_ARRAY));
    }

    public static CompoundIntPredicate or(IntPredicate ... predicates) {
        return new OR(predicates);
    }

    public static CompoundIntPredicate xor(IntPredicate predicate1, IntPredicate predicate2) {
        return new XOR(predicate1, predicate2);
    }

    public static IntPredicate nand(Iterable<IntPredicate> predicates) {
        return IntPredicateTools.nand(predicates.iterator());
    }

    public static IntPredicate nand(Iterator<IntPredicate> predicates) {
        return IntPredicateTools.nand(IteratorTools.toArray(predicates, EMPTY_ARRAY));
    }

    public static IntPredicate nand(IntPredicate ... predicates) {
        return IntPredicateTools.not(IntPredicateTools.and(predicates));
    }

    public static IntPredicate nor(Iterable<IntPredicate> predicates) {
        return IntPredicateTools.nor(predicates.iterator());
    }

    public static IntPredicate nor(Iterator<IntPredicate> predicates) {
        return IntPredicateTools.nor(IteratorTools.toArray(predicates, EMPTY_ARRAY));
    }

    public static IntPredicate nor(IntPredicate ... predicates) {
        return IntPredicateTools.not(IntPredicateTools.or(predicates));
    }

    public static IntPredicate xnor(IntPredicate predicate1, IntPredicate predicate2) {
        return IntPredicateTools.not(IntPredicateTools.xor(predicate1, predicate2));
    }

    public static IntPredicate not(IntPredicate predicate) {
        return new NOT(predicate);
    }

    public static IntPredicateWrapper wrap(IntPredicate predicate) {
        return new IntPredicateWrapper(predicate);
    }

    public static IntPredicate[] emptyArray() {
        return EMPTY_ARRAY;
    }

    private IntPredicateTools() {
        throw new UnsupportedOperationException();
    }
}

