/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class PreviewSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> classpaths = new ArrayList<IRuntimeClasspathEntry>();
        classpaths.addAll(Arrays.asList(JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)configuration)));
        ArrayList<FolderSourceContainer> sourcefolderList = new ArrayList<FolderSourceContainer>();
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server != null) {
            IModule[] modules;
            ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
            IModule[] iModuleArray = modules = server.getModules();
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule module = iModuleArray[n2];
                IProject project = module.getProject();
                if (project != null) {
                    IFolder moduleFolder = project.getFolder(module.getName());
                    if (moduleFolder.exists()) {
                        sourcefolderList.add(new FolderSourceContainer((IContainer)moduleFolder, true));
                    }
                    try {
                        IJavaProject javaProject;
                        if (project.hasNature("org.eclipse.jdt.core.javanature") && !list.contains(javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature"))) {
                            list.add(javaProject);
                        }
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
            int size = list.size();
            IJavaProject[] projects = new IJavaProject[size];
            list.toArray(projects);
            IJavaProject[] iJavaProjectArray = projects;
            int n3 = projects.length;
            int n4 = 0;
            while (n4 < n3) {
                IJavaProject project = iJavaProjectArray[n4];
                classpaths.addAll(Arrays.asList(JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)project)));
                ++n4;
            }
        }
        IRuntimeClasspathEntry[] entries = new IRuntimeClasspathEntry[classpaths.size()];
        classpaths.toArray(entries);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ISourceContainer[] sourceContainers = JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
        if (!sourcefolderList.isEmpty()) {
            ISourceContainer[] combinedSourceContainers = new ISourceContainer[sourceContainers.length + sourcefolderList.size()];
            sourcefolderList.toArray(combinedSourceContainers);
            System.arraycopy(sourceContainers, 0, combinedSourceContainers, sourcefolderList.size(), sourceContainers.length);
            sourceContainers = combinedSourceContainers;
        }
        return sourceContainers;
    }
}

