/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.launching.tests;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.wst.xsl.launching.tests.Activator;
import org.eclipse.wst.xsl.launching.tests.EnvironmentTestSetup;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.w3c.dom.Document;

public abstract class AbstractLaunchingTest {
    private static final String XSL_TEST_PROJECT = "XSLTestProject";
    protected static final String XSL_LAUNCH_SHORTCUT_ID = "org.eclipse.wst.xsl.debug.ui.launchshortcut";
    protected static final String LAUNCHCONFIGS = "launchConfigs";
    protected EnvironmentTestSetup env;
    protected IProject testProject;
    protected IFolder folder;

    @Before
    public void setUp() throws Exception {
        this.createProject();
        this.createEmptyLaunchConfigsFolder();
        this.deleteExistingLaunchConfigs();
    }

    private void createProject() throws CoreException {
        this.env = new EnvironmentTestSetup();
        this.testProject = this.env.createProject(XSL_TEST_PROJECT);
    }

    private void createEmptyLaunchConfigsFolder() throws CoreException {
        this.testProject.getFullPath();
        this.folder = this.testProject.getFolder(LAUNCHCONFIGS);
        if (this.folder.exists()) {
            this.folder.delete(true, null);
        }
        this.folder.create(true, true, null);
    }

    private void deleteExistingLaunchConfigs() throws CoreException {
        ILaunchConfiguration[] configs = this.getLaunchManager().getLaunchConfigurations();
        int i = 0;
        while (i < configs.length) {
            configs[i].delete();
            ++i;
        }
    }

    @After
    public void tearDown() throws Exception {
        this.testProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void copyConfigurationToWorkspace(IPath folder, String filename) throws Exception {
        URL url = Activator.getDefault().getBundle().getEntry("testFiles" + File.separator + filename);
        String workspacePath = this.getWorkspacePath();
        File target = new File(String.valueOf(workspacePath) + folder.toPortableString() + File.separator + filename);
        this.copyFile(url, target);
    }

    private String getWorkspacePath() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath rootPath = root.getLocation();
        String workspacePath = rootPath.toPortableString();
        return workspacePath;
    }

    private void copyFile(URL src, File target) throws Exception {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(target));
        BufferedInputStream bis = new BufferedInputStream(src.openStream());
        try {
            while (bis.available() > 0) {
                int size = bis.available();
                if (size > 1024) {
                    size = 1024;
                }
                byte[] b = new byte[size];
                bis.read(b, 0, b.length);
                bos.write(b);
            }
        }
        finally {
            if (bis != null) {
                bis.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }

    protected LaunchShortcutExtension getLaunchShortcutExtension(String id) {
        List exts = this.getLaunchConfigurationManager().getLaunchShortcuts();
        LaunchShortcutExtension ext = null;
        int i = 0;
        while (i < exts.size()) {
            ext = (LaunchShortcutExtension)exts.get(i);
            if (ext.getId().equals(id)) {
                return ext;
            }
            ++i;
        }
        return null;
    }

    protected LaunchConfigurationManager getLaunchConfigurationManager() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager();
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected ILaunch launch(String name) throws Exception {
        ILaunchConfiguration configuration = this.getLaunchConfiguration(name);
        ILaunch launch = configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        return launch;
    }

    protected ILaunchConfiguration getLaunchConfiguration(String mainTypeName) throws Exception {
        ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
        IFile file = this.testProject.getProject().getFolder(LAUNCHCONFIGS).getFile(String.valueOf(mainTypeName) + ".launch");
        ILaunchConfiguration mine = mgr.getLaunchConfiguration(file);
        Assert.assertEquals((String)"Wrong type found: ", (Object)"org.eclipse.wst.xsl.launching.launchConfigurationType", (Object)mine.getType().getIdentifier());
        return mine;
    }

    protected void refreshProject() throws CoreException, InterruptedException {
        this.testProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        while (!this.testProject.isSynchronized(2)) {
            Thread.sleep(1000L);
        }
    }

    protected void launchConfiguration(String launchConfigName) throws Exception {
        ILaunch launch = this.launch(launchConfigName);
        while (!launch.isTerminated()) {
            Thread.sleep(1000L);
        }
        this.refreshProject();
    }

    protected String readFile(InputStream input) {
        String finalString = "";
        try {
            String str;
            BufferedReader in = new BufferedReader(new InputStreamReader(input));
            while ((str = in.readLine()) != null) {
                finalString = String.valueOf(finalString) + str + "\n";
            }
            in.close();
        }
        catch (IOException iOException) {}
        return finalString;
    }

    protected Document parseXml(InputStream contents) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        return builder.parse(contents);
    }
}

