/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.read;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.wst.sse.core.internal.encoding.NonContentBasedEncodingRules;
import org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail;
import org.eclipse.wst.xml.tests.encoding.TestsPlugin;
import org.eclipse.wst.xml.tests.encoding.util.ProjectUnzipUtility;

public class TestContentDescription
extends TestCase {
    private static final boolean DEBUG = true;
    private static boolean fTestProjectInitialized;
    private static final String TEST_PROJECT_NAME = "org.eclipse.encoding.resource.newtests";
    static IProject fTestProject;
    private static int nSetups;

    static {
        nSetups = 0;
    }

    public static void main(String[] args) {
    }

    private static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static void getAndCreateProject() throws CoreException {
        IWorkspace workspace = TestsPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        fTestProject = root.getProject(TEST_PROJECT_NAME);
        TestContentDescription.createProject(fTestProject, null, null);
        fTestProject.refreshLocal(2, null);
        TestContentDescription.assertTrue((boolean)fTestProject.exists());
    }

    protected void setUp() throws Exception {
        super.setUp();
        ++nSetups;
        if (!fTestProjectInitialized) {
            TestContentDescription.getAndCreateProject();
            String destinationProjectString = fTestProject.getLocation().toOSString();
            String destinationFolder = String.valueOf(destinationProjectString) + "/";
            File zipFile = TestsPlugin.getTestFile("testfiles.zip");
            ProjectUnzipUtility projUtil = new ProjectUnzipUtility();
            projUtil.unzipAndImport(zipFile, destinationFolder);
            projUtil.initJavaProject(TEST_PROJECT_NAME);
            fTestProject.refreshLocal(2, null);
            fTestProjectInitialized = true;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (--nSetups == 0) {
            // empty if block
        }
    }

    protected void doTest(String expectedJavaCharset, String filePath, Class expectedException) throws CoreException, IOException {
        if (expectedJavaCharset != null && expectedJavaCharset.indexOf("UTF-32") > -1) {
            return;
        }
        expectedJavaCharset = this.massageCharset(expectedJavaCharset);
        IFile file = (IFile)fTestProject.findMember(filePath);
        TestContentDescription.assertNotNull((String)("Error in test case: file not found: " + filePath), (Object)file);
        IContentDescription fileContentDescription = file.getContentDescription();
        TestContentDescription.assertNotNull((String)"Null content description", (Object)fileContentDescription);
        String foundCharset = fileContentDescription.getCharset();
        foundCharset = this.massageCharset(foundCharset);
        if (expectedJavaCharset == null || expectedJavaCharset.equals("expectPlatformCharset")) {
            String platformDefault = NonContentBasedEncodingRules.useDefaultNameRules(null);
            TestContentDescription.assertTrue((boolean)foundCharset.equals(platformDefault));
        } else {
            boolean asExpected = foundCharset.equals(expectedJavaCharset);
            TestContentDescription.assertTrue((String)(String.valueOf(foundCharset) + " did not equal the expected " + expectedJavaCharset + " (this is a VM dependent test)"), (boolean)asExpected);
        }
    }

    private String massageCharset(String foundCharset) {
        String result = foundCharset;
        if ("UTF-16LE".equals(foundCharset)) {
            result = "UTF-16";
        } else if ("X-UnicodeLittle".equals(foundCharset)) {
            result = "UTF-16";
        } else if ("X-UnicodeBig".equals(foundCharset)) {
            result = "UTF-16BE";
        }
        return result;
    }

    public void testFile1() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", "testfiles/css/emptyFile.css", null);
    }

    public void testFile2() throws CoreException, IOException {
        this.doTest("EUC-JP", "testfiles/css/encoding_test_eucjp.css", null);
    }

    public void testFile3() throws CoreException, IOException {
        this.doTest("ISO-2022-JP", "testfiles/css/encoding_test_jis.css", null);
    }

    public void testFile4() throws CoreException, IOException {
        this.doTest("Shift_JIS", "testfiles/css/encoding_test_sjis.css", null);
    }

    public void testFile5() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", "testfiles/css/noEncoding.css", null);
    }

    public void testFile6() throws CoreException, IOException {
        this.doTest("ISO-8859-6", "testfiles/css/nonStandard.css", null);
    }

    public void testFile7() throws CoreException, IOException {
        this.doTest("ISO-8859-6", "testfiles/css/nonStandardIllFormed.css", null);
    }

    public void testFile8() throws CoreException, IOException {
        this.doTest("ISO-8859-6", "testfiles/css/nonStandardIllFormed2.css", null);
    }

    public void testFile57() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", "testfiles/html/EmptyFile.html", null);
    }

    public void testFile58() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/html/IllformedNormalNonDefault.html", null);
    }

    public void testFile59() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", "testfiles/html/LargeNoEncoding.html", null);
    }

    public void testFile60() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/html/LargeNonDefault.html", null);
    }

    public void testFile61() throws CoreException, IOException {
        this.doTest("ISO-8859-6", "testfiles/html/MultiNonDefault.html", null);
    }

    public void testFile62() throws CoreException, IOException {
        this.doTest("expectPlatformCharset", "testfiles/html/NoEncoding.html", null);
    }

    public void testFile63() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/html/noquotes.html", null);
    }

    public void testFile64() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/html/NormalNonDefault.html", null);
    }

    public void testFile65() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/EmptyFile.jsp", null);
    }

    public void testFile66() throws CoreException, IOException {
        this.doTest("ISO-8859-8", "testfiles/jsp/IllformedNormalNonDefault.jsp", null);
    }

    public void testFile67() throws CoreException, IOException {
        this.doTest("abc", "testfiles/jsp/inValidEncodingValue.jsp", UnsupportedCharsetExceptionWithDetail.class);
    }

    public void testFile68() throws CoreException, IOException {
        this.doTest("windows-1252", "testfiles/jsp/javaEncodingValue.jsp", null);
    }

    public void testFile69() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/MalformedNoEncoding.jsp", null);
    }

    public void testFile70() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/MalformedNoEncodingXSL.jsp", null);
    }

    public void testFile71() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/noEncoding.jsp", null);
    }

    public void testFile72() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/NoEncodinginXMLDecl.jsp", null);
    }

    public void testFile73() throws CoreException, IOException {
        this.doTest("ISO-8859-2", "testfiles/jsp/nomalDirectiveCase.jsp", null);
    }

    public void testFile74() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/nomalDirectiveCaseNoEncoding.jsp", null);
    }

    public void testFile75() throws CoreException, IOException {
        this.doTest("ISO-8859-3", "testfiles/jsp/nomalDirectiveCaseUsingCharset.jsp", null);
    }

    public void testFile76() throws CoreException, IOException {
        this.doTest("ISO-8859-2", "testfiles/jsp/nomalDirectiveCaseUsingXMLSyntax.jsp", null);
    }

    public void testFile77() throws CoreException, IOException {
        this.doTest("ISO-8859-8", "testfiles/jsp/NormalNonDefault.jsp", null);
    }

    public void testFile78() throws CoreException, IOException {
        this.doTest("ISO-8859-8", "testfiles/jsp/NormalNonDefaultWithXMLDecl.jsp", null);
    }

    public void testFile79() throws CoreException, IOException {
        this.doTest("ISO-8859-7", "testfiles/jsp/NormalPageCaseNonDefault.jsp", null);
    }

    public void testFile80() throws CoreException, IOException {
        this.doTest("Shift_JIS", "testfiles/jsp/SelColBeanRow12ResultsForm.jsp", null);
    }

    public void testFile81() throws CoreException, IOException {
        this.doTest("ISO-8859-3", "testfiles/jsp/testBrokenLine.jsp", null);
    }

    public void testFile82() throws CoreException, IOException {
        this.doTest("testjunk", "testfiles/jsp/testDefaultEncoding.jsp", UnsupportedCharsetExceptionWithDetail.class);
    }

    public void testFile83() throws CoreException, IOException {
        this.doTest("testjunk", "testfiles/jsp/testDefaultEncodingWithJunk.jsp", UnsupportedCharsetExceptionWithDetail.class);
    }

    public void testFile84() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/testExtraJunk.jsp", null);
    }

    public void testFile85() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/jsp/testExtraValidStuff.jsp", null);
    }

    public void testFile86() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/testIllFormed.jsp", null);
    }

    public void testFile87() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/jsp/testIllFormed2.jsp", null);
    }

    public void testFile88() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/testNoEncodingValue.jsp", null);
    }

    public void testFile89() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/testNoPageDirective.jsp", null);
    }

    public void testFile90() throws CoreException, IOException {
        this.doTest("ISO-8859-2", "testfiles/jsp/testNoPageDirectiveAtFirst.jsp", null);
    }

    public void testFile91() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/jsp/testNoPageDirectiveInLargeFile.jsp", null);
    }

    public void testFile92() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/jsp/testNormalCase.jsp", null);
    }

    public void testFile93() throws CoreException, IOException {
        this.doTest("UTF-16", "testfiles/jsp/testUTF16.jsp", null);
    }

    public void testFile94() throws CoreException, IOException {
        this.doTest("UTF-16LE", "testfiles/jsp/utf16UnicodeStreamWithNoEncodingInHeader2.jsp", null);
    }

    public void testFile95() throws CoreException, IOException {
        this.doTest("UTF-16", "testfiles/jsp/utf16UnicodeStreamWithNoEncodingInHeaderBE.jsp", null);
    }

    public void testFile96() throws CoreException, IOException {
        this.doTest("UTF-16", "testfiles/jsp/utf16WithJapaneseChars.jsp", null);
    }

    public void testFile97() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/jsp/UTF8With3ByteBOM.jsp", null);
    }

    public void testFile98() throws CoreException, IOException {
        this.doTest("ISO-8859-8", "testfiles/jsp/WellFormedNormalNonDefault.jsp", null);
    }

    public void testFile99() throws CoreException, IOException {
        this.doTest("Shift_JIS", "testfiles/regressionTestFiles/defect223365/SelColBeanRow12ResultsForm.jsp", null);
    }

    public void testFile100() throws CoreException, IOException {
        this.doTest("Shift_JIS", "testfiles/regressionTestFiles/defect223365/SelColBeanRow12ResultsFormB.jsp", null);
    }

    public void testFile101() throws CoreException, IOException {
        this.doTest("Shift_JIS", "testfiles/regressionTestFiles/defect224293/testshiftjisXmlSyntax.jsp", null);
    }

    public void testFile102() throws CoreException, IOException {
        this.doTest("Shift_JIS", "testfiles/regressionTestFiles/defect229667/audi.jsp", null);
    }

    public void testFile103() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/EmptyFile.xml", null);
    }

    public void testFile104() throws CoreException, IOException {
        this.doTest("EUC-JP", "testfiles/xml/eucjp.xml", null);
    }

    public void testFile108() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/NoEncoding.xml", null);
    }

    public void testFile109() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/xml/NormalNonDefault.xml", null);
    }

    public void testFile110() throws CoreException, IOException {
        this.doTest("Shift_JIS", "testfiles/xml/shiftjis.xml", null);
    }

    public void testFile111() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/xml/testExtraJunk.xml", null);
    }

    public void testFile112() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/testExtraValidStuff.xml", null);
    }

    public void testFile114() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/testIllFormed2.xml", null);
    }

    public void testFile116() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/testIllFormed4.xml", null);
    }

    public void testFile117() throws CoreException, IOException {
        this.doTest("ISO-8859-1", "testfiles/xml/testMultiLine.xml", null);
    }

    public void testFile118() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/testNoEncodingValue.xml", null);
    }

    public void testFile119() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/testNormalCase.xml", null);
    }

    public void testFile120() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/testNoXMLDecl.xml", null);
    }

    public void testFile121() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/testNoXMLDeclAtFirst.xml", null);
    }

    public void testFile122() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/testNoXMLDeclInLargeFile.xml", null);
    }

    public void testFile124() throws CoreException, IOException {
        this.doTest("UTF-16LE", "testfiles/xml/UTF16LEAtStartOfLargeFile.xml", null);
    }

    public void testFile125() throws CoreException, IOException {
        this.doTest("UTF-16LE", "testfiles/xml/utf16UnicodeStreamWithNoEncodingInHeader2.xml", null);
    }

    public void testFile129() throws CoreException, IOException {
        this.doTest("UTF-8", "testfiles/xml/UTF8With3ByteBOM.xml", null);
    }

    public void testFile130() throws CoreException, IOException {
        this.doTest("UTF-16BE", "testfiles/xml/utf16be.xml", null);
    }

    public void testFile131() throws CoreException, IOException {
        this.doTest("UTF-16LE", "testfiles/xml/utf16le.xml", null);
    }

    public void testFile132() throws CoreException, IOException {
        this.doTest("UTF-16LE", "testfiles/xml/utf16leMalformed.xml", null);
    }

    public void testFile133() throws CoreException, IOException {
        this.doTest("UTF-16BE", "testfiles/xml/utf16beMalformed.xml", null);
    }
}

