/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment;

import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentConfiguration;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentController;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.XSDToFragmentMapper;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDComplexFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDComplexRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDComplexSimpleContentFixFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.impl.XSDComplexSimpleContentRangeFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.util.XSDTypeDefinitionUtil;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.xsd.WSDLPartsToXSDTypeMapper;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;

public class XSDComplexTypeToFragmentMapper
extends XSDToFragmentMapper {
    public XSDComplexTypeToFragmentMapper(XSDToFragmentController controller, WSDLPartsToXSDTypeMapper wsdlToXSDMapper) {
        super(controller, wsdlToXSDMapper);
    }

    @Override
    public IXSDFragment getFragment(XSDToFragmentConfiguration config, String id, String name) {
        XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)config.getXSDComponent();
        int category = complexType.getContentTypeCategory().getValue();
        if (complexType != null && complexType.isMixed()) {
            return this.getXSDDefaultFragment(config, id, name);
        }
        XSDComplexTypeContent complexTypeContent = XSDTypeDefinitionUtil.getXSDComplexTypeContent(complexType);
        if (complexTypeContent != null) {
            return this.getXSDComplexFragment(category, config, id, name);
        }
        return this.getXSDEmptyFragment(config, id, name);
    }

    private IXSDFragment getXSDComplexFragment(int category, XSDToFragmentConfiguration config, String id, String name) {
        int maxOccurs;
        int minOccurs = config.getMinOccurs();
        if (minOccurs == (maxOccurs = config.getMaxOccurs())) {
            if (category == 1) {
                return new XSDComplexSimpleContentFixFragment(id, name, config, this.getController());
            }
            return new XSDComplexFixFragment(id, name, config, this.getController());
        }
        if (category == 1) {
            return new XSDComplexSimpleContentRangeFragment(id, name, config, this.getController());
        }
        return new XSDComplexRangeFragment(id, name, config, this.getController());
    }
}

