/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.tests.testcase;

import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.tests.T6A;
import org.eclipse.wst.validation.tests.testcase.TestEnvironment;

public class TestSuite6
extends TestCase {
    private TestEnvironment _env;
    private IProject _project;
    private IFile _sample;
    private IFile _master;

    public static Test suite() {
        return new TestSuite(TestSuite6.class);
    }

    public TestSuite6(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._env = new TestEnvironment();
        this._env.turnoffAutoBuild();
        this._project = this._env.createProject("TestSuite6");
        IPath first = this._env.addFolder(this._project.getFullPath(), "first");
        this._sample = this._env.addFile(first, "sample.t6a", "include master.t6a");
        this._master = this._env.addFile(first, "master.t6a", "# a dummy file");
        TestEnvironment.enableOnlyThisValidator("org.eclipse.wst.validation.tests.T6A");
    }

    protected void tearDown() throws Exception {
        this._project.delete(true, null);
        this._env.dispose();
        super.tearDown();
    }

    public void testDelete() throws CoreException, UnsupportedEncodingException, InterruptedException {
        Tracing.log((String)"TestSuite6-01: testDelete starting");
        NullProgressMonitor monitor = new NullProgressMonitor();
        T6A.resetCounters();
        this._env.incrementalBuildAndWait((IProgressMonitor)monitor);
        TestSuite6.assertEquals((String)"We do not expect any errors by this point", (int)0, (int)this._env.getErrors((IResource)this._sample));
        this._master.delete(true, (IProgressMonitor)monitor);
        this._env.incrementalBuildAndWait((IProgressMonitor)monitor);
        TestSuite6.assertEquals((String)"The missing depenency should have been reported.", (int)1, (int)this._env.getErrors((IResource)this._sample));
        TestSuite6.assertEquals((String)"The simple version of the validate method should never be called", (int)0, (int)T6A.getCountSimple());
        TestSuite6.assertTrue((String)"The complex method must be called at least once", (T6A.getCountComplex() > 0 ? 1 : 0) != 0);
        Tracing.log((String)"TestSuite6-02:testDelete finished");
    }
}

