/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.TemplatizedType;
import java.util.Set;

public final class CheckForInOverArray
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    final AbstractCompiler compiler;
    final JSTypeRegistry typeRegistry;
    private static final Set<String> GOOG_OBJECT_METHODS = ImmutableSet.of((Object)"goog.object.forEach", (Object)"goog.object.filter", (Object)"goog.object.map", (Object)"goog.object.some", (Object)"goog.object.every", (Object)"goog.object.getCount", (Object[])new String[]{"goog.object.getAnyKey", "goog.object.getAnyValue", "goog.object.contains", "goog.object.getValues", "goog.object.getKeys", "goog.object.findKey", "goog.object.findValue", "goog.object.isEmpty", "goog.object.clear", "goog.object.remove", "goog.object.equals", "goog.object.clone", "goog.object.unsafeClone", "goog.object.transpose"});
    public static final DiagnosticType FOR_IN_OVER_ARRAY = DiagnosticType.warning("JSC_FOR_IN_OVER_ARRAY", "For..in over array is discouraged.");
    public static final DiagnosticType ARRAY_PASSED_TO_GOOG_OBJECT = DiagnosticType.warning("JSC_ARRAY_PASSED_TO_GOOG_OBJECT", "{0} expects an object, not an array. Did you mean to use goog.array?");

    public CheckForInOverArray(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
    }

    public boolean isForInOverArray(Node n) {
        if (NodeUtil.isForIn(n)) {
            Preconditions.checkState((n.getChildCount() == 3 ? 1 : 0) != 0, (Object)n);
            Node child = n.getSecondChild();
            JSType type = child.getJSType();
            if (type != null && this.containsArray(type)) {
                return true;
            }
        }
        return false;
    }

    public boolean isGoogObjectIterationOverArray(Node n) {
        if (!n.isCall()) {
            return false;
        }
        if (!n.getFirstChild().isQualifiedName()) {
            return false;
        }
        String name = n.getFirstChild().getQualifiedName();
        if (!GOOG_OBJECT_METHODS.contains(name)) {
            return false;
        }
        Node firstArg = n.getSecondChild();
        if (firstArg == null) {
            return false;
        }
        JSType type = firstArg.getJSType();
        return type != null && this.containsArray(type);
    }

    private boolean isArray(JSType type) {
        if (type.isArrayType()) {
            return true;
        }
        TemplatizedType templatizedType = type.toMaybeTemplatizedType();
        return templatizedType != null && templatizedType.getReferencedType().isArrayType();
    }

    private boolean containsArray(JSType type) {
        if (this.isArray(type)) {
            return true;
        }
        if (type.isUnionType()) {
            JSType arrayType = this.typeRegistry.getNativeType(JSTypeNative.ARRAY_TYPE);
            for (JSType alternate : type.toMaybeUnionType().getAlternates()) {
                if (!alternate.isSubtype(arrayType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (this.isForInOverArray(n)) {
            this.compiler.report(t.makeError(n, FOR_IN_OVER_ARRAY, new String[0]));
        } else if (this.isGoogObjectIterationOverArray(n)) {
            this.compiler.report(t.makeError(n, ARRAY_PASSED_TO_GOOG_OBJECT, n.getFirstChild().getQualifiedName()));
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }
}

