/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.modelintegration.ui;

import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.ui.JPAEditorMatchingStrategy;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.IModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPADiagramEditorInput;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.util.IEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ModelIntegrationTest {
    private static final String CODE_GENERATED = "CODE_GENERATED";
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;
    private String testProjectName = "Test_" + System.currentTimeMillis();
    IFile entityFile = null;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject(this.testProjectName);
        Assert.assertNotNull((Object)this.jpaProject);
        this.entityFile = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)JPACreateFactory.getPersistentType(this.entityFile));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((PersistentType)EasyMock.isA(PersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)this.entityFile)).anyTimes();
    }

    @Ignore
    @Test
    public void testJPAEditorMatchingStrategyWithEntityFileEditorInputTrue() {
        IEditorReference editorRef = (IEditorReference)EasyMock.createMock(IEditorReference.class);
        IFileEditorInput input = (IFileEditorInput)EasyMock.createMock(IFileEditorInput.class);
        EasyMock.expect((Object)input.getFile()).andStubReturn((Object)this.entityFile);
        EasyMock.expect((Object)input.getName()).andStubReturn((Object)CODE_GENERATED);
        ICompilationUnit cu = this.createCompilationUnitFrom(this.entityFile);
        IJPAEditorUtil ut = (IJPAEditorUtil)EasyMock.createMock(IJPAEditorUtil.class);
        PersistentType inputJptType = JPACreateFactory.getPersistentType(this.entityFile);
        EasyMock.expect((Object)ut.getJPType(cu)).andStubReturn((Object)inputJptType);
        EasyMock.expect((Object)this.featureProvider.getJPAEditorUtil()).andStubReturn((Object)ut);
        Diagram d = (Diagram)EasyMock.createMock(Diagram.class);
        IJPADiagramEditorInput dEdInput = (IJPADiagramEditorInput)EasyMock.createMock(IJPADiagramEditorInput.class);
        try {
            EasyMock.expect((Object)editorRef.getEditorInput()).andStubReturn((Object)dEdInput);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        EasyMock.expect((Object)dEdInput.getDiagram()).andStubReturn((Object)d);
        IDiagramTypeProvider dtp = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.expect((Object)this.featureProvider.getDiagramTypeProvider()).andStubReturn((Object)dtp);
        IModelIntegrationUtil moinIntUtil = (IModelIntegrationUtil)EasyMock.createMock(IModelIntegrationUtil.class);
        EasyMock.expect((Object)this.featureProvider.getMoinIntegrationUtil()).andStubReturn((Object)moinIntUtil);
        EasyMock.expect((Object)moinIntUtil.getProjectByDiagram(d)).andStubReturn((Object)this.jpaProject);
        PictogramElement pe = (PictogramElement)EasyMock.createMock(PictogramElement.class);
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)inputJptType)).andStubReturn((Object)pe);
        IDiagramBehavior dEd = (IDiagramBehavior)EasyMock.createMock(IDiagramBehavior.class);
        EasyMock.expect((Object)dtp.getDiagramBehavior()).andStubReturn((Object)dEd);
        IEditor ed = (IEditor)EasyMock.createMock(IEditor.class);
        EasyMock.expect((Object)dtp.getDiagramBehavior()).andStubReturn((Object)dEd);
        EasyMock.expect((Object)dEd.getDiagramContainer()).andStubReturn((Object)ed);
        ed.setPictogramElementForSelection(pe);
        JPAEditorMatchingStrategy str = new JPAEditorMatchingStrategy(this.featureProvider);
        EasyMock.replay((Object[])new Object[]{editorRef, d, dtp, pe, dEd, moinIntUtil, dEdInput, ut, input, this.featureProvider, ed});
        Assert.assertTrue((boolean)str.matches(editorRef, (IEditorInput)input));
    }

    @Ignore
    @Test
    public void testJPAEditorMatchingStrategyWithEntityFileEditorInputFalse() {
        IEditorReference editorRef = (IEditorReference)EasyMock.createMock(IEditorReference.class);
        IFileEditorInput input = (IFileEditorInput)EasyMock.createMock(IFileEditorInput.class);
        EasyMock.expect((Object)input.getFile()).andStubReturn((Object)this.entityFile);
        EasyMock.expect((Object)input.getName()).andStubReturn((Object)CODE_GENERATED);
        ICompilationUnit cu = this.createCompilationUnitFrom(this.entityFile);
        IJPAEditorUtil ut = (IJPAEditorUtil)EasyMock.createMock(IJPAEditorUtil.class);
        PersistentType inputJptType = JPACreateFactory.getPersistentType(this.entityFile);
        EasyMock.expect((Object)ut.getJPType(cu)).andStubReturn((Object)inputJptType);
        EasyMock.expect((Object)this.featureProvider.getJPAEditorUtil()).andStubReturn((Object)ut);
        Diagram d = (Diagram)EasyMock.createMock(Diagram.class);
        IJPADiagramEditorInput dEdInput = (IJPADiagramEditorInput)EasyMock.createMock(IJPADiagramEditorInput.class);
        try {
            EasyMock.expect((Object)editorRef.getEditorInput()).andStubReturn((Object)dEdInput);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        EasyMock.expect((Object)dEdInput.getDiagram()).andStubReturn((Object)d);
        IDiagramTypeProvider dtp = (IDiagramTypeProvider)EasyMock.createMock(IDiagramTypeProvider.class);
        EasyMock.expect((Object)this.featureProvider.getDiagramTypeProvider()).andStubReturn((Object)dtp);
        IModelIntegrationUtil moinIntUtil = (IModelIntegrationUtil)EasyMock.createMock(IModelIntegrationUtil.class);
        EasyMock.expect((Object)this.featureProvider.getMoinIntegrationUtil()).andStubReturn((Object)moinIntUtil);
        JpaProject anotherJpaProject = (JpaProject)EasyMock.createMock(JpaProject.class);
        EasyMock.expect((Object)moinIntUtil.getProjectByDiagram(d)).andStubReturn((Object)anotherJpaProject);
        PictogramElement pe = (PictogramElement)EasyMock.createMock(PictogramElement.class);
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)inputJptType)).andStubReturn((Object)pe);
        IDiagramBehavior dEd = (IDiagramBehavior)EasyMock.createMock(IDiagramBehavior.class);
        EasyMock.expect((Object)dtp.getDiagramBehavior()).andStubReturn((Object)dEd);
        dEd.getDiagramContainer().setPictogramElementForSelection(pe);
        JPAEditorMatchingStrategy str = new JPAEditorMatchingStrategy(this.featureProvider);
        EasyMock.replay((Object[])new Object[]{editorRef, d, dtp, pe, dEd, moinIntUtil, anotherJpaProject, dEdInput, ut, input, this.featureProvider});
        Assert.assertFalse((boolean)str.matches(editorRef, (IEditorInput)input));
    }

    @Test
    public void testJPAEditorMatchingStrategyWithJPADiagramEditorInputTrue() {
        IEditorReference editorRef = (IEditorReference)EasyMock.createMock(IEditorReference.class);
        EasyMock.expect((Object)editorRef.getPartName()).andStubReturn((Object)"ProjectName");
        IJPADiagramEditorInput input = (IJPADiagramEditorInput)EasyMock.createMock(IJPADiagramEditorInput.class);
        EasyMock.expect((Object)input.getProjectName()).andStubReturn((Object)"ProjectName");
        JPAEditorMatchingStrategy str = new JPAEditorMatchingStrategy(this.featureProvider);
        EasyMock.replay((Object[])new Object[]{editorRef, input, this.featureProvider});
        Assert.assertTrue((boolean)str.matches(editorRef, (IEditorInput)input));
    }

    @Test
    public void testJPAEditorMatchingStrategyWithJPADiagramEditorInputFalse() {
        IEditorReference editorRef = (IEditorReference)EasyMock.createMock(IEditorReference.class);
        EasyMock.expect((Object)editorRef.getPartName()).andStubReturn((Object)"ProjectName");
        IJPADiagramEditorInput input = (IJPADiagramEditorInput)EasyMock.createMock(IJPADiagramEditorInput.class);
        EasyMock.expect((Object)input.getProjectName()).andStubReturn((Object)"DifferentProjectName");
        JPAEditorMatchingStrategy str = new JPAEditorMatchingStrategy(this.featureProvider);
        EasyMock.replay((Object[])new Object[]{editorRef, input, this.featureProvider});
        Assert.assertFalse((boolean)str.matches(editorRef, (IEditorInput)input));
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    @After
    public void tearDown() throws Exception {
        this.deleteAllProjects();
    }

    private void deleteAllProjects() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        IProject project = this.jpaProject.getProject();
        project.close((IProgressMonitor)monitor);
        project.delete(true, true, (IProgressMonitor)monitor);
    }
}

