/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.List;
import java.util.Vector;
import javax.wsdl.BindingOperation;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BP1212
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1212(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document doc = entryContext.getMessageEntryDocument();
            Element soapOperation = null;
            if (this.validator.isFault(doc) || (soapOperation = this.validator.getSoapBodyChild(doc)) == null) {
                throw new AssertionNotApplicableException();
            }
            QName operationQName = new QName(soapOperation.getNamespaceURI(), soapOperation.getLocalName());
            BindingOperation[] rpcBindingOperations = this.validator.getMatchingBindingOps("rpc", this.validator.analyzerContext.getCandidateInfo().getBindings());
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), operationQName, rpcBindingOperations);
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            List operationMessageParts = null;
            List extElems = null;
            if (entryContext.getMessageEntry().getType().equals("request")) {
                operationMessageParts = bindingOperation.getOperation().getInput().getMessage().getOrderedParts(null);
                if (bindingOperation.getBindingInput() != null) {
                    extElems = bindingOperation.getBindingInput().getExtensibilityElements();
                }
            } else {
                operationMessageParts = bindingOperation.getOperation().getOutput().getMessage().getOrderedParts(null);
                if (bindingOperation.getBindingOutput() != null) {
                    extElems = bindingOperation.getBindingOutput().getExtensibilityElements();
                }
            }
            Vector accessors = XMLUtils.getChildElements(soapOperation);
            List orderedPartNames = this.validator.orderPartNames(operationMessageParts, extElems);
            for (String partName : orderedPartNames) {
                if (this.getPartsCount(accessors, partName) == 1) continue;
                throw new AssertionFailException("The name of wsdl:part is " + partName);
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private int getPartsCount(List accessors, String name) {
        int count = 0;
        int i = 0;
        while (i < accessors.size()) {
            Element accessor = (Element)accessors.get(i);
            if (accessor.getLocalName().equals(name)) {
                ++count;
            }
            ++i;
        }
        return count;
    }
}

